/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/60wI
 */

// forked from tkinjo's forked from: Wonderfl Tank Game BulletRenderer Sample 1
// forked from 9re's Wonderfl Tank Game BulletRenderer Sample 1
// このコードを新着弾一覧http://flash-games.wonderfl.net/tank/list/bullets
// に表示させるためにはinfinite-tank-bullet
// というタグを追加してください
package
{
    // ai0
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.system.Security;
    import flash.geom.Matrix;
    //
    // net.wonderfl
    import net.wonderfl.game.infinity_tank.development.*;
    /**
     * @author 9re
     */
    [SWF(backgroundColor="#000000")]
    // クラス名は必ずBulletRendererにして、BulletRendererBaseを拡張して下さい
    // // http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/bullet/BulletRendererBase.html
    public class BulletRenderer extends BulletRendererBase
    {
        private var bullet:BitmapData;
            
        public function BulletRenderer() {
            
            // create bullet
			var bulletCanvas:Sprite = new Sprite();
			bulletCanvas.graphics.beginFill( 0xffffff );
			bulletCanvas.graphics.drawCircle( 0, 0, 3 );
			
			bullet = new BitmapData(6, 6, true, 0);
			bullet.draw( bulletCanvas, new Matrix( 1, 0, 0, 1, 3, 3 ) );
        }
            
        // このメソッドは毎フレーム呼ばれます。
        // _sceneプロパティーについては、詳しくは
        // http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/model/BattleScene.html
        // をご覧下さい 
        override public function draw(bitmapData:BitmapData):void {
                
            bitmapData.lock();
                
            // 弾道の尾を引かせるために前の像をアルファで少し残す
            bitmapData.colorTransform(bitmapData.rect, new ColorTransform(1, 1, 1, 1 - 1/16));
            
            // myBulletListが自分の弾のリスト。このようにfor文で回す
            for (var boundBox:BoundBox = _scene.myBulletList; boundBox != null; boundBox = boundBox.next) {
                
                var point:Point = new Point();
                    
                // i.positionに弾の座標が入ります。中心座標なので、左へ3、上へ3だけずらします
                point.x = boundBox.position.x - 3;
                point.y = boundBox.position.y - 3;
                    
                // bitmapdataに弾のビットマップを座標の所へコピーする
                bitmapData.copyPixels(bullet, bullet.rect, point);
            }
            
            bitmapData.unlock();
        }
    }
}