/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/60fA
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
           vecPnt = new Vector.<xPnt>(0,false);
           var a:xPnt;
           var i:int;
           for(i=0;i<64;i+=1)
           {
             a = new xPnt();
             a.cx = Math.random()*1024-512;
             a.cy = Math.random()*1024-512;   
             a.ang=Math.random()*6.28;
             vecPnt.push(a);
             if (i>3&&i<9){a.spec=1;}
           } //nexti
           
           
          stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
          stage.addEventListener(KeyboardEvent.KEY_UP, onKup);  
          stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public function isKey(k:int):Boolean { return vecKey[k]; }
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false;}
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
            
        public var cx:Number = 235;
        public var cy:Number = 235;
        public var gt:int = 0;
        
        public var vecPnt:Vector.<xPnt>;
        
        
        public function getMag(ax:Number,ay:Number):Number
        { return Math.sqrt(ax*ax+ay*ay); }
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            var ms:Number;ms=8;
            if (isKey(Keyboard.UP)) { cy-=ms;}
            if (isKey(Keyboard.DOWN)) { cy+=ms;}
            if (isKey(Keyboard.LEFT)) { cx-=ms;}
            if (isKey(Keyboard.RIGHT)) { cx+=ms;}
            
            var ax:Number; var ay:Number;
            ax=0;ay=0;
            
            
            if (cx<235||cx>235){ ax=235-cx; cx=235; }
            if (cy<235||cy>235){ ay=235-cy; cy=235; }

            graphics.drawCircle(cx,cy, 16);

            
            var i:int; var num:int; var a:xPnt;
            num = vecPnt.length;
            for (i=0;i<num;i+=1)
            {
              a = vecPnt[i];
              a.cx+=ax; a.cy+=ay; 
              if (a.cx<-512){a.cx+=1024;}
              else if (a.cx>512){a.cx-=1024;}
              if (a.cy<-512){a.cy+=1024;}
              else if (a.cy>512){a.cy-=1024;}

                if(a.spec==1)
                {
                  var ta:Number; var mag:Number;
                  if (gt%60 == 0) { a.gx=cx+Math.cos(a.ang)*64; a.gy=cy+Math.sin(a.ang)*64;}
                  if (gt%30 && Math.random()<0.4) { a.ang+=(Math.random()-0.5)*0.2; }
                  mag = getMag(a.cx-a.gx,a.cy-a.gy);
                  ta = Math.atan2(a.gy-a.cy,a.gx-a.cx);
                  ms=0;
                  if (mag>128) { ms =4;}
                  else if (mag<64){ms=-1;}
                  else { ms=Math.sin(a.ang)*4; ta+=1.57;}
                   a.cx+=Math.cos(ta)*ms;
                   a.cy+=Math.sin(ta)*ms;   
                }              
              
              
              graphics.drawCircle(a.cx,a.cy, 8+a.spec*4);  
                
            }//nexti
            
            
            gt+=1;
            
        }//onenter
        
        
        
        
        
    }//classend
}

internal class xPnt
{
  public var cx:Number = 0;
  public var cy:Number =0;    
  public var gx:Number = 0;
  public var gy:Number = 0;
 public var spec:int = 0;
 public var ang:Number = 0;
     
}//xpnt
