/**
 * Copyright nayu ( http://wonderfl.net/user/nayu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/60bA
 */

// forked from yd_niku's flash on 2009-9-7
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    public class PagerSample extends Sprite{

        private var _currentPage:int;
        private var _totalPages:int;
        private var _btnPrev:Sprite;
        private var _btnNext:Sprite;
        
        private var _numField:TextField;

        public function PagerSample () {
            super();
            
            _currentPage = 0;
            _totalPages= 10;
       
            
            _numField = new TextField();
            addChild( _numField );
            
            _btnPrev = new PageButton("PREV");
            _btnNext= new PageButton("NEXT");
            
            _btnPrev.x = 0;
            _btnPrev.y = 50;
            _btnNext.x = 200 + 40;
            _btnNext.y = 50;
            
            addChild( _btnPrev );
            addChild( _btnNext );
            
            _btnPrev .addEventListener( MouseEvent.CLICK, prevPage );
            _btnNext.addEventListener( MouseEvent.CLICK, nextPage );
            
            for( var i :int = 0; i< _totalPages; ++i ) {
                var num:PageNum = new PageNum( i );
                num.x = i * 20 + 40;
                num.y = 50;
                num.addEventListener( MouseEvent.CLICK, numPage );
                addChild( num );
            }
            
            
            updatePager();
        }
        
        private function nextPage( e:MouseEvent ) :void {
            _currentPage = Math.min( _totalPages -1, _currentPage +1 );
            
            updatePager();
        }
        
        private function prevPage( e:MouseEvent ) :void {
            _currentPage = Math.max( 0, _currentPage -1 );
            
            updatePager();
        }

        private function numPage( e:MouseEvent ) :void {
            var num:PageNum = e.target as PageNum;
            _currentPage = num.index;
            
            updatePager();
        }
        
        private function updatePager():void {
            _numField.text = String( _currentPage +1 ) + "/" + _totalPages + " Page";
            
            if( _currentPage == 0 ) {
                _btnPrev.mouseEnabled = false;
            }
            else {
                _btnPrev.mouseEnabled = true;    
            }
            
            if( _currentPage == (_totalPages -1) ) {
                _btnNext.mouseEnabled = false;
            }
            else {
                _btnNext.mouseEnabled = true;    
            }    
        }

    }

}

import flash.display.Sprite ;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
class PageNum extends Sprite {
    
    private var _index:uint;
    public function PageNum( num:uint ) {
        _index = num;
        
        var textField: TextField = new TextField();
        textField.autoSize = TextFieldAutoSize.LEFT;
        textField.text = String( num +1 );

        addChild( textField );
        mouseChildren = false;
        buttonMode = true;
    }
    
    public function get index():uint {
        return _index;
    }
}

class PageButton extends Sprite {
    public function PageButton ( label:String ) {
        var textField: TextField = new TextField();
        textField.autoSize = TextFieldAutoSize.LEFT;
        textField.text = label;
        addChild( textField );
        mouseChildren = false;
        buttonMode = true;
    }
}
