/**
 * Copyright primevision ( http://wonderfl.net/user/primevision )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/60Tn
 */

// forked from checkmate's fladdict challenge for amateurs
/**
 * Every frame you get screen caputre of the stage.
 * Generate new frame image with using last frames screen capture.
 * This is a starting point of recursive generative art.
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.ColorMatrixFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.getTimer;
	
    public class Beginner extends Sprite {
        /**
         * Overwrite this update function.
         * Every frame the function is invoked with two bitmaps.
         * First one contains reference to the stage bitmap.
         * Second one contains static copy of stage.
         */
         
        public var canvas:BitmapData;
        public var drawHere:BitmapData;
        public var mat:Matrix;
         
        public function update():void{
            drawStep();
            transformStep();
            
            renderStep();
            fadeStep();
        }
        
        private var ss:Number = 0;
        private var ds:Number = Math.PI/180*30;
        private var ss2:Number = 0;
        private var ds2:Number = Math.PI / 180 * 0.1;
        public function drawStep():void {
			for (var i:int = 0 ; i < 2 ; i++) {
				var sp:Sprite = new Sprite();
				ss += ds;
				ss2 += ds2;
				var rr:Number = 50;
				var xx:Number = Math.cos(ss) * rr + 240;
				var yy:Number = Math.sin(ss) * rr + 240;
				sp.graphics.beginFill(0xFF * 0x01FFFF + xx / 480 * 0xFF * 0x01FF + yy / 480 * 0xFF);
				sp.graphics.drawCircle(xx, yy, 8);
				sp.graphics.endFill();
				drawHere.draw(sp);
			}
        }
    
        
        public function transformStep():void {
			ss2 += ds2;
            mat = new Matrix();
            mat.translate(-240,-240);
            mat.scale(1.02,1.02);
            mat.rotate(Math.sin(ss2) / 2);
            mat.translate(240, 240);
        }
        
        
        public function renderStep():void {
            canvas.draw(drawHere, mat, null);
        }
        
        
        public function fadeStep():void {
			canvas.applyFilter(canvas, canvas.rect, new Point(), new BlurFilter(4, 4, 3));
			canvas.colorTransform(canvas.rect, new ColorTransform(1.03,1.03,1.03,1,0,0,0,0));
        }
        
        
        /**
         * ---------------------------------------
         * DO NOT CHANGE FOLLOWING CODES
         * DO NOT ACCESS FOLLOWING PROPERTIES DIRECTLY
         * ---------------------------------------
        */
        
       
        private var bitmap:Bitmap;
        
        
        public function Beginner() {
            canvas = new BitmapData(480,480,false,0x000000);
            bitmap = new Bitmap(canvas);
            addChild(bitmap);
            addEventListener(Event.ENTER_FRAME, _update);
        }
        
        public function _update(e:Event):void{
            if(drawHere)
                drawHere.dispose();
            drawHere = canvas.clone();
            update();
        }
    }
}
