/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/60Hf
 */

// forked from greentec's Random Snowflake
// forked from greentec's Snowflake
package {
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.display.BlendMode;
    import flash.utils.ByteArray;
    import flash.geom.ColorTransform;

    public class FlashTest extends Sprite {
        
        public var _bitmapData:BitmapData;
        public var _bitmap:Bitmap;
        
        public var neighbors:Array = [];
        public var mapSize:int = 29;
        public var map:Array = [];
        public var cloneMap:Array;
        
        public var edgeLength:int = 5;
        public var edgeW:int;
        public var edgeH:int;
        
        public var _width:int = 465;
        public var _height:int = 465;
        
        public var oneCell:Sprite;
        public var gen:int = 0;
        //public var _label:Label;
        
        public var rules:Array = [];
        public var ruleLabel:Label;
        
        public function FlashTest() {
            // write as3 code here..
            stage.scaleMode = "noScale";
            
            _bitmapData = new BitmapData(_width, _height, false, 0x0);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            oneCell = new Sprite();
            var _G:Graphics = oneCell.graphics;
            var i:int;
            var angle:Number;
            
            _G.clear();
            _G.beginFill(0xddddff);
            _G.moveTo(edgeLength, 0);
            for (i = 1; i <= 6; i += 1)
            {
                angle = 2 * Math.PI / 6 * i;
                _G.lineTo(edgeLength * Math.cos(angle), edgeLength * Math.sin(angle));
            }
            _G.endFill();
            
            for (i = 0; i < 6; i += 1)
            {
                neighbors[i] = [];
            }
            neighbors[0] = [+1, -1, 0];
            neighbors[1] = [+1, 0, -1];
            neighbors[2] = [0, +1, -1];
            neighbors[3] = [-1, +1, 0];
            neighbors[4] = [-1, 0, +1];
            neighbors[5] = [0, -1, +1];
            
            edgeW = edgeLength * 3 / 2;
            edgeH = edgeLength * Math.sqrt(3) / 2;
            
            ruleLabel = new Label(this, 10, 10, "");
            ruleLabel.transform.colorTransform = new ColorTransform(0, 0, 0, 1, 255, 255, 255, 0);
            initRules();
            
            initMap();
            //map[0][0][0] = true;
            for (i = 0; i < 6; i += 1)
            {
                map[neighbors[i][0]][neighbors[i][1]][neighbors[i][2]] = true;
            }
            
            //_label = new Label(this, 10, 10, "gen : " + String(gen));
            
            var _thisRuleAgain:PushButton = new PushButton(this, 10, 465 - 30, "This Again", onThisRuleAgain);
            var _randomRuleAgain:PushButton = new PushButton(this, _thisRuleAgain.x + _thisRuleAgain.width + 10, _thisRuleAgain.y, "ランダム", onRandomRuleAgain);
                        
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        public function resetRules():void
        {
            var i:int;
            for (i = 0; i < 7; i += 1)
            {
                rules[i]= int(Math.random() * 2);
            }
            
            var str:String = "Rule : ";
            for (i = 0; i < 7; i += 1)
            {
                str += String(rules[i]);
            }
            ruleLabel.text = str;
        }
        
        public function onRandomRuleAgain(e:Event):void
        {
            removeEventListener(Event.ENTER_FRAME, onLoop);
            resetTiles();
            resetRules();
            gen = 0;

            var i:int;
            for (i = 0; i < 6; i += 1)
            {
                map[neighbors[i][0]][neighbors[i][1]][neighbors[i][2]] = true;
            }
            
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        public function onThisRuleAgain(e:Event):void
        {
            removeEventListener(Event.ENTER_FRAME, onLoop);
            resetTiles();
            gen = 0;

            var i:int;
            for (i = 0; i < 6; i += 1)
            {
                map[neighbors[i][0]][neighbors[i][1]][neighbors[i][2]] = true;
            }
            
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        public function resetTiles():void
        {
            _bitmapData.fillRect(_bitmapData.rect, 0x0);
            
            var i:int, j:int, k:int;
            for (i = -1 * mapSize; i < mapSize + 1; i += 1)
            {
                for (j = -1 * mapSize; j < mapSize + 1; j += 1)
                {
                    for (k = -1 * mapSize; k < mapSize + 1; k += 1)
                    {
                        if (i + j + k == 0)
                        {
                            map[i][j][k] = false;

                        }
                    }
                }
            }
        }
        
        public function initRules():void
        {
            rules = [];
            
            var i:int;
            for (i = 0; i < 7; i += 1)
            {
                rules.push(int(Math.random() * 2));
            }
            
            var str:String = "Rule : ";
            for (i = 0; i < 7; i += 1)
            {
                str += String(rules[i]);
            }

            ruleLabel.text = str;
        }

       
        public function onLoop(e:Event):void
        {
            if (gen < mapSize)
            {
               
                gen += 1;
                
                checkNeighbor();
                drawMap();
               
            }
            
        }
        
        public function drawMap():void
        {
            var i:int, j:int, k:int;
            for (i = -1 * mapSize; i < mapSize + 1; i += 1)
            {
                for (j = -1 * mapSize; j < mapSize + 1; j += 1)
                {
                    for (k = -1 * mapSize; k < mapSize + 1; k += 1)
                    {
                        if (i + j + k == 0)
                        {
                            if (map[i][j][k] == false)
                            {
                                _bitmapData.draw(oneCell, new Matrix(1, 0, 0, 1, _width / 2 + i * edgeW, _height / 2 + (0 - j + k) * edgeH), null, BlendMode.ERASE);
                            }
                            else if (map[i][j][k] == true)
                            {
                                _bitmapData.draw(oneCell, new Matrix(1, 0, 0, 1, _width / 2 + i * edgeW, _height / 2 + (0 - j + k) * edgeH));
                            }
                        }
                    }
                }
            }
        }
        
        public function checkNeighbor():void
        {
            var i:int, j:int, k:int;
            var m:int;
            var tx:int, ty:int, tz:int;
            var neighborNum:int;
            
            cloneMap = clone(map);
            
            for (i = -1 * mapSize; i < mapSize + 1; i += 1)
            {
                for (j = -1 * mapSize; j < mapSize + 1; j += 1)
                {
                    for (k = -1 * mapSize; k < mapSize + 1; k += 1)
                    {
                        if (i + j + k == 0)
                        {
                            neighborNum = 0;
                            
                            for (m = 0; m < 6; m += 1)
                            {
                                tx = neighbors[m][0] + i;
                                ty = neighbors[m][1] + j;
                                tz = neighbors[m][2] + k;
                                
                                if (tx <= mapSize && tx >= -mapSize &&
                                    ty <= mapSize && ty >= -mapSize &&
                                    tz <= mapSize && tz >= -mapSize)
                                {
                                    if (map[tx][ty][tz] == true)
                                    {
                                        neighborNum += 1;
                                    }
                                }
                                
                            }
                            
                            if (rules[neighborNum] == 1)
                            {
                                cloneMap[i][j][k] = true;
                            }
                            else
                            {
                                cloneMap[i][j][k] = false;
                            }
                        }
                    }
                }
            }
            
            map = clone(cloneMap);
            
        }
        
        public function initMap():void
        {
            var i:int, j:int, k:int;
            for (i = -1 * mapSize; i < mapSize + 1; i += 1)
            {
                map[i] = [];
                for (j = -1 * mapSize; j < mapSize + 1; j += 1)
                {
                    map[i][j] = [];
                    for (k = -1 * mapSize; k < mapSize + 1; k += 1)
                    {
                        map[i][j].push(false);
                        //if (i + j + k == 0)
                        //{
                            //map[i][j][k] = false;
                        //}
                    }
                }
            }
        }
        
        public function clone(source:Object):*
        {
            var myBA:ByteArray = new ByteArray();
            myBA.writeObject(source);
            myBA.position = 0;
            return(myBA.readObject()); 
        }
    }
}