/**
 * Copyright paulstamp1 ( http://wonderfl.net/user/paulstamp1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/601m
 */

// forked from paulstamp1's Orbit
/**                                                          
     _____ _____ _____ __       _____ _____ _____ _____ _____ 
    |  _  |  _  |  |  |  |     |   __|_   _|  _  |     |  _  |
    |   __|     |  |  |  |__   |__   | | | |     | | | |   __|
    |__|  |__|__|_____|_____|  |_____| |_| |__|__|_|_|_|__|   
    @paulstamp
                                                       
    This is a work in progress. Its intention was to aid the
    development of a family tree style application.

*/
package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            //bill
            var bill:Node = createNode(stage.stageWidth/2, stage.stageHeight/2);
            addChild( bill );                
            
            var jim:Node = createNode();
            var james:Node = createNode();
            var adam:Node = createNode();
            
            bill.addChildNode( jim );
            bill.addChildNode( james );
            bill.addChildNode( adam );
            
            //jims kids
            var dave:Node = createNode();
            var graham:Node = createNode();
            jim.addChildNode( dave );
            jim.addChildNode( graham );
            
            //james kids
            var burt:Node = createNode();
            var jane:Node = createNode();
            james.addChildNode( burt );
            james.addChildNode( jane );
        }
        
        public function createNode(x:int = 0, y:int = 0 ):Node
        {
            var node:Node = new Node();
            node.x = x;
            node.y = y;              
            
            return node;
        }

    }
}
import flash.display.Sprite;

class Node extends Sprite {
    
    private var _kids:Vector.<Node>;
    private var _parentNode:Node;
    private var _familyWidth:Number;
    
    private const NODE_SIZE:int = 10;
    private const HALF_NODE:int = 5;
    private const NODE_GAP:int = 5;
    
    
    public function Node():void
    {
        this.graphics.beginFill(0x666666);
        this.graphics.drawRect(-HALF_NODE,-HALF_NODE,NODE_SIZE,NODE_SIZE);
        this.graphics.endFill();
        
        _familyWidth = NODE_SIZE;
    }
    
    public function set parentNode( node:Node ):void
    {
        _parentNode = node;
    }
    
    public function get parentNode():Node
    {
        return _parentNode;
    }
    
    public function get familyWidth():Number
    {
        return _familyWidth;
    }

    public function addChildNode( node:Node ):void
    {
        kids.push( node );
        _familyWidth += NODE_SIZE;
        _familyWidth += kids.length > 1 ? NODE_GAP : 0;        
        node.parentNode = this;      
        if( _parentNode ) _parentNode.positionKids();  
        parent.addChild( node );
        positionKids();
    }
    
    public function get kids():Vector.<Node>
    {
        return _kids ||= new Vector.<Node>();
    } 
    
    public function positionKids():void
    {        
        //total width of kids
        var i:uint;
        var width:Number = 0;
        var node:Node
        for( i = 0; i < _kids.length; i++ )
        {
            node = _kids[i];
            width += node.familyWidth;
            if( i > 1 ) width += NODE_GAP;
        }
        
        //reposition parent to accomodate kids       
               
        //position kids
        var leftX:Number = kids.length > 1 ? this.x - width/2 : this.x;
        for( i = 0; i < _kids.length; i++ )
        {          
            node = _kids[i];
            node.y = this.y + NODE_SIZE + NODE_GAP;   
            node.x = leftX + (i * (NODE_SIZE+NODE_GAP)); 
        }
    }
}
