/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5zSL
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	
	[SWF (width = "500", height = "500", backgroundColor = "0x000000", frameRate = "30")]
	
	/**
	 *  グーローシェーディングに挑戦したけど、どんな色も赤ぽくなるので、赤一色のモデルにしてみた。
	 * 　なんだか赤いドーナッツだ。
	 * 
	 * 　「課題」
	 * 　各頂点のカラー計算の精度（今の処理には必ず計算ミスがあるだろうから（汗）高める。
	 * 
	 * 　「ひとりごと」
	 * 　調べるとグーローシェーディングはハードウェアーで実現されているらしい。だから、ソフトウェアーで実現しても、使い道はないのかな？
	 * 　（こんどは、beginGradientFillで挑戦してみよう！）
	 * 
	 **/
	
	public class Main extends Sprite 
	{
		public var t:Number = 0;
		private var vpX:Number = stage.stageWidth / 2;
		private var vpY:Number = stage.stageHeight / 2;	
		public var timer:Timer;
		public var menu:Menu = new Menu();
		
		public function Main() 
		{
			trace("run");
			Static_data.light = new Light(0,0,1000);
			for (var i:Number = 0; i < Static_data.world_cordinate.length; i++) {
				Static_data.world_cordinate[i] = new Array(3);
				Static_data.screen_cordinate[i] = new Array(5);
				for (var j:Number = 0; j < 3; j++) {
					Static_data.world_cordinate[i][j] = new Array(3);
					Static_data.screen_cordinate[i][j] = new Array(2);
				}
			}
			Static_proc.setVanishingPoint(vpX, vpY);
			Static_proc.setCenter(0, 0, 100);
			Static_proc.init_scr();
			this.addChild(menu);
			timer = new Timer(10);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			timer.start();
		}
		private function onTimer(evt:TimerEvent):void {
			timer.removeEventListener(TimerEvent.TIMER, onTimer);
			t += 0.1;
			var i:Number , j:Number;
			if (Static_data.z_buf) {
				Static_proc.scr_make();
				this.graphics.clear();
				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					for ( j = 0; j < 3; j++) {
						if (!Static_data.rotate) Static_proc.rotateX(t, i, j);
						else Static_proc.rotateY(t, i, j);
						Static_proc.screenX(i, j);
						Static_proc.screenY(i, j);
					}				
					Static_proc.max_z(i);
				}
				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					Static_proc.z_buffer(i);
//					Static_proc.z_gradient(this.graphics,i);
				}
				this.graphics.beginBitmapFill(Static_data.scr);
				this.graphics.moveTo(0, 0);
				this.graphics.lineTo(0, Static_data.scr_height);
				this.graphics.lineTo(Static_data.scr_width, Static_data.scr_height);
				this.graphics.lineTo(Static_data.scr_width, 0);
				this.graphics.lineTo(0, 0);
				this.graphics.endFill();
			}else {
				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					for (j = 0; j < 3; j++) {
						if (!Static_data.rotate) Static_proc.rotateX(t, i, j);
						else Static_proc.rotateY(t, i, j);
						Static_proc.screenX(i, j);
						Static_proc.screenY(i, j);
					}				
					Static_proc.max_z(i);
					Static_data.screen_cordinate[i][4] = i;
				}
				Static_proc.z_sort();
				this.graphics.clear();
				for (i = 0; i < Static_data.local_cordinate.length; i++) {
					if (!Static_data.wire) Static_proc.draw(this.graphics, i);
					else Static_proc.draw_wire(this.graphics,i);
				}
			}
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			timer.start();
		}
	}
	
}
	class Light
	{
		public var x:Number;
		public var y:Number;
		public var z:Number;
		private var _brightness:Number;
		
		public var triangle_data:Object;
		
		private var color:uint;
		
		public function Light(x:Number = -100, y:Number = -100, z:Number = -100, brightness:Number = 1)
		{
			this.x = x;
			this.y = y;
			this.z = z;
			this.brightness = brightness;

		}
		public function set_Light_point(x:Number , y:Number , z:Number):void{
			this.x = x;
			this.y = y;
			this.z = z;
		}
		
		public function set brightness(b:Number):void
		{
			_brightness = Math.max(b, 0);
			_brightness = Math.min(_brightness, 1);
		}
		
		public function get brightness():Number
		{
			return _brightness;
		}
		
	}
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	class Menu extends Sprite
	{
		public var Flat:Sprite = new Sprite();
		public var Gouraud:Sprite = new Sprite();
		public var Wire:Sprite = new Sprite();
		public var RotationX:Sprite = new Sprite();
		public var RotationY:Sprite = new Sprite();
		public var Flat_text:TextField = new TextField();
		public var Flat_format:TextFormat = new TextFormat();
		public var Gouraud_text:TextField = new TextField();
		public var Gouraud_format:TextFormat = new TextFormat();
		public var Wire_text:TextField = new TextField();
		public var Wire_format:TextFormat = new TextFormat();
		public var RotationX_text:TextField = new TextField();
		public var RotationX_format:TextFormat = new TextFormat();
		public var RotationY_text:TextField = new TextField();
		public var RotationY_format:TextFormat = new TextFormat();
		
		public function Menu() 
		{
			Flat_text.text = "Flat Shading";
			Flat_format.color = 0xFFFFFF;
			Flat_text.setTextFormat(Flat_format);
			Flat.addChild(Flat_text);
			Gouraud_text.text = "Gouraud Shading";
			Gouraud_format.color = 0xFF0000;
			Gouraud_text.setTextFormat(Gouraud_format);
			Gouraud.addChild(Gouraud_text);
			Wire_text.text = "Wire";
			Wire_format.color = 0xFFFFFF;
			Wire_text.setTextFormat(Wire_format);
			Wire.addChild(Wire_text);
			RotationX_text.text = "RotationX";
			RotationX_format.color = 0xFF0000;
			RotationX_text.setTextFormat(RotationX_format);
			RotationX.addChild(RotationX_text);
			RotationY_text.text = "RotationY";
			RotationY_format.color = 0xFFFFFF;
			RotationY_text.setTextFormat(RotationY_format);
			RotationY.addChild(RotationY_text);
			Flat.x = Gouraud.x = Wire.x = RotationX.x = RotationY.x = 20;
			Flat.y = 20;
			Gouraud.y = 40;
			Wire.y = 60;
			RotationX.y = 80;
			RotationY.y = 100;
//			Flat.width = Gouraud.width = Wire.width = RotationX.width = RotationY.width = 200;
//			Flat.height = Gouraud.height = Wire.height = RotationX.height = RotationY.height = 20;
			this.addChild(Flat);
			this.addChild(Gouraud);
			this.addChild(Wire);
			this.addChild(RotationX);
			this.addChild(RotationY);
			Flat.addEventListener(MouseEvent.CLICK, onFlat);
			Flat.buttonMode = true;
			Gouraud.addEventListener(MouseEvent.CLICK, onGouraud);
			Gouraud.buttonMode = true;
			Wire.addEventListener(MouseEvent.CLICK, onWire);
			Wire.buttonMode = true;
			RotationX.addEventListener(MouseEvent.CLICK, onRotationX);
			RotationX.buttonMode = true;
			RotationY.addEventListener(MouseEvent.CLICK, onRotationY);
			RotationY.buttonMode = true;
		}
		public function onFlat(evt:MouseEvent):void {
			Static_data.z_buf = false;
			Static_data.wire = false;
			set_color();
			Flat_format.color = 0xFF0000;
			Flat_text.setTextFormat(Flat_format);
		}
		public function onGouraud(evt:MouseEvent):void {
			Static_data.z_buf = true
			Static_data.wire = false;
			set_color();
			Gouraud_format.color = 0xFF0000;
			Gouraud_text.setTextFormat(Gouraud_format);
		}		
		public function onWire(evt:MouseEvent):void {
			Static_data.wire = true;
			Static_data.z_buf = false;
			set_color();
			Wire_format.color = 0xFF0000;
			Wire_text.setTextFormat(Wire_format);
		}
		public function onRotationX(evt:MouseEvent):void {
			Static_data.rotate = false;
			RotationX_format.color = 0xFF0000;
			RotationX_text.setTextFormat(RotationX_format);
			RotationY_format.color = 0xFFFFFF;
			RotationY_text.setTextFormat(RotationY_format);
		}
		public function onRotationY(evt:MouseEvent):void {
			Static_data.rotate = true;			
			RotationX_format.color = 0xFFFFFF;
			RotationX_text.setTextFormat(RotationX_format);			
			RotationY_format.color = 0xFF0000;
			RotationY_text.setTextFormat(RotationY_format);			
		}
		public function set_color():void {
			Flat_format.color = 0xFFFFFF;
			Flat_text.setTextFormat(Flat_format);
			Gouraud_format.color = 0xFFFFFF;
			Gouraud_text.setTextFormat(Gouraud_format);
			Wire_format.color = 0xFFFFFF;
			Wire_text.setTextFormat(Wire_format);
		}
	}
	class Point3D 
	{
		public var x:Number;
		public var y:Number;
		public var z:Number;
		public function Point3D(x:Number=0,y:Number=0,z:Number=0) 
		{
			this.x = x;
			this.y = y;
			this.z = z;
		}
		
	}
	class Vec 
	{
		public var point:Array = new Array(3);
		public var N:Point3D;
		public var V:Point3D;
		public var L:Point3D;
		public var R:Point3D;
		
		public function Vec(f:Point3D,s:Point3D,t:Point3D,n:Number) 
		{
			point[0] = new Point3D(f.x, f.y, f.z);
			point[1] = new Point3D(s.x, s.y, s.z);
			point[2] = new Point3D(t.x, t.y, t.z);
			n_comp();
			v_comp(n);
			l_comp(n);
			r_comp();
		}
		public function n_comp():void {
			var ab:Object = new Object();
			N = new Point3D();
			ab.x = point[0].x - point[1].x;
			ab.y = point[0].y - point[1].y;
			ab.z = point[0].z - point[1].z;
			
			var bc:Object = new Object();
			bc.x = point[1].x - point[2].x;
			bc.y = point[1].y - point[2].y;
			bc.z = point[1].z - point[2].z;
			
			var norm:Object = new Object();
			N.x = (ab.y * bc.z) - (ab.z * bc.y);
			N.y = -((ab.x * bc.z) - (ab.z * bc.x));
			N.z = (ab.x * bc.y) - (ab.y * bc.x);
		}
		public function v_comp(n:Number):void {
			V = new Point3D();
			V.x = point[n].x - 500;
			V.y = point[n].y - 500;
			V.z = point[n].z - 500;
		}
		public function l_comp(n:Number):void {
			L = new Point3D();
			L.x = point[n].x - Static_data.light.x;
			L.y = point[n].y - Static_data.light.y;
			L.z = point[n].z - Static_data.light.z;
		}
		public function r_comp():void {
			R = new Point3D();
			var n:Number = (N.x * L.x + N.y * L.y + N.z * L.z) * 2;
			R.x = L.x - n * N.x;
			R.y = L.y - n * N.y;
			R.z = L.z - n * N.z;
		}
		
	}
	import flash.display.Graphics;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	class Static_proc 
	{
		public static function rotateX(angleX:Number,row:Number,column:Number):void
		{
			var cos:Number = Math.cos(angleX);
			var sin:Number = Math.sin(angleX);
			var rtn:Array;
			
			Static_data.xRotMatrix[0] = [1,    0,   0];
			Static_data.xRotMatrix[1] = [0,  cos, sin];
			Static_data.xRotMatrix[2] = [0, -sin, cos]
			
			Static_data.position = Static_data.local_cordinate[row][column];			
			var result:Array = matrixMultiply(Static_data.position, Static_data.xRotMatrix);
			Static_data.world_cordinate[row][column][0] = result[0];
			Static_data.world_cordinate[row][column][1] = result[1];
			Static_data.world_cordinate[row][column][2] = result[2];
		
		}
		
		public static function rotateY(angleY:Number,row:Number,column:Number):void
		{
			var cos:Number = Math.cos(angleY);
			var sin:Number = Math.sin(angleY);
			
			Static_data.yRotMatrix[0] = [ cos, 0, sin];
			Static_data.yRotMatrix[1] = [   0, 1,   0];
			Static_data.yRotMatrix[2] = [ -sin, 0, cos];
			
			Static_data.position = Static_data.local_cordinate[row][column];
			var result:Array = matrixMultiply(Static_data.position, Static_data.yRotMatrix);
			Static_data.world_cordinate[row][column][0] = result[0];
			Static_data.world_cordinate[row][column][1] = result[1];
			Static_data.world_cordinate[row][column][2] = result[2];
		}
		
		public static function rotateZ(angleZ:Number,row:Number,column:Number):void
		{
			var cos:Number = Math.cos(angleZ);
			var sin:Number = Math.sin(angleZ);
			
			Static_data.zRotMatrix[0] = [  cos, sin,   0];
			Static_data.zRotMatrix[1] = [ -sin, cos,   0];
			Static_data.zRotMatrix[2] = [    0,   0,   0];
			
			Static_data.position = Static_data.local_cordinate[row][column];
			var result:Array = matrixMultiply(Static_data.position, Static_data.zRotMatrix);
			Static_data.world_cordinate [row][column]= [result[0], result[1], result[2]];

		
		}
		public static function scale(num:Number,x:Number, y:Number,z:Number,row:Number,column:Number):void
		{
			Static_data.zRotMatrix[0] = [  x,  0,  0];
			Static_data.zRotMatrix[1] = [  0,  y,  0];
			Static_data.zRotMatrix[2] = [  0,  0,  z];
			
			Static_data.position = Static_data.local_cordinate[row][column];
			var result:Array = matrixMultiply(Static_data.position, Static_data.xRotMatrix);
			Static_data.world_cordinate[num] = [result[0], result[0], result[0]];
	
		}
		public static function setVanishingPoint(vpX:Number, vpY:Number):void
		{
			Static_data.vpX = vpX;
			Static_data.vpY = vpY;
		}
		
		public static function setCenter(cX:Number, cY:Number, cZ:Number=0):void
		{
			Static_data.cX = cX;
			Static_data.cY = cY;
			Static_data.cZ = cZ;
		}
		public static function screenX(row:Number,column:Number):void
		{
			var scale:Number = Static_data.fl / (Static_data.fl + Static_data.world_cordinate [row][column][2]+ Static_data.cZ);
			Static_data.screen_cordinate[row][column][0] = 
				Static_data.vpX + (Static_data.cX + Static_data.world_cordinate[row][column][0]) * scale;
		}
		
		public static function screenY(row:Number,column:Number):void
		{
			var scale:Number = Static_data.fl / (Static_data.fl + Static_data.world_cordinate[row][column][2] + Static_data.cZ);
			Static_data.screen_cordinate[row][column][1] = 
			     Static_data.vpY - (Static_data.cY + Static_data.world_cordinate[row][column][1]) * scale;
		}
		public static function max_z(row:Number):void
		{
			Static_data.screen_cordinate[row][3] = Math.max(Static_data.world_cordinate[row][0][2],
														   Static_data.world_cordinate[row][1][2],
														   Static_data.world_cordinate[row][2][2]);
		}
		public static function draw_wire(g:Graphics, row:Number):void {
			g.lineStyle(0.5, 0x00FFFF);
			g.moveTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.lineTo(Static_data.screen_cordinate[row][1][0], Static_data.screen_cordinate[row][1][1]);
			g.lineTo(Static_data.screen_cordinate[row][2][0], Static_data.screen_cordinate[row][2][1]);
			g.lineTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.endFill();
		}
		public static function draw(g:Graphics,row:Number):void
		{
			if(isBackFace(row))
			{
				return;
			}
			g.beginFill(getAdjustedColor(row));
			g.moveTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.lineTo(Static_data.screen_cordinate[row][1][0], Static_data.screen_cordinate[row][1][1]);
			g.lineTo(Static_data.screen_cordinate[row][2][0], Static_data.screen_cordinate[row][2][1]);
			g.lineTo(Static_data.screen_cordinate[row][0][0], Static_data.screen_cordinate[row][0][1]);
			g.endFill();
		}
		
		private static function getAdjustedColor(row:Number):uint
		{
			var index:Number = Static_data.screen_cordinate[row][4];
			var red:Number = Static_data.local_cordinate[index][3] >> 16;
			var green:Number = Static_data.local_cordinate[index][3] >> 8 & 0xff;
			var blue:Number = Static_data.local_cordinate[index][3] & 0xff;
			
			var lightFactor:Number = getLightFactor(row);
			
			red *= lightFactor;
			green *= lightFactor;
			blue *= lightFactor;
			
			return red << 16 | green << 8 | blue;
		}
		
		private static function getLightFactor(row:Number):Number
		{
			var index:Number = Static_data.screen_cordinate[row][4];
			var ab:Object = new Object();
			ab.x = Static_data.world_cordinate[index][0][0] - Static_data.world_cordinate[index][1][0];
			ab.y = Static_data.world_cordinate[index][0][1] - Static_data.world_cordinate[index][1][1];
			ab.z = Static_data.world_cordinate[index][0][2] - Static_data.world_cordinate[index][1][2];
			
			var bc:Object = new Object();
			bc.x = Static_data.world_cordinate[index][1][0] - Static_data.world_cordinate[index][2][0];
			bc.y = Static_data.world_cordinate[index][1][1] - Static_data.world_cordinate[index][2][1];
			bc.z = Static_data.world_cordinate[index][1][2] - Static_data.world_cordinate[index][2][2];
			
			var norm:Object = new Object();
			norm.x = (ab.y * bc.z) - (ab.z * bc.y);
			norm.y = -((ab.x * bc.z) - (ab.z * bc.x));
			norm.z = (ab.x * bc.y) - (ab.y * bc.x);
			
			var dotProd:Number = norm.x * Static_data.light.x + 
								 norm.y * Static_data.light.y + 
								 norm.z * Static_data.light.z;
			
			var normMag:Number = Math.sqrt(norm.x * norm.x + 
										   norm.y * norm.y +
										   norm.z * norm.z);
			
			var lightMag:Number = Math.sqrt(Static_data.light.x * Static_data.light.x +
											Static_data.light.y * Static_data.light.y +
											Static_data.light.z * Static_data.light.z);
			
			return (Math.acos(dotProd / (normMag * lightMag)) / Math.PI)
					* Static_data.light.brightness;
		}
		
		private static function isBackFace(row:Number):Boolean
		{
			// http://www.jurjans.lv/flash/shape.html
			var cax:Number = Static_data.screen_cordinate[row][2][0] - Static_data.screen_cordinate[row][0][0] ;
			var cay:Number = Static_data.screen_cordinate[row][2][1] - Static_data.screen_cordinate[row][0][1] ;
			var bcx:Number = Static_data.screen_cordinate[row][1][0] - Static_data.screen_cordinate[row][2][0] ;
			var bcy:Number = Static_data.screen_cordinate[row][1][1] - Static_data.screen_cordinate[row][2][1] ;
			return cax * bcy > cay * bcx;
		}
		
		public static function z_sort():void {
			quicksort(0, Static_data.screen_cordinate.length - 1);
		}
		public static function quicksort(l:Number,r:Number):void {
			if (l >= r) {
				return; 
			}
			var v:Number = parition(l, r);
			quicksort (l, v - 1);
			quicksort (v+1, r);
		}
		public static function parition(l:Number, r:Number):Number {
			var i:Number = l - 1;
			var j:Number = r;
			var temp:Array;
			var pivot:Number = Static_data.screen_cordinate[r][3];
			for (;;) {
				while (Static_data.screen_cordinate[++i][3] > pivot);
				while (i <--j && pivot > Static_data.screen_cordinate[j][3]);
				if (i >= j) break;
				temp = Static_data.screen_cordinate[i];
				Static_data.screen_cordinate[i] = Static_data.screen_cordinate[j];
				Static_data.screen_cordinate[j] = temp;
			}
			temp = Static_data.screen_cordinate[i];
			Static_data.screen_cordinate[i] = Static_data.screen_cordinate[r];
			Static_data.screen_cordinate[r] = temp;
			return i;
		}
		private static function matrixMultiply(matrixA:Array, matrixB:Array):Array
		{
			var result:Array = new Array();
			result[0] = matrixA[0] * matrixB[0][0] + 
						matrixA[1] * matrixB[1][0] +
						matrixA[2] * matrixB[2][0];
			
			result[1] = matrixA[0] * matrixB[0][1] +
						matrixA[1] * matrixB[1][1] +
						matrixA[2] * matrixB[2][1];
			
			result[2] = matrixA[0] * matrixB[0][2] +
						matrixA[1] * matrixB[1][2] +
						matrixA[2] * matrixB[2][2];
			return result;
		}
		public static function z_gradient(g:Graphics, row:Number):void {
			var set_color:Array = average_color(row);
			var col:Array = new Array(3);
			var p:Array = new Array(3);
			for (var i:Number = 0; i < 3; i++) {
				var c:Number = set_color[i][0] & 0xff;
				p[i] = { ratio:int((c / 255) * 10),
						 point: new Point(Static_data.screen_cordinate[row][i][0],Static_data.screen_cordinate[row][i][1])
					    };
				col[i] = set_color[0] << 16 |set_color [1] << 8 | set_color[2];
			}
			p.sortOn("ratio", Array.NUMERIC);
			var p3:Point = Point.interpolate(p[2].point, p[0].point, (p[1].ratio - p[0].ratio) / (p[2].ratio - p[0].ratio));
			var p4:Point = p[2].point.subtract(p[0].point);
			var d:Number = Math.atan2(p3.x - p[1].point.x, p[1].point.y - p3.y);
			var matrix:Matrix = new Matrix();
			matrix.a = Math.cos(Math.atan2(p4.y, p4.x) - d) * p4.length / 1638.4;
			matrix.rotate(d);
			matrix.translate((p[2].point.x + p[0].point.x) / 2, (p[2].point.y + p[0].point.y) / 2);
			g.beginGradientFill("linear", [col[0], col[2]], [100, 100], [0x00, 0xFF], matrix);
			g.moveTo(p[2].x, p[2].y);
			g.lineTo(p[0].x, p[0].y);
			g.lineTo(p[1].x, p[1].y);
			g.lineTo(p[2].x, p[2].y);
			g.endFill(); 
		}
		
		public static function z_buffer(row:Number):void
		{
			if (isBackFace(row)) return;
			var top:int = 0 , bot:int = 0 , lft:int = 0 , rit:int = 0 , oth:int = 0;
			var oth_p:Array = [0 , 0 , 0];
			var start_c:Array = new Array() , end_c:Array = new Array(), s_c:Array = new Array(), e_c:Array=new Array();
			var start:Point = new Point() , end:Point = new Point();
			var start1:Point = new Point() , end1:Point = new Point();
			var start2:Point = new Point() , end2:Point = new Point();
			var oth_point:Point = new Point();
			var set_color:Array = average_color(row);
			var ii:Number , jj:Number;
			for (var i:Number = 0; i < 3; i++) {
				if (Static_data.screen_cordinate[row][lft][0] > Static_data.screen_cordinate[row][i][0]) lft = i;
				if (Static_data.screen_cordinate[row][rit][0] < Static_data.screen_cordinate[row][i][0]) rit = i;
				if (Static_data.screen_cordinate[row][top][1] > Static_data.screen_cordinate[row][i][1]) top = i;
				if (Static_data.screen_cordinate[row][bot][1] < Static_data.screen_cordinate[row][i][1]) bot = i;				
			}
			oth_p[top] = 1;
			oth_p[bot] = 1;			
			for (i = 0; i < oth_p.length; i++) {
				if (oth_p[i] == 0) {
					oth = i;
					break;
				}
			}
			for (var y:int = int(Static_data.screen_cordinate[row][top][1]); y < int(Static_data.screen_cordinate[row][bot][1])+1; y++) {
				if (int(Static_data.screen_cordinate[row][top][1]) == int(Static_data.screen_cordinate[row][oth][1]) && y == int(Static_data.screen_cordinate[row][top][1])) {
					start.x = Static_data.screen_cordinate[row][top][0] < Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][top][0]) : int(Static_data.screen_cordinate[row][oth][0]);
					start.y = Static_data.screen_cordinate[row][top][1] < Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][top][1]) : int(Static_data.screen_cordinate[row][oth][1]);
					end.x = Static_data.screen_cordinate[row][top][0] > Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][top][0]) : int(Static_data.screen_cordinate[row][oth][0]);
					end.y = Static_data.screen_cordinate[row][top][1] > Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][top][1]) : int(Static_data.screen_cordinate[row][oth][1]);
					oth_point.x = Static_data.screen_cordinate[row][oth][0];
					oth_point.y = Static_data.screen_cordinate[row][oth][1];
					if (get_oth_point(start, end, oth_point)) {
						s_c = set_color[top];
						e_c = set_color[oth];
						start_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][oth][1]));
						s_c = set_color[top];
						e_c = set_color[bot];
						end_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][bot][1]));
					}else {
						s_c = set_color[top];
						e_c = set_color[bot];
						start_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][bot][1]));
						s_c = set_color[top];
						e_c = set_color[oth];
						end_c = sub_c(s_c, e_c, 0,int(Static_data.screen_cordinate[row][oth][1]));
					}
				}else {
					if (int(Static_data.screen_cordinate[row][bot][1]) == int(Static_data.screen_cordinate[row][oth][1]) && y == int(Static_data.screen_cordinate[row][bot][1])) {
						start.x = Static_data.screen_cordinate[row][bot][0] < Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][bot][0]) : int(Static_data.screen_cordinate[row][oth][0]);
						start.y = Static_data.screen_cordinate[row][bot][1] < Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][bot][1]) : int(Static_data.screen_cordinate[row][oth][1]);
						end.x = Static_data.screen_cordinate[row][bot][0] > Static_data.screen_cordinate[row][oth][0] ? int(Static_data.screen_cordinate[row][bot][0]) : int(Static_data.screen_cordinate[row][oth][0]);
						end.y = Static_data.screen_cordinate[row][bot][1] > Static_data.screen_cordinate[row][oth][1] ? int(Static_data.screen_cordinate[row][bot][1]) : int(Static_data.screen_cordinate[row][oth][1]);
						oth_point.x = Static_data.screen_cordinate[row][oth][0];
						oth_point.y = Static_data.screen_cordinate[row][oth][1];
						if (get_oth_point(start, end, oth_point)) {
							s_c = set_color[top];
							e_c = set_color[oth];
							start_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][oth][1]),0);
							s_c = set_color[top];
							e_c = set_color[bot];
							end_c = sub_c(s_c, e_c,int(Static_data.screen_cordinate[row][bot][1]) ,0);
						}else {
							s_c = set_color[top];
							e_c = set_color[bot];
							start_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][bot][1]),0);
							s_c = set_color[top];
							e_c = set_color[oth];
							end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][oth][1]),0);
						}
					}else {
						start1.x = int(Static_data.screen_cordinate[row][lft][0]);
						start1.y = y;
						end1.x = int(Static_data.screen_cordinate[row][rit][0]);
						end1.y = y;
						start2.x = Static_data.screen_cordinate[row][top][0];
						start2.y = Static_data.screen_cordinate[row][top][1];
						end2.x = Static_data.screen_cordinate[row][bot][0];
						end2.y = Static_data.screen_cordinate[row][bot][1];
						oth_point.x = Static_data.screen_cordinate[row][oth][0];
						oth_point.y = Static_data.screen_cordinate[row][oth][1];
						if (y < Static_data.screen_cordinate[row][oth][1]) {						
							if (get_oth_point(start2, end2, oth_point)) {
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][oth][0]);
								end2.y = int(Static_data.screen_cordinate[row][oth][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][oth][1]) - y);
								s_c = set_color[top];
								e_c = set_color[oth];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][oth][1]) - y);
								if (start_c[0] < 0) trace("no1 start error");
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								end = sub_p(start2, end2, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								s_c = set_color[top];
								e_c = set_color[bot];
								end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								if (end_c[0] < 0) trace("no1 end error");
								if (int(start.x)==int(end.x))end.x++; 
								
							}else {
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								
								s_c = set_color[top];
								e_c = set_color[bot];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								if (start_c[0] < 0) trace("no2 start error");
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][oth][0]);
								end2.y = int(Static_data.screen_cordinate[row][oth][1]);
								end = sub_p(start2, end2, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][oth][1]));
								s_c = set_color[top];
								e_c = set_color[oth];
								end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][top][1])-y,
																			y - int(Static_data.screen_cordinate[row][oth][1]));
								if (end_c[0] < 0) trace("no2 end error");
								if (int(start.x)==int(end.x)) end.x++;
							}
						}else {
							if (get_oth_point(start2, end2, oth_point)) {
								start2.x = int(Static_data.screen_cordinate[row][oth][0]);
								start2.y = int(Static_data.screen_cordinate[row][oth][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][oth][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								s_c = set_color[oth];
								e_c = set_color[bot];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][oth][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								if (start_c[0] < 0) trace("no3 start error");
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								end = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]-y));
								s_c = set_color[top];
								e_c = set_color[bot];
								end_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]-y));
								if (end_c[0] < 0) trace("no3 end error");
								if (int(start.x)==int(end.x)) end.x++;
							}else {
								start2.x = int(Static_data.screen_cordinate[row][top][0]);
								start2.y = int(Static_data.screen_cordinate[row][top][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								start = sub_p(start2, end2, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								s_c = set_color[top];
								e_c = set_color[bot];
								start_c = sub_c(s_c, e_c, y - int(Static_data.screen_cordinate[row][top][1]),
																			int(Static_data.screen_cordinate[row][bot][1]) - y);
								if (start_c[0] < 0) trace("no4 start error");
								start2.x = int(Static_data.screen_cordinate[row][oth][0]);
								start2.y = int(Static_data.screen_cordinate[row][oth][1]);
								end2.x = int(Static_data.screen_cordinate[row][bot][0]);
								end2.y = int(Static_data.screen_cordinate[row][bot][1]);
								end = sub_p(start2, end2, int(Static_data.screen_cordinate[row][oth][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								s_c = set_color[oth];
								e_c = set_color[bot];
								end_c = sub_c(s_c, e_c, int(Static_data.screen_cordinate[row][oth][1])-y,
																			y - int(Static_data.screen_cordinate[row][bot][1]));
								if (end_c[0] < 0) trace("no4 end error");
								if (int(start.x)==int(end.x)) end.x++ ;
							}
						}
					}
				}
				if (int(start.x) == int(end.x)) end.x++;
				if (int(start.x) > int(end.x)) end.x = start.x + 1;	
				
				for (var x:int = int(start.x); x < int(end.x); x++) {
					if (x <= Static_data.scr_width && x > 0 &&
					    y <= Static_data.scr_height && y > 0) {

						if (Static_data.z_buffer[x][y] > int(Static_data.screen_cordinate[row][3])) {
							Static_data.z_buffer[x][y] = Static_data.screen_cordinate[row][3];
							var col:Array = sub_c(start_c, end_c, x - int(start.x), int(end.x) - x);
							var c:uint = col[0] << 16 | col[1] << 8 | col[2];
							Static_data.scr.setPixel(x, y, c);
						}
					}
				}
			}
		}
		
		public static function line_cross(s1:Point , e1:Point , s2:Point , e2:Point,row:Number):Point {
			var rtn:Point = new Point();
			var no1:Point = new Point() , no2:Point = new Point() , no3:Point = new Point();
			var g1:Number , g2:Number , q:Number;
			no1.x = e2.x - s2.x ; no1.y = e2.y - s2.y;
			no2.x = s1.x - s2.x ; no2.y = s1.y - s2.y;
			no3.x = e1.x - s1.x ; no3.y = e1.y - s1.y;
			g1 = no3.x * no1.y - no3.y * no1.x;
			g2 = no3.x * no2.y - no3.y * no2.x;
			if (g1 != 0) {
				q = g2 / g1;
				rtn.x = no1.x * q ; rtn.y = no1.y * q;
				rtn.x += s2.x ; rtn.y += s2.y;
			}else {
				if (s1.x == e1.x && s1.y == e1.y) {
					rtn.x = s1.x;
					rtn.y = s1.y;
				}else{
					trace("not cross " + row);
					trace("start1 x " + s1.x + " y " + s1.y+" end1.x "+e1.x+" end1.y "+e1.y);
					trace("start2 x " + s2.x + " y " + s2.y+" end2.x "+e2.x+" end2.y "+e2.y);
					trace("f x " + Static_data.screen_cordinate[row][0][0] + " y " + Static_data.screen_cordinate[row][0][1]);
					trace("s x " + Static_data.screen_cordinate[row][1][0] + " y " + Static_data.screen_cordinate[row][1][1]);
					trace("t x " + Static_data.screen_cordinate[row][2][0] + " y " + Static_data.screen_cordinate[row][2][1]);
					rtn.x = s1.x;
					rtn.y = s1.y;
				}
			}
			return rtn;
		}
		
		public static function init_scr():void {
			Static_data.z_buffer = new Array(Static_data.scr_height);
			for (var y:Number = 0; y < Static_data.scr_height; y++) {
				Static_data.z_buffer[y] = new Array(Static_data.scr_width);
				for (var x:Number = 0; x<Static_data.scr_width; x++) {
					Static_data.init_scr.setPixel(x, y, 0x000000);
				}
			}
			for (x = 0; x < Static_data.scr_width; x++)
				for (y = 0; y < Static_data.scr_height; y++) Static_data.z_buffer[x][y] = 1000.0 
		}
		public static function scr_make():void {
			var rect:Rectangle = new Rectangle(0, 0, Static_data.scr_width, Static_data.scr_height);
			Static_data.scr.copyPixels(Static_data.init_scr, rect, new Point());
			for (var x:Number = 0; x < Static_data.scr_width; x++)
				for (var y:Number = 0; y < Static_data.scr_height; y++) Static_data.z_buffer[x][y] = 1000.0 
		}
		private static function getAdjustedColor_z(row:Number):uint
		{
			var red:Number = Static_data.local_cordinate[row][3] >> 16;
			var green:Number = Static_data.local_cordinate[row][3] >> 8 & 0xff;
			var blue:Number = Static_data.local_cordinate[row][3] & 0xff;
			var lightFactor:Number = getLightFactor_z(row);
			
			red *= lightFactor;
			green *= lightFactor;
			blue *= lightFactor;
			
			return red << 16 | green << 8 | blue;
		}
		
		private static function getLightFactor_z(row:Number):Number
		{
			var ab:Object = new Object();
			ab.x = Static_data.world_cordinate[row][0][0] - Static_data.world_cordinate[row][1][0];
			ab.y = Static_data.world_cordinate[row][0][1] - Static_data.world_cordinate[row][1][1];
			ab.z = Static_data.world_cordinate[row][0][2] - Static_data.world_cordinate[row][1][2];
			
			var bc:Object = new Object();
			bc.x = Static_data.world_cordinate[row][1][0] - Static_data.world_cordinate[row][2][0];
			bc.y = Static_data.world_cordinate[row][1][1] - Static_data.world_cordinate[row][2][1];
			bc.z = Static_data.world_cordinate[row][1][2] - Static_data.world_cordinate[row][2][2];
			
			var norm:Object = new Object();
			norm.x = (ab.y * bc.z) - (ab.z * bc.y);
			norm.y = -((ab.x * bc.z) - (ab.z * bc.x));
			norm.z = (ab.x * bc.y) - (ab.y * bc.x);
			
			var dotProd:Number = norm.x * Static_data.light.x + 
								 norm.y * Static_data.light.y + 
								 norm.z * Static_data.light.z;
			
			var normMag:Number = Math.sqrt(norm.x * norm.x + 
										   norm.y * norm.y +
										   norm.z * norm.z);
			
			var lightMag:Number = Math.sqrt(Static_data.light.x * Static_data.light.x +
											Static_data.light.y * Static_data.light.y +
											Static_data.light.z * Static_data.light.z);
			
			return (Math.acos(dotProd / (normMag * lightMag)) / Math.PI)
					* Static_data.light.brightness;
		}
		private static function get_oth_point(s:Point , e:Point , p:Point):Boolean {
			var xa:Number , ya:Number , xb:Number , yb:Number , det:Number;
			xa = e.x - s.x;
			ya = e.y - s.y;
			xb = p.x - s.x;
			yb = p.y - s.y;
			det = xa * yb - xb * ya;
			return det > 0;
		}
		private static function sub_p(p1:Point , p2:Point , a1:int , a2:int):Point {
			var rtn:Point = new Point();
			if (a1 + a2 == 0) return p1;
			rtn.x = (a2 * p1.x + a1 * p2.x) / (a1 + a2);
			rtn.y = (a2 * p1.y + a1 * p2.y) / (a1 + a2);
			return rtn;
		}
		private static function sub_c(c1:Array , c2:Array , a1:int , a2:int):Array {
			var rtn:Array = new Array(3);
			if (a1 + a2 == 0) return c1;
			for (var i:Number = 0; i < 3; i++) {
				rtn[i] = (a2 / (a1 + a2) * c1[i] + a1 / (a1 + a2) * c2[i]);
				if (rtn[i] < 0) {
					trace("c1 r " + c1[0] + " g " + c1[1] + " b " + c1[2]);
					trace("c2 r " + c2[0] + " g " + c2[1] + " b " + c2[2]);
					trace("a1 " + a1 + " a2 " + a2);
				}
			}
			return rtn;
		}
		private static function average_color(row:Number):Array {
			var kb:Number = 0.7 , ks:Number = 0.7 , ke:Number = 0.3 , e:Number , length:Number;
			var rtn:Array = new Array(3);
			var v_data:Array = new Array(3);
			var f_point:Point3D;
			var s_point:Point3D;
			var t_point:Point3D;			
			var data:Array = new Array(4);
			var v:Vec;
			var red:Number ;
			var green:Number ;
			var blue:Number ;
			for (var i:Number = 0; i < 3; i++) {
				if (Static_data.local_cordinate[row][i + 4].length != 0) {
					rtn[i] = new Array(3);
					v_data = new Array(Static_data.local_cordinate[row][i + 4].length);
					length = 0;
					for (var j:Number = 0; j < Static_data.local_cordinate[row][i + 4].length; j++) {
						v_data[j] = new Array(4);
						e = Static_data.local_cordinate[row][i + 4][j];
						if (!isBackFace(e)){
							f_point =  new Point3D (Static_data.world_cordinate[e][0][0],Static_data.world_cordinate[e][0][1],Static_data.world_cordinate[e][0][2]);
							s_point =  new Point3D (Static_data.world_cordinate[e][1][0],Static_data.world_cordinate[e][1][1],Static_data.world_cordinate[e][1][2]);
							t_point =  new Point3D (Static_data.world_cordinate[e][2][0],Static_data.world_cordinate[e][2][1],Static_data.world_cordinate[e][2][2]);
							v = new Vec(f_point, s_point, t_point,i);
						
							v_data[length][0] = v.N;
							v_data[length][1] = v.V;
							v_data[length][2] = v.L;
							v_data[length][3] = v.R;
							length++;
						}
					}
					data = Normalized(v_data,length,row,i);
					red = Static_data.local_cordinate[row][3] >> 16 ;
					green = Static_data.local_cordinate[row][3] >> 8 & 0xff;
					blue = Static_data.local_cordinate[row][3] & 0xff;
					rtn[i][0] = kb * spec(data,0) * red + ks * diff(data,0) + ke * red;
					rtn[i][1] = kb * spec(data,1) * green + ks * diff(data,1) + ke * green;
					rtn[i][2] = kb * spec(data,2) * blue + ks * diff(data,2) + ke * blue;
				}
			}
			return rtn;
		}
		public static function Normalized(p:Array,l:Number,row:Number,column:Number):Array {
			var rtn:Array = new Array(4);
			var N:Point3D = new Point3D();
			var V:Point3D = new Point3D();
			var L:Point3D = new Point3D();
			var R:Point3D = new Point3D();
			var D:Number;
			for (var i:Number = 0; i < 4; i++) {
				rtn[i] = new Point3D();
			}
			for (i = 0; i < l ; i++) {
				N.x += p[i][0].x;
				N.y += p[i][0].y;
				N.z += p[i][0].z;
				V.x += p[i][1].x;
				V.y += p[i][1].y;
				V.z += p[i][1].z;	
				L.x += p[i][2].x;
				L.y += p[i][2].y;
				L.z += p[i][2].z;	
				R.x += p[i][3].x;
				R.y += p[i][3].y;
				R.z += p[i][3].z;				
			}
			N.x /= l;
			N.y /= l;
			N.z /= l;
			D = Math.sqrt(N.x * N.x + N.y * N.y + N.z * N.z);
			rtn[0].x = N.x / D;
			rtn[0].y = N.y / D;
			rtn[0].z = N.z / D;
			V.x /= l;
			V.y /= l;
			V.z /= l;
			D = Math.sqrt(V.x * V.x + V.y * V.y + V.z * V.z);
			rtn[1].x = V.x / D;
			rtn[1].y = V.y / D;
			rtn[1].z = V.z / D;
			L.x /= l;
			L.y /= l;
			L.z /= l;
			D = Math.sqrt(L.x * L.x + L.y * L.y + L.z * L.z);
			rtn[2].x = L.x / D;
			rtn[2].y = L.y / D;
			rtn[2].z = L.z / D;
//			R.x /= l;
//			R.y /= l;
//			R.z /= l;
//			D = Math.sqrt(R.x * R.x + R.y * R.y + R.z * R.z);
//			rtn[3].x = R.x / D;
//			rtn[3].y = R.y / D;
//			rtn[3].z = R.z / D;
			var n:Number = (rtn[0].x * rtn[2].x + rtn[0].y * rtn[2].y + rtn[0].z * rtn[2].z) * 2;
			rtn[3].x = rtn[2].x - n * rtn[0].x;
			rtn[3].y = rtn[2].y - n * rtn[0].y;
			rtn[3].z = rtn[2].z - n * rtn[0].z;
			return rtn;
		}
		public static function spec(data:Array,p:Number):Number {
			var rtn:Number;
			var point:Point3D = new Point3D();
			point.x = data[0].y * data[2].z - data[0].z * data[2].y;
			point.y = -(data[0].x * data[2].z - data[0].z * data[2].x);
			point.z = data[0].x * data[2].y - data[0].y * data[2].x;
			point.x *= -1;
			point.y *= -1;
			point.z *= -1;
			switch(p) {
				case 0:
					rtn = Math.max(point.x, 0);
					break;
				case 1:
					rtn = Math.max(point.y, 0);
					break;
				case 2:
					rtn = Math.max(point.z, 0);
					break;
			}
			return rtn;
		}
		public static function diff(data:Array,p:Number):Number {
			var rtn:Number;
			var point:Point3D = new Point3D();
			point.x = data[3].y * data[1].z - data[3].z * data[1].y;
			point.y = -(data[3].x * data[1].z - data[3].z * data[1].x);
			point.z = data[3].x * data[1].y - data[3].y * data[1].x;
			point.x *= -1;
			point.y *= -1;
			point.z *= -1;
			switch(p) {
				case 0:
					rtn = Math.pow(Math.max(point.x, 0),20) * 255;
					break;
				case 1:
					rtn = Math.pow(Math.max(point.y, 0),20) * 255;
					break;
				case 2:
					rtn = Math.pow(Math.max(point.z, 0),20) * 255;
					break;
			}
			return rtn;
		}

	}
	import flash.display.BitmapData;
	import flash.display.Sprite;
	
	class Static_data 
	{
		public static var local_cordinate:Array = [
		
[[65,53,-11],[62,53,-22],[45,42,-8,],0xFF0000,[0,12],[0,1,12,13],[0,1,2]],
[[45,42,-8],[62,53,-22],[43,42,-15,],0xFF0000,[0,1,2],[0,1,12,13],[1,2,3]],
[[45,42,-8],[43,42,-15],[32,25,-5,],0xFF0000,[0,1,2],[1,2,3],[2,3,4]],
[[43,42,-15],[30,25,-11],[32,25,-5,],0xFF0000,[1,2,3],[3,4,5,332,333,334],[2,3,4]],
[[32,25,-5],[30,25,-11],[27,4,-4,],0xFF0000,[2,3,4],[3,4,5,332,333,334],[4,5,6]],
[[30,25,-11],[26,4,-9],[27,4,-4,],0xFF0000,[3,4,5,332,333,334],[5,6,7,334,335,336],[4,5,6]],
[[27,4,-4],[26,4,-9],[32,-17,-5,],0xFF0000,[4,5,6],[5,6,7,334,335,336],[6,7,8]],
[[26,4,-9],[30,-17,-11],[32,-17,-5,],0xFF0000,[5,6,7,334,335,336],[7,8,9,336,337,338],[6,7,8]],
[[32,-17,-5],[30,-17,-11],[45,-34,-8,],0xFF0000,[6,7,8],[7,8,9,336,337,338],[8,9,10,57,58,59]],
[[30,-17,-11],[43,-34,-15],[45,-34,-8,],0xFF0000,[7,8,9,336,337,338],[9,10,11],[8,9,10,57,58,59]],
[[45,-34,-8],[43,-34,-15],[65,-45,-11,],0xFF0000,[8,9,10,57,58,59],[9,10,11],[10,11,16]],
[[43,-34,-15],[62,-45,-22],[65,-45,-11,],0xFF0000,[9,10,11],[11,16,17],[10,11,16]],
[[65,53,-11],[88,55,-15],[62,53,-22,],0xFF0000,[0,12],[12,13,14,15],[0,1,12,13]],
[[88,55,-15],[84,55,-30],[62,53,-22,],0xFF0000,[12,13,14,15],[13,14],[0,1,12,13]],
[[88,55,-15],[105,49,-38],[84,55,-30,],0xFF0000,[12,13,14,15],[14,15,20,345,350,351],[13,14]],
[[105,49,-38],[88,55,-15],[110,49,-19,],0xFF0000,[14,15,20,345,350,351],[12,13,14,15],[15,20,21]],
[[65,-45,-11],[62,-45,-22],[88,-47,-15,],0xFF0000,[10,11,16],[11,16,17],[16,17,18,19]],
[[88,-47,-15],[62,-45,-22],[84,-47,-30,],0xFF0000,[16,17,18,19],[11,16,17],[17,18,346,347,348,349]],
[[84,-47,-30],[105,-41,-38],[88,-47,-15,],0xFF0000,[17,18,346,347,348,349],[18,19,28,29,349,359],[16,17,18,19]],
[[88,-47,-15],[105,-41,-38],[110,-41,-19,],0xFF0000,[16,17,18,19],[18,19,28,29,349,359],[19,29]],
[[105,49,-38],[110,49,-19],[121,34,-44,],0xFF0000,[14,15,20,345,350,351],[15,20,21],[20,21,22]],
[[110,49,-19],[127,34,-22],[121,34,-44,],0xFF0000,[15,20,21],[21,22,23],[20,21,22]],
[[121,34,-44],[127,34,-22],[130,14,-47,],0xFF0000,[20,21,22],[21,22,23],[22,23,24]],
[[127,34,-22],[136,14,-24],[130,14,-47,],0xFF0000,[21,22,23],[23,24,25],[22,23,24]],
[[130,14,-47],[136,14,-24],[130,-6,-47,],0xFF0000,[22,23,24],[23,24,25],[24,25,26]],
[[136,14,-24],[136,-6,-24],[130,-6,-47,],0xFF0000,[23,24,25],[25,26,27],[24,25,26]],
[[130,-6,-47],[136,-6,-24],[121,-26,-44,],0xFF0000,[24,25,26],[25,26,27],[26,27,28,357,358,359]],
[[136,-6,-24],[127,-26,-22],[121,-26,-44,],0xFF0000,[25,26,27],[27,28,29],[26,27,28,357,358,359]],
[[121,-26,-44],[127,-26,-22],[105,-41,-38,],0xFF0000,[26,27,28,357,358,359],[27,28,29],[18,19,28,29,349,359]],
[[127,-26,-22],[110,-41,-19],[105,-41,-38,],0xFF0000,[27,28,29],[19,29],[18,19,28,29,349,359]],
[[110,49,-19],[112,49,0],[127,34,-22,],0xFF0000,[30,42,43],[30,31,43,60,72,73],[30,31,32]],
[[112,49,0],[129,34,0],[127,34,-22,],0xFF0000,[30,31,43,60,72,73],[31,32,33],[30,31,32]],
[[127,34,-22],[129,34,0],[136,14,-24,],0xFF0000,[30,31,32],[31,32,33],[32,33,34]],
[[129,34,0],[138,14,0],[136,14,-24,],0xFF0000,[31,32,33],[33,34,35],[32,33,34]],
[[136,14,-24],[138,14,0],[136,-6,-24,],0xFF0000,[32,33,34],[33,34,35],[34,35,36]],
[[138,14,0],[138,-6,0],[136,-6,-24,],0xFF0000,[33,34,35],[35,36,37],[34,35,36]],
[[136,-6,-24],[138,-6,0],[127,-26,-22,],0xFF0000,[34,35,36],[35,36,37],[36,37,38]],
[[138,-6,0],[129,-26,0],[127,-26,-22,],0xFF0000,[35,36,37],[37,38,39],[36,37,38]],
[[127,-26,-22],[129,-26,0],[110,-41,-19,],0xFF0000,[36,37,38],[37,38,39],[38,39,46,47]],
[[129,-26,0],[111,-41,0],[110,-41,-19,],0xFF0000,[37,38,39],[39,47],[38,39,46,47]],
[[66,53,0],[89,55,0],[65,53,-11,],0xFF0000,[40,48],[40,41,42,43],[40,41,48,49]],
[[89,55,0],[88,55,-15],[65,53,-11,],0xFF0000,[40,41,42,43],[41,42],[40,41,48,49]],
[[89,55,0],[110,49,-19],[88,55,-15,],0xFF0000,[40,41,42,43],[30,42,43],[41,42]],
[[110,49,-19],[89,55,0],[112,49,0,],0xFF0000,[30,42,43],[40,41,42,43],[30,31,43,60,72,73]],
[[66,-45,0],[65,-45,-11],[89,-47,0,],0xFF0000,[44,58,59],[44,45,59],[44,45,46,47]],
[[89,-47,0],[65,-45,-11],[88,-47,-15,],0xFF0000,[44,45,46,47],[44,45,59],[45,46]],
[[88,-47,-15],[110,-41,-19],[89,-47,0,],0xFF0000,[45,46],[38,39,46,47],[44,45,46,47]],
[[89,-47,0],[110,-41,-19],[111,-41,0,],0xFF0000,[44,45,46,47],[38,39,46,47],[39,47]],
[[66,53,0],[65,53,-11],[46,42,0,],0xFF0000,[40,48],[40,41,48,49],[48,49,50,79,80,81]],
[[46,42,0],[65,53,-11],[45,42,-8,],0xFF0000,[48,49,50,79,80,81],[40,41,48,49],[49,50,51]],
[[46,42,0],[45,42,-8],[32,25,0,],0xFF0000,[48,49,50,79,80,81],[49,50,51],[50,51,52]],
[[45,42,-8],[32,25,-5],[32,25,0,],0xFF0000,[49,50,51],[51,52,53],[50,51,52]],
[[32,25,0],[32,25,-5],[27,4,0,],0xFF0000,[50,51,52],[51,52,53],[52,53,54]],
[[32,25,-5],[27,4,-4],[27,4,0,],0xFF0000,[51,52,53],[53,54,55],[52,53,54]],
[[27,4,0],[27,4,-4],[32,-17,0,],0xFF0000,[52,53,54],[53,54,55],[54,55,56]],
[[27,4,-4],[32,-17,-5],[32,-17,0,],0xFF0000,[53,54,55],[55,56,57],[54,55,56]],
[[32,-17,0],[32,-17,-5],[46,-34,0,],0xFF0000,[54,55,56],[55,56,57],[56,57,58]],
[[32,-17,-5],[45,-34,-8],[46,-34,0,],0xFF0000,[55,56,57],[8,9,10,57,58,59],[56,57,58]],
[[46,-34,0],[45,-34,-8],[66,-45,0,],0xFF0000,[56,57,58],[8,9,10,57,58,59],[44,58,59]],
[[45,-34,-8],[65,-45,-11],[66,-45,0,],0xFF0000,[8,9,10,57,58,59],[44,45,59],[44,58,59]],
[[112,49,0],[110,49,19],[129,34,0,],0xFF0000,[30,31,43,60,72,73],[60,61,73],[60,61,62]],
[[110,49,19],[127,34,22],[129,34,0,],0xFF0000,[60,61,73],[61,62,63],[60,61,62]],
[[129,34,0],[127,34,22],[138,14,0,],0xFF0000,[60,61,62],[61,62,63],[62,63,64]],
[[127,34,22],[136,14,24],[138,14,0,],0xFF0000,[61,62,63],[63,64,65],[62,63,64]],
[[138,14,0],[136,14,24],[138,-6,0,],0xFF0000,[62,63,64],[63,64,65],[64,65,66]],
[[136,14,24],[136,-6,24],[138,-6,0,],0xFF0000,[63,64,65],[65,66,67],[64,65,66]],
[[138,-6,0],[136,-6,24],[129,-26,0,],0xFF0000,[64,65,66],[65,66,67],[66,67,68]],
[[136,-6,24],[127,-26,22],[129,-26,0,],0xFF0000,[65,66,67],[67,68,69],[66,67,68]],
[[129,-26,0],[127,-26,22],[111,-41,0,],0xFF0000,[66,67,68],[67,68,69],[68,69,76,77]],
[[127,-26,22],[110,-41,19],[111,-41,0,],0xFF0000,[67,68,69],[69,77],[68,69,76,77]],
[[65,53,11],[88,55,15],[66,53,0,],0xFF0000,[70,78,100,101,108,109],[70,71,72,73],[70,71,78,79]],
[[88,55,15],[89,55,0],[66,53,0,],0xFF0000,[70,71,72,73],[71,72],[70,71,78,79]],
[[88,55,15],[112,49,0],[89,55,0,],0xFF0000,[70,71,72,73],[30,31,43,60,72,73],[71,72]],
[[112,49,0],[88,55,15],[110,49,19,],0xFF0000,[30,31,43,60,72,73],[70,71,72,73],[60,61,73]],
[[65,-45,11],[66,-45,0],[88,-47,15,],0xFF0000,[74,88,89],[74,75,89],[74,75,76,77]],
[[88,-47,15],[66,-45,0],[89,-47,0,],0xFF0000,[74,75,76,77],[74,75,89],[75,76]],
[[89,-47,0],[111,-41,0],[88,-47,15,],0xFF0000,[75,76],[68,69,76,77],[74,75,76,77]],
[[88,-47,15],[111,-41,0],[110,-41,19,],0xFF0000,[74,75,76,77],[68,69,76,77],[69,77]],
[[65,53,11],[66,53,0],[45,42,8,],0xFF0000,[70,78,100,101,108,109],[70,71,78,79],[78,79,80]],
[[45,42,8],[66,53,0],[46,42,0,],0xFF0000,[78,79,80],[70,71,78,79],[48,49,50,79,80,81]],
[[45,42,8],[46,42,0],[32,25,5,],0xFF0000,[78,79,80],[48,49,50,79,80,81],[80,81,82]],
[[46,42,0],[32,25,0],[32,25,5,],0xFF0000,[48,49,50,79,80,81],[81,82,83],[80,81,82]],
[[32,25,5],[32,25,0],[27,4,4,],0xFF0000,[80,81,82],[81,82,83],[82,83,84]],
[[32,25,0],[27,4,0],[27,4,4,],0xFF0000,[81,82,83],[83,84,85],[82,83,84]],
[[27,4,4],[27,4,0],[32,-17,5,],0xFF0000,[82,83,84],[83,84,85],[84,85,86]],
[[27,4,0],[32,-17,0],[32,-17,5,],0xFF0000,[83,84,85],[85,86,87],[84,85,86]],
[[32,-17,5],[32,-17,0],[45,-34,8,],0xFF0000,[84,85,86],[85,86,87],[86,87,88]],
[[32,-17,0],[46,-34,0],[45,-34,8,],0xFF0000,[85,86,87],[87,88,89],[86,87,88]],
[[45,-34,8],[46,-34,0],[65,-45,11,],0xFF0000,[86,87,88],[87,88,89],[74,88,89]],
[[46,-34,0],[66,-45,0],[65,-45,11,],0xFF0000,[87,88,89],[74,75,89],[74,88,89]],
[[110,49,19],[105,49,38],[127,34,22,],0xFF0000,[90,102,103],[90,91,103],[90,91,92]],
[[105,49,38],[121,34,44],[127,34,22,],0xFF0000,[90,91,103],[91,92,93],[90,91,92]],
[[127,34,22],[121,34,44],[136,14,24,],0xFF0000,[90,91,92],[91,92,93],[92,93,94]],
[[121,34,44],[130,14,47],[136,14,24,],0xFF0000,[91,92,93],[93,94,95],[92,93,94]],
[[136,14,24],[130,14,47],[136,-6,24,],0xFF0000,[92,93,94],[93,94,95],[94,95,96]],
[[130,14,47],[130,-6,47],[136,-6,24,],0xFF0000,[93,94,95],[95,96,97],[94,95,96]],
[[136,-6,24],[130,-6,47],[127,-26,22,],0xFF0000,[94,95,96],[95,96,97],[96,97,98]],
[[130,-6,47],[121,-26,44],[127,-26,22,],0xFF0000,[95,96,97],[97,98,99],[96,97,98]],
[[127,-26,22],[121,-26,44],[110,-41,19,],0xFF0000,[96,97,98],[97,98,99],[98,99,106,107]],
[[121,-26,44],[105,-41,38],[110,-41,19,],0xFF0000,[97,98,99],[99,107],[98,99,106,107]],
[[62,53,22],[84,55,30],[65,53,11,],0xFF0000,[100,108],[100,101,102,103],[70,78,100,101,108,109]],
[[84,55,30],[88,55,15],[65,53,11,],0xFF0000,[100,101,102,103],[101,102],[70,78,100,101,108,109]],
[[84,55,30],[110,49,19],[88,55,15,],0xFF0000,[100,101,102,103],[90,102,103],[101,102]],
[[110,49,19],[84,55,30],[105,49,38,],0xFF0000,[90,102,103],[100,101,102,103],[90,91,103]],
[[62,-45,22],[65,-45,11],[84,-47,30,],0xFF0000,[104,118,119],[104,105,119],[104,105,106,107]],
[[84,-47,30],[65,-45,11],[88,-47,15,],0xFF0000,[104,105,106,107],[104,105,119],[105,106]],
[[88,-47,15],[110,-41,19],[84,-47,30,],0xFF0000,[105,106],[98,99,106,107],[104,105,106,107]],
[[84,-47,30],[110,-41,19],[105,-41,38,],0xFF0000,[104,105,106,107],[98,99,106,107],[99,107]],
[[62,53,22],[65,53,11],[43,42,15,],0xFF0000,[100,108],[70,78,100,101,108,109],[108,109,110]],
[[43,42,15],[65,53,11],[45,42,8,],0xFF0000,[108,109,110],[70,78,100,101,108,109],[109,110,111]],
[[43,42,15],[45,42,8],[30,25,11,],0xFF0000,[108,109,110],[109,110,111],[110,111,112]],
[[45,42,8],[32,25,5],[30,25,11,],0xFF0000,[109,110,111],[111,112,113],[110,111,112]],
[[30,25,11],[32,25,5],[26,4,9,],0xFF0000,[110,111,112],[111,112,113],[112,113,114]],
[[32,25,5],[27,4,4],[26,4,9,],0xFF0000,[111,112,113],[113,114,115],[112,113,114]],
[[26,4,9],[27,4,4],[30,-17,11,],0xFF0000,[112,113,114],[113,114,115],[114,115,116]],
[[27,4,4],[32,-17,5],[30,-17,11,],0xFF0000,[113,114,115],[115,116,117],[114,115,116]],
[[30,-17,11],[32,-17,5],[43,-34,15,],0xFF0000,[114,115,116],[115,116,117],[116,117,118]],
[[32,-17,5],[45,-34,8],[43,-34,15,],0xFF0000,[115,116,117],[117,118,119],[116,117,118]],
[[43,-34,15],[45,-34,8],[62,-45,22,],0xFF0000,[116,117,118],[117,118,119],[104,118,119]],
[[45,-34,8],[65,-45,11],[62,-45,22,],0xFF0000,[117,118,119],[104,105,119],[104,118,119]],
[[105,49,38],[96,49,55],[121,34,44,],0xFF0000,[120,132,133],[120,121,133],[120,121,122]],
[[96,49,55],[111,34,64],[121,34,44,],0xFF0000,[120,121,133],[121,122,123],[120,121,122]],
[[121,34,44],[111,34,64],[130,14,47,],0xFF0000,[120,121,122],[121,122,123],[122,123,124]],
[[111,34,64],[120,14,69],[130,14,47,],0xFF0000,[121,122,123],[123,124,125],[122,123,124]],
[[130,14,47],[120,14,69],[130,-6,47,],0xFF0000,[122,123,124],[123,124,125],[124,125,126]],
[[120,14,69],[120,-6,69],[130,-6,47,],0xFF0000,[123,124,125],[125,126,127],[124,125,126]],
[[130,-6,47],[120,-6,69],[121,-26,44,],0xFF0000,[124,125,126],[125,126,127],[126,127,128]],
[[120,-6,69],[111,-26,64],[121,-26,44,],0xFF0000,[125,126,127],[127,128,129],[126,127,128]],
[[121,-26,44],[111,-26,64],[105,-41,38,],0xFF0000,[126,127,128],[127,128,129],[128,129,136,137]],
[[111,-26,64],[96,-41,55],[105,-41,38,],0xFF0000,[127,128,129],[129,137],[128,129,136,137]],
[[57,53,33],[77,55,44],[62,53,22,],0xFF0000,[130,138,160,161,168,169],[130,131,132,133],[130,131,138,139]],
[[77,55,44],[84,55,30],[62,53,22,],0xFF0000,[130,131,132,133],[131,132],[130,131,138,139]],
[[77,55,44],[105,49,38],[84,55,30,],0xFF0000,[130,131,132,133],[120,132,133],[131,132]],
[[105,49,38],[77,55,44],[96,49,55,],0xFF0000,[120,132,133],[130,131,132,133],[120,121,133]],
[[57,-45,33],[62,-45,22],[77,-47,44,],0xFF0000,[134,148,149],[134,135,149],[134,135,136,137,165,166]],
[[77,-47,44],[62,-45,22],[84,-47,30,],0xFF0000,[134,135,136,137,165,166],[134,135,149],[135,136]],
[[84,-47,30],[105,-41,38],[77,-47,44,],0xFF0000,[135,136],[128,129,136,137],[134,135,136,137,165,166]],
[[77,-47,44],[105,-41,38],[96,-41,55,],0xFF0000,[134,135,136,137,165,166],[128,129,136,137],[129,137]],
[[57,53,33],[62,53,22],[40,42,23,],0xFF0000,[130,138,160,161,168,169],[130,131,138,139],[138,139,140,169,170,171]],
[[40,42,23],[62,53,22],[43,42,15,],0xFF0000,[138,139,140,169,170,171],[130,131,138,139],[139,140,141]],
[[40,42,23],[43,42,15],[28,25,16,],0xFF0000,[138,139,140,169,170,171],[139,140,141],[140,141,142]],
[[43,42,15],[30,25,11],[28,25,16,],0xFF0000,[139,140,141],[141,142,143],[140,141,142]],
[[28,25,16],[30,25,11],[24,4,13,],0xFF0000,[140,141,142],[141,142,143],[142,143,144]],
[[30,25,11],[26,4,9],[24,4,13,],0xFF0000,[141,142,143],[143,144,145],[142,143,144]],
[[24,4,13],[26,4,9],[28,-17,16,],0xFF0000,[142,143,144],[143,144,145],[144,145,146]],
[[26,4,9],[30,-17,11],[28,-17,16,],0xFF0000,[143,144,145],[145,146,147],[144,145,146]],
[[28,-17,16],[30,-17,11],[40,-34,23,],0xFF0000,[144,145,146],[145,146,147],[146,147,148,177,178,179]],
[[30,-17,11],[43,-34,15],[40,-34,23,],0xFF0000,[145,146,147],[147,148,149],[146,147,148,177,178,179]],
[[40,-34,23],[43,-34,15],[57,-45,33,],0xFF0000,[146,147,148,177,178,179],[147,148,149],[134,148,149]],
[[43,-34,15],[62,-45,22],[57,-45,33,],0xFF0000,[147,148,149],[134,135,149],[134,148,149]],
[[96,49,56],[85,49,71],[111,34,64,],0xFF0000,[150,162,163],[150,151,163],[150,151,152]],
[[85,49,71],[99,34,83],[111,34,64,],0xFF0000,[150,151,163],[151,152,153],[150,151,152]],
[[111,34,64],[99,34,83],[120,14,69,],0xFF0000,[150,151,152],[151,152,153],[152,153,154]],
[[99,34,83],[106,14,89],[120,14,69,],0xFF0000,[151,152,153],[153,154,155],[152,153,154]],
[[120,14,69],[106,14,89],[120,-6,69,],0xFF0000,[152,153,154],[153,154,155],[154,155,156]],
[[106,14,89],[106,-6,89],[120,-6,69,],0xFF0000,[153,154,155],[155,156,157],[154,155,156]],
[[120,-6,69],[106,-6,89],[111,-26,64,],0xFF0000,[154,155,156],[155,156,157],[156,157,158]],
[[106,-6,89],[99,-26,83],[111,-26,64,],0xFF0000,[155,156,157],[157,158,159],[156,157,158]],
[[111,-26,64],[99,-26,83],[96,-41,55,],0xFF0000,[156,157,158],[157,158,159],[158,159,166,167]],
[[99,-26,83],[85,-41,71],[96,-41,55,],0xFF0000,[157,158,159],[159,167],[158,159,166,167]],
[[51,53,42],[68,55,57],[57,53,33,],0xFF0000,[160,168,190,191,198,199],[160,161,162,163,191,192],[130,138,160,161,168,169]],
[[68,55,57],[77,55,44],[57,53,33,],0xFF0000,[160,161,162,163,191,192],[161,162],[130,138,160,161,168,169]],
[[68,55,57],[96,49,56],[77,55,44,],0xFF0000,[160,161,162,163,191,192],[150,162,163],[161,162]],
[[96,49,56],[68,55,57],[85,49,71,],0xFF0000,[150,162,163],[160,161,162,163,191,192],[150,151,163]],
[[51,-45,42],[57,-45,33],[68,-47,57,],0xFF0000,[164,178,179,194,195,209],[164,165,179],[164,165,166,167]],
[[68,-47,57],[57,-45,33],[77,-47,44,],0xFF0000,[164,165,166,167],[164,165,179],[134,135,136,137,165,166]],
[[77,-47,44],[96,-41,55],[68,-47,57,],0xFF0000,[134,135,136,137,165,166],[158,159,166,167],[164,165,166,167]],
[[68,-47,57],[96,-41,55],[85,-41,71,],0xFF0000,[164,165,166,167],[158,159,166,167],[159,167]],
[[51,53,42],[57,53,33],[35,42,29,],0xFF0000,[160,168,190,191,198,199],[130,138,160,161,168,169],[168,169,170]],
[[35,42,29],[57,53,33],[40,42,23,],0xFF0000,[168,169,170],[130,138,160,161,168,169],[138,139,140,169,170,171]],
[[35,42,29],[40,42,23],[25,25,21,],0xFF0000,[168,169,170],[138,139,140,169,170,171],[170,171,172]],
[[40,42,23],[28,25,16],[25,25,21,],0xFF0000,[138,139,140,169,170,171],[171,172,173],[170,171,172]],
[[25,25,21],[28,25,16],[21,4,17,],0xFF0000,[170,171,172],[171,172,173],[172,173,174]],
[[28,25,16],[24,4,13],[21,4,17,],0xFF0000,[171,172,173],[173,174,175],[172,173,174]],
[[21,4,17],[24,4,13],[25,-17,21,],0xFF0000,[172,173,174],[173,174,175],[174,175,176]],
[[24,4,13],[28,-17,16],[25,-17,21,],0xFF0000,[173,174,175],[175,176,177],[174,175,176]],
[[25,-17,21],[28,-17,16],[35,-34,29,],0xFF0000,[174,175,176],[175,176,177],[176,177,178]],
[[28,-17,16],[40,-34,23],[35,-34,29,],0xFF0000,[175,176,177],[146,147,148,177,178,179],[176,177,178]],
[[35,-34,29],[40,-34,23],[51,-45,42,],0xFF0000,[176,177,178],[146,147,148,177,178,179],[164,178,179,194,195,209]],
[[40,-34,23],[57,-45,33],[51,-45,42,],0xFF0000,[146,147,148,177,178,179],[164,165,179],[164,178,179,194,195,209]],
[[85,49,71],[71,49,85],[99,34,83,],0xFF0000,[180,192,193],[180,181,193],[180,181,182]],
[[71,49,85],[83,34,99],[99,34,83,],0xFF0000,[180,181,193],[181,182,183],[180,181,182]],
[[99,34,83],[83,34,99],[106,14,89,],0xFF0000,[180,181,182],[181,182,183],[182,183,184]],
[[83,34,99],[89,14,106],[106,14,89,],0xFF0000,[181,182,183],[183,184,185],[182,183,184]],
[[106,14,89],[89,14,106],[106,-6,89,],0xFF0000,[182,183,184],[183,184,185],[184,185,186]],
[[89,14,106],[89,-6,106],[106,-6,89,],0xFF0000,[183,184,185],[185,186,187],[184,185,186]],
[[106,-6,89],[89,-6,106],[99,-26,83,],0xFF0000,[184,185,186],[185,186,187],[186,187,188]],
[[89,-6,106],[83,-26,99],[99,-26,83,],0xFF0000,[185,186,187],[187,188,189],[186,187,188]],
[[99,-26,83],[83,-26,99],[85,-41,71,],0xFF0000,[186,187,188],[187,188,189],[188,189,196,197]],
[[83,-26,99],[71,-41,85],[85,-41,71,],0xFF0000,[187,188,189],[189,197,218,219,226,227],[188,189,196,197]],
[[42,53,51],[57,55,68],[51,53,42,],0xFF0000,[190,198],[190,191,192,193],[160,168,190,191,198,199]],
[[57,55,68],[68,55,57],[51,53,42,],0xFF0000,[190,191,192,193],[160,161,162,163,191,192],[160,168,190,191,198,199]],
[[57,55,68],[85,49,71],[68,55,57,],0xFF0000,[190,191,192,193],[180,192,193],[160,161,162,163,191,192]],
[[85,49,71],[57,55,68],[71,49,85,],0xFF0000,[180,192,193],[190,191,192,193],[180,181,193]],
[[42,-45,51],[51,-45,42],[57,-47,68,],0xFF0000,[194,208,209],[164,178,179,194,195,209],[194,195,196,197]],
[[57,-47,68],[51,-45,42],[68,-47,57,],0xFF0000,[194,195,196,197],[164,178,179,194,195,209],[195,196]],
[[68,-47,57],[85,-41,71],[57,-47,68,],0xFF0000,[195,196],[188,189,196,197],[194,195,196,197]],
[[57,-47,68],[85,-41,71],[71,-41,85,],0xFF0000,[194,195,196,197],[188,189,196,197],[189,197,218,219,226,227]],
[[42,53,51],[51,53,42],[29,42,35,],0xFF0000,[190,198],[160,168,190,191,198,199],[198,199,200]],
[[29,42,35],[51,53,42],[35,42,29,],0xFF0000,[198,199,200],[160,168,190,191,198,199],[199,200,201]],
[[29,42,35],[35,42,29],[21,25,25,],0xFF0000,[198,199,200],[199,200,201],[200,201,202,231,232,233]],
[[35,42,29],[25,25,21],[21,25,25,],0xFF0000,[199,200,201],[201,202,203],[200,201,202,231,232,233]],
[[21,25,25],[25,25,21],[17,4,21,],0xFF0000,[200,201,202,231,232,233],[201,202,203],[202,203,204,233,234,235]],
[[25,25,21],[21,4,17],[17,4,21,],0xFF0000,[201,202,203],[203,204,205],[202,203,204,233,234,235]],
[[17,4,21],[21,4,17],[21,-17,25,],0xFF0000,[202,203,204,233,234,235],[203,204,205],[204,205,206,235,236,237]],
[[21,4,17],[25,-17,21],[21,-17,25,],0xFF0000,[203,204,205],[205,206,207],[204,205,206,235,236,237]],
[[21,-17,25],[25,-17,21],[29,-34,35,],0xFF0000,[204,205,206,235,236,237],[205,206,207],[206,207,208]],
[[25,-17,21],[35,-34,29],[29,-34,35,],0xFF0000,[205,206,207],[207,208,209],[206,207,208]],
[[29,-34,35],[35,-34,29],[42,-45,51,],0xFF0000,[206,207,208],[207,208,209],[194,208,209]],
[[35,-34,29],[51,-45,42],[42,-45,51,],0xFF0000,[207,208,209],[164,178,179,194,195,209],[194,208,209]],
[[71,49,85],[56,49,96],[83,34,99,],0xFF0000,[210,222,223],[210,211,223],[210,211,212]],
[[56,49,96],[64,34,111],[83,34,99,],0xFF0000,[210,211,223],[211,212,213],[210,211,212]],
[[83,34,99],[64,34,111],[89,14,106,],0xFF0000,[210,211,212],[211,212,213],[212,213,214]],
[[64,34,111],[69,14,120],[89,14,106,],0xFF0000,[211,212,213],[213,214,215],[212,213,214]],
[[89,14,106],[69,14,120],[89,-6,106,],0xFF0000,[212,213,214],[213,214,215],[214,215,216]],
[[69,14,120],[69,-6,120],[89,-6,106,],0xFF0000,[213,214,215],[215,216,217],[214,215,216]],
[[89,-6,106],[69,-6,120],[83,-26,99,],0xFF0000,[214,215,216],[215,216,217],[216,217,218]],
[[69,-6,120],[64,-26,111],[83,-26,99,],0xFF0000,[215,216,217],[217,218,219],[216,217,218]],
[[83,-26,99],[64,-26,111],[71,-41,85,],0xFF0000,[216,217,218],[217,218,219],[189,197,218,219,226,227]],
[[64,-26,111],[56,-41,96],[71,-41,85,],0xFF0000,[217,218,219],[219,227],[189,197,218,219,226,227]],
[[33,53,57],[44,55,77],[42,53,51,],0xFF0000,[220,228],[220,221,222,223],[220,221,228,229]],
[[44,55,77],[57,55,68],[42,53,51,],0xFF0000,[220,221,222,223],[221,222],[220,221,228,229]],
[[44,55,77],[71,49,85],[57,55,68,],0xFF0000,[220,221,222,223],[210,222,223],[221,222]],
[[71,49,85],[44,55,77],[56,49,96,],0xFF0000,[210,222,223],[220,221,222,223],[210,211,223]],
[[33,-45,57],[42,-45,51],[44,-47,77,],0xFF0000,[224,238,239],[224,225,239],[224,225,226,227,255,256]],
[[44,-47,77],[42,-45,51],[57,-47,68,],0xFF0000,[224,225,226,227,255,256],[224,225,239],[225,226]],
[[57,-47,68],[71,-41,85],[44,-47,77,],0xFF0000,[225,226],[189,197,218,219,226,227],[224,225,226,227,255,256]],
[[44,-47,77],[71,-41,85],[56,-41,96,],0xFF0000,[224,225,226,227,255,256],[189,197,218,219,226,227],[219,227]],
[[33,53,57],[42,53,51],[23,42,40,],0xFF0000,[220,228],[220,221,228,229],[228,229,230]],
[[23,42,40],[42,53,51],[29,42,35,],0xFF0000,[228,229,230],[220,221,228,229],[229,230,231]],
[[23,42,40],[29,42,35],[16,25,28,],0xFF0000,[228,229,230],[229,230,231],[230,231,232]],
[[29,42,35],[21,25,25],[16,25,28,],0xFF0000,[229,230,231],[200,201,202,231,232,233],[230,231,232]],
[[16,25,28],[21,25,25],[14,4,24,],0xFF0000,[230,231,232],[200,201,202,231,232,233],[232,233,234]],
[[21,25,25],[17,4,21],[14,4,24,],0xFF0000,[200,201,202,231,232,233],[202,203,204,233,234,235],[232,233,234]],
[[14,4,24],[17,4,21],[16,-17,28,],0xFF0000,[232,233,234],[202,203,204,233,234,235],[234,235,236]],
[[17,4,21],[21,-17,25],[16,-17,28,],0xFF0000,[202,203,204,233,234,235],[204,205,206,235,236,237],[234,235,236]],
[[16,-17,28],[21,-17,25],[23,-34,40,],0xFF0000,[234,235,236],[204,205,206,235,236,237],[236,237,238,267,268,269]],
[[21,-17,25],[29,-34,35],[23,-34,40,],0xFF0000,[204,205,206,235,236,237],[237,238,239],[236,237,238,267,268,269]],
[[23,-34,40],[29,-34,35],[33,-45,57,],0xFF0000,[236,237,238,267,268,269],[237,238,239],[224,238,239]],
[[29,-34,35],[42,-45,51],[33,-45,57,],0xFF0000,[237,238,239],[224,225,239],[224,238,239]],
[[56,49,96],[38,49,105],[64,34,111,],0xFF0000,[240,252,253],[240,241,253,270,282,283],[240,241,242]],
[[38,49,105],[44,34,121],[64,34,111,],0xFF0000,[240,241,253,270,282,283],[241,242,243],[240,241,242]],
[[64,34,111],[44,34,121],[69,14,120,],0xFF0000,[240,241,242],[241,242,243],[242,243,244]],
[[44,34,121],[47,14,130],[69,14,120,],0xFF0000,[241,242,243],[243,244,245],[242,243,244]],
[[69,14,120],[47,14,130],[69,-6,120,],0xFF0000,[242,243,244],[243,244,245],[244,245,246]],
[[47,14,130],[47,-6,130],[69,-6,120,],0xFF0000,[243,244,245],[245,246,247],[244,245,246]],
[[69,-6,120],[47,-6,130],[64,-26,111,],0xFF0000,[244,245,246],[245,246,247],[246,247,248]],
[[47,-6,130],[44,-26,121],[64,-26,111,],0xFF0000,[245,246,247],[247,248,249],[246,247,248]],
[[64,-26,111],[44,-26,121],[56,-41,96,],0xFF0000,[246,247,248],[247,248,249],[248,249,256,257]],
[[44,-26,121],[38,-41,105],[56,-41,96,],0xFF0000,[247,248,249],[249,257,278,279,286,287],[248,249,256,257]],
[[22,53,62],[30,55,84],[33,53,57,],0xFF0000,[250,258],[250,251,252,253,281,282],[250,251,258,259]],
[[30,55,84],[44,55,77],[33,53,57,],0xFF0000,[250,251,252,253,281,282],[251,252],[250,251,258,259]],
[[30,55,84],[56,49,96],[44,55,77,],0xFF0000,[250,251,252,253,281,282],[240,252,253],[251,252]],
[[56,49,96],[30,55,84],[38,49,105,],0xFF0000,[240,252,253],[250,251,252,253,281,282],[240,241,253,270,282,283]],
[[22,-45,62],[33,-45,57],[30,-47,84,],0xFF0000,[254,268,269],[254,255,269],[254,255,256,257]],
[[30,-47,84],[33,-45,57],[44,-47,77,],0xFF0000,[254,255,256,257],[254,255,269],[224,225,226,227,255,256]],
[[44,-47,77],[56,-41,96],[30,-47,84,],0xFF0000,[224,225,226,227,255,256],[248,249,256,257],[254,255,256,257]],
[[30,-47,84],[56,-41,96],[38,-41,105,],0xFF0000,[254,255,256,257],[248,249,256,257],[249,257,278,279,286,287]],
[[22,53,62],[33,53,57],[15,42,43,],0xFF0000,[250,258],[250,251,258,259],[258,259,260]],
[[15,42,43],[33,53,57],[23,42,40,],0xFF0000,[258,259,260],[250,251,258,259],[259,260,261]],
[[15,42,43],[23,42,40],[11,25,30,],0xFF0000,[258,259,260],[259,260,261],[260,261,262,291,292,293]],
[[23,42,40],[16,25,28],[11,25,30,],0xFF0000,[259,260,261],[261,262,263],[260,261,262,291,292,293]],
[[11,25,30],[16,25,28],[9,4,26,],0xFF0000,[260,261,262,291,292,293],[261,262,263],[262,263,264,293,294,295]],
[[16,25,28],[14,4,24],[9,4,26,],0xFF0000,[261,262,263],[263,264,265],[262,263,264,293,294,295]],
[[9,4,26],[14,4,24],[11,-17,30,],0xFF0000,[262,263,264,293,294,295],[263,264,265],[264,265,266,295,296,297]],
[[14,4,24],[16,-17,28],[11,-17,30,],0xFF0000,[263,264,265],[265,266,267],[264,265,266,295,296,297]],
[[11,-17,30],[16,-17,28],[15,-34,43,],0xFF0000,[264,265,266,295,296,297],[265,266,267],[266,267,268]],
[[16,-17,28],[23,-34,40],[15,-34,43,],0xFF0000,[265,266,267],[236,237,238,267,268,269],[266,267,268]],
[[15,-34,43],[23,-34,40],[22,-45,62,],0xFF0000,[266,267,268],[236,237,238,267,268,269],[254,268,269]],
[[23,-34,40],[33,-45,57],[22,-45,62,],0xFF0000,[236,237,238,267,268,269],[254,255,269],[254,268,269]],
[[38,49,105],[19,49,110],[44,34,121,],0xFF0000,[240,241,253,270,282,283],[270,271,283],[270,271,272]],
[[19,49,110],[22,34,127],[44,34,121,],0xFF0000,[270,271,283],[271,272,273],[270,271,272]],
[[44,34,121],[22,34,127],[47,14,130,],0xFF0000,[270,271,272],[271,272,273],[272,273,274]],
[[22,34,127],[24,14,136],[47,14,130,],0xFF0000,[271,272,273],[273,274,275],[272,273,274]],
[[47,14,130],[24,14,136],[47,-6,130,],0xFF0000,[272,273,274],[273,274,275],[274,275,276]],
[[24,14,136],[24,-6,136],[47,-6,130,],0xFF0000,[273,274,275],[275,276,277],[274,275,276]],
[[47,-6,130],[24,-6,136],[44,-26,121,],0xFF0000,[274,275,276],[275,276,277],[276,277,278]],
[[24,-6,136],[22,-26,127],[44,-26,121,],0xFF0000,[275,276,277],[277,278,279],[276,277,278]],
[[44,-26,121],[22,-26,127],[38,-41,105,],0xFF0000,[276,277,278],[277,278,279],[249,257,278,279,286,287]],
[[22,-26,127],[19,-41,110],[38,-41,105,],0xFF0000,[277,278,279],[279,287],[249,257,278,279,286,287]],
[[11,53,65],[15,55,88],[22,53,62,],0xFF0000,[280,288],[280,281,282,283],[280,281,288,289]],
[[15,55,88],[30,55,84],[22,53,62,],0xFF0000,[280,281,282,283],[250,251,252,253,281,282],[280,281,288,289]],
[[15,55,88],[38,49,105],[30,55,84,],0xFF0000,[280,281,282,283],[240,241,253,270,282,283],[250,251,252,253,281,282]],
[[38,49,105],[15,55,88],[19,49,110,],0xFF0000,[240,241,253,270,282,283],[280,281,282,283],[270,271,283]],
[[11,-45,65],[22,-45,62],[15,-47,88,],0xFF0000,[284,298,299],[284,285,299],[284,285,286,287]],
[[15,-47,88],[22,-45,62],[30,-47,84,],0xFF0000,[284,285,286,287],[284,285,299],[285,286]],
[[30,-47,84],[38,-41,105],[15,-47,88,],0xFF0000,[285,286],[249,257,278,279,286,287],[284,285,286,287]],
[[15,-47,88],[38,-41,105],[19,-41,110,],0xFF0000,[284,285,286,287],[249,257,278,279,286,287],[279,287]],
[[11,53,65],[22,53,62],[8,42,45,],0xFF0000,[280,288],[280,281,288,289],[288,289,290]],
[[8,42,45],[22,53,62],[15,42,43,],0xFF0000,[288,289,290],[280,281,288,289],[289,290,291]],
[[8,42,45],[15,42,43],[5,25,32,],0xFF0000,[288,289,290],[289,290,291],[290,291,292]],
[[15,42,43],[11,25,30],[5,25,32,],0xFF0000,[289,290,291],[260,261,262,291,292,293],[290,291,292]],
[[5,25,32],[11,25,30],[4,4,27,],0xFF0000,[290,291,292],[260,261,262,291,292,293],[292,293,294]],
[[11,25,30],[9,4,26],[4,4,27,],0xFF0000,[260,261,262,291,292,293],[262,263,264,293,294,295],[292,293,294]],
[[4,4,27],[9,4,26],[5,-17,32,],0xFF0000,[292,293,294],[262,263,264,293,294,295],[294,295,296]],
[[9,4,26],[11,-17,30],[5,-17,32,],0xFF0000,[262,263,264,293,294,295],[264,265,266,295,296,297],[294,295,296]],
[[5,-17,32],[11,-17,30],[8,-34,45,],0xFF0000,[294,295,296],[264,265,266,295,296,297],[296,297,298,327,328,329]],
[[11,-17,30],[15,-34,43],[8,-34,45,],0xFF0000,[264,265,266,295,296,297],[297,298,299],[296,297,298,327,328,329]],
[[8,-34,45],[15,-34,43],[11,-45,65,],0xFF0000,[296,297,298,327,328,329],[297,298,299],[284,298,299]],
[[15,-34,43],[22,-45,62],[11,-45,65,],0xFF0000,[297,298,299],[284,285,299],[284,298,299]],
[[19,49,110],[0,49,112],[22,34,127,],0xFF0000,[300,312,313],[300,301,313],[300,301,302]],
[[0,49,112],[0,34,129],[22,34,127,],0xFF0000,[300,301,313],[301,302,303],[300,301,302]],
[[22,34,127],[0,34,129],[24,14,136,],0xFF0000,[300,301,302],[301,302,303],[302,303,304]],
[[0,34,129],[0,14,138],[24,14,136,],0xFF0000,[301,302,303],[303,304,305],[302,303,304]],
[[24,14,136],[0,14,138],[24,-6,136,],0xFF0000,[302,303,304],[303,304,305],[304,305,306]],
[[0,14,138],[0,-6,138],[24,-6,136,],0xFF0000,[303,304,305],[305,306,307],[304,305,306]],
[[24,-6,136],[0,-6,138],[22,-26,127,],0xFF0000,[304,305,306],[305,306,307],[306,307,308]],
[[0,-6,138],[0,-26,129],[22,-26,127,],0xFF0000,[305,306,307],[307,308,309],[306,307,308]],
[[22,-26,127],[0,-26,129],[19,-41,110,],0xFF0000,[306,307,308],[307,308,309],[308,309,316,317]],
[[0,-26,129],[0,-41,111],[19,-41,110,],0xFF0000,[307,308,309],[309,317],[308,309,316,317]],
[[0,53,66],[0,55,89],[11,53,65,],0xFF0000,[310,318],[310,311,312,313],[310,311,318,319]],
[[0,55,89],[15,55,88],[11,53,65,],0xFF0000,[310,311,312,313],[311,312],[310,311,318,319]],
[[0,55,89],[19,49,110],[15,55,88,],0xFF0000,[310,311,312,313],[300,312,313],[311,312]],
[[19,49,110],[0,55,89],[0,49,112,],0xFF0000,[300,312,313],[310,311,312,313],[300,301,313]],
[[0,-45,66],[11,-45,65],[0,-47,89,],0xFF0000,[314,328,329],[314,315,329],[314,315,316,317]],
[[0,-47,89],[11,-45,65],[15,-47,88,],0xFF0000,[314,315,316,317],[314,315,329],[315,316]],
[[15,-47,88],[19,-41,110],[0,-47,89,],0xFF0000,[315,316],[308,309,316,317],[314,315,316,317]],
[[0,-47,89],[19,-41,110],[0,-41,111,],0xFF0000,[314,315,316,317],[308,309,316,317],[309,317]],
[[0,53,66],[11,53,65],[0,42,46,],0xFF0000,[310,318],[310,311,318,319],[318,319,320]],
[[0,42,46],[11,53,65],[8,42,45,],0xFF0000,[318,319,320],[310,311,318,319],[319,320,321]],
[[0,42,46],[8,42,45],[0,25,32,],0xFF0000,[318,319,320],[319,320,321],[320,321,322]],
[[8,42,45],[5,25,32],[0,25,32,],0xFF0000,[319,320,321],[321,322,323],[320,321,322]],
[[0,25,32],[5,25,32],[0,4,27,],0xFF0000,[320,321,322],[321,322,323],[322,323,324]],
[[5,25,32],[4,4,27],[0,4,27,],0xFF0000,[321,322,323],[323,324,325],[322,323,324]],
[[0,4,27],[4,4,27],[0,-17,32,],0xFF0000,[322,323,324],[323,324,325],[324,325,326]],
[[4,4,27],[5,-17,32],[0,-17,32,],0xFF0000,[323,324,325],[325,326,327],[324,325,326]],
[[0,-17,32],[5,-17,32],[0,-34,46,],0xFF0000,[324,325,326],[325,326,327],[326,327,328]],
[[5,-17,32],[8,-34,45],[0,-34,46,],0xFF0000,[325,326,327],[296,297,298,327,328,329],[326,327,328]],
[[0,-34,46],[8,-34,45],[0,-45,66,],0xFF0000,[326,327,328],[296,297,298,327,328,329],[314,328,329]],
[[8,-34,45],[11,-45,65],[0,-45,66,],0xFF0000,[296,297,298,327,328,329],[314,315,329],[314,328,329]],
[[62,53,-22],[57,53,-33],[43,42,-15,],0xFF0000,[330,342],[330,331,342,343],[330,331,332]],
[[43,42,-15],[57,53,-33],[40,42,-23,],0xFF0000,[330,331,332],[330,331,342,343],[331,332,333]],
[[43,42,-15],[40,42,-23],[30,25,-11,],0xFF0000,[330,331,332],[331,332,333],[3,4,5,332,333,334]],
[[40,42,-23],[28,25,-16],[30,25,-11,],0xFF0000,[331,332,333],[333,334,335],[3,4,5,332,333,334]],
[[30,25,-11],[28,25,-16],[26,4,-9,],0xFF0000,[3,4,5,332,333,334],[333,334,335],[5,6,7,334,335,336]],
[[28,25,-16],[24,4,-14],[26,4,-9,],0xFF0000,[333,334,335],[335,336,337],[5,6,7,334,335,336]],
[[26,4,-9],[24,4,-14],[30,-17,-11,],0xFF0000,[5,6,7,334,335,336],[335,336,337],[7,8,9,336,337,338]],
[[24,4,-14],[28,-17,-16],[30,-17,-11,],0xFF0000,[335,336,337],[337,338,339],[7,8,9,336,337,338]],
[[30,-17,-11],[28,-17,-16],[43,-34,-15,],0xFF0000,[7,8,9,336,337,338],[337,338,339],[338,339,340]],
[[28,-17,-16],[40,-34,-23],[43,-34,-15,],0xFF0000,[337,338,339],[339,340,341],[338,339,340]],
[[43,-34,-15],[40,-34,-23],[62,-45,-22,],0xFF0000,[338,339,340],[339,340,341],[340,341,346]],
[[40,-34,-23],[57,-45,-33],[62,-45,-22,],0xFF0000,[339,340,341],[341,346,347],[340,341,346]],
[[62,53,-22],[84,55,-30],[57,53,-33,],0xFF0000,[330,342],[342,343,344,345],[330,331,342,343]],
[[84,55,-30],[77,55,-44],[57,53,-33,],0xFF0000,[342,343,344,345],[343,344],[330,331,342,343]],
[[84,55,-30],[96,49,-56],[77,55,-44,],0xFF0000,[342,343,344,345],[344,345,350],[343,344]],
[[96,49,-56],[84,55,-30],[105,49,-38,],0xFF0000,[344,345,350],[342,343,344,345],[14,15,20,345,350,351]],
[[62,-45,-22],[57,-45,-33],[84,-47,-30,],0xFF0000,[340,341,346],[341,346,347],[17,18,346,347,348,349]],
[[84,-47,-30],[57,-45,-33],[77,-47,-44,],0xFF0000,[17,18,346,347,348,349],[341,346,347],[347,348]],
[[77,-47,-44],[96,-41,-56],[84,-47,-30,],0xFF0000,[347,348],[348,349,358,359],[17,18,346,347,348,349]],
[[84,-47,-30],[96,-41,-56],[105,-41,-38,],0xFF0000,[17,18,346,347,348,349],[348,349,358,359],[18,19,28,29,349,359]],
[[96,49,-56],[105,49,-38],[111,34,-64,],0xFF0000,[344,345,350],[14,15,20,345,350,351],[350,351,352]],
[[105,49,-38],[121,34,-44],[111,34,-64,],0xFF0000,[14,15,20,345,350,351],[351,352,353],[350,351,352]],
[[111,34,-64],[121,34,-44],[120,14,-69,],0xFF0000,[350,351,352],[351,352,353],[352,353,354]],
[[121,34,-44],[130,14,-47],[120,14,-69,],0xFF0000,[351,352,353],[353,354,355],[352,353,354]],
[[120,14,-69],[130,14,-47],[120,-6,-69,],0xFF0000,[352,353,354],[353,354,355],[354,355,356]],
[[130,14,-47],[130,-6,-47],[120,-6,-69,],0xFF0000,[353,354,355],[355,356,357],[354,355,356]],
[[120,-6,-69],[130,-6,-47],[111,-26,-64,],0xFF0000,[354,355,356],[355,356,357],[356,357,358]],
[[130,-6,-47],[121,-26,-44],[111,-26,-64,],0xFF0000,[355,356,357],[26,27,28,357,358,359],[356,357,358]],
[[111,-26,-64],[121,-26,-44],[96,-41,-56,],0xFF0000,[356,357,358],[26,27,28,357,358,359],[348,349,358,359]],
[[121,-26,-44],[105,-41,-38],[96,-41,-56,],0xFF0000,[26,27,28,357,358,359],[18,19,28,29,349,359],[348,349,358,359]],
[[57,53,-33],[51,53,-42],[40,42,-23,],0xFF0000,[360,372],[360,361,372,373,390,402],[360,361,362]],
[[40,42,-23],[51,53,-42],[35,42,-29,],0xFF0000,[360,361,362],[360,361,372,373,390,402],[361,362,363]],
[[40,42,-23],[35,42,-29],[28,25,-16,],0xFF0000,[360,361,362],[361,362,363],[362,363,364]],
[[35,42,-29],[25,25,-21],[28,25,-16,],0xFF0000,[361,362,363],[363,364,365,392,393,394],[362,363,364]],
[[28,25,-16],[25,25,-21],[24,4,-14,],0xFF0000,[362,363,364],[363,364,365,392,393,394],[364,365,366]],
[[25,25,-21],[21,4,-17],[24,4,-14,],0xFF0000,[363,364,365,392,393,394],[365,366,367],[364,365,366]],
[[24,4,-14],[21,4,-17],[28,-17,-16,],0xFF0000,[364,365,366],[365,366,367],[366,367,368]],
[[21,4,-17],[25,-17,-21],[28,-17,-16,],0xFF0000,[365,366,367],[367,368,369,396,397,398],[366,367,368]],
[[28,-17,-16],[25,-17,-21],[40,-34,-23,],0xFF0000,[366,367,368],[367,368,369,396,397,398],[368,369,370]],
[[25,-17,-21],[35,-34,-29],[40,-34,-23,],0xFF0000,[367,368,369,396,397,398],[369,370,371,398,399,400],[368,369,370]],
[[40,-34,-23],[35,-34,-29],[57,-45,-33,],0xFF0000,[368,369,370],[369,370,371,398,399,400],[370,371,376]],
[[35,-34,-29],[51,-45,-42],[57,-45,-33,],0xFF0000,[369,370,371,398,399,400],[371,376,377],[370,371,376]],
[[57,53,-33],[77,55,-44],[51,53,-42,],0xFF0000,[360,372],[372,373,374,375],[360,361,372,373,390,402]],
[[77,55,-44],[68,55,-57],[51,53,-42,],0xFF0000,[372,373,374,375],[373,374],[360,361,372,373,390,402]],
[[77,55,-44],[85,49,-71],[68,55,-57,],0xFF0000,[372,373,374,375],[374,375,380],[373,374]],
[[85,49,-71],[77,55,-44],[96,49,-56,],0xFF0000,[374,375,380],[372,373,374,375],[375,380,381]],
[[57,-45,-33],[51,-45,-42],[77,-47,-44,],0xFF0000,[370,371,376],[371,376,377],[376,377,378,379]],
[[77,-47,-44],[51,-45,-42],[68,-47,-57,],0xFF0000,[376,377,378,379],[371,376,377],[377,378,406,407,408,409]],
[[68,-47,-57],[85,-41,-71],[77,-47,-44,],0xFF0000,[377,378,406,407,408,409],[378,379,388,389],[376,377,378,379]],
[[77,-47,-44],[85,-41,-71],[96,-41,-56,],0xFF0000,[376,377,378,379],[378,379,388,389],[379,389]],
[[85,49,-71],[96,49,-56],[99,34,-83,],0xFF0000,[374,375,380],[375,380,381],[380,381,382]],
[[96,49,-56],[111,34,-64],[99,34,-83,],0xFF0000,[375,380,381],[381,382,383],[380,381,382]],
[[99,34,-83],[111,34,-64],[106,14,-89,],0xFF0000,[380,381,382],[381,382,383],[382,383,384]],
[[111,34,-64],[120,14,-69],[106,14,-89,],0xFF0000,[381,382,383],[383,384,385],[382,383,384]],
[[106,14,-89],[120,14,-69],[106,-6,-89,],0xFF0000,[382,383,384],[383,384,385],[384,385,386]],
[[120,14,-69],[120,-6,-69],[106,-6,-89,],0xFF0000,[383,384,385],[385,386,387],[384,385,386]],
[[106,-6,-89],[120,-6,-69],[99,-26,-83,],0xFF0000,[384,385,386],[385,386,387],[386,387,388,417,418,419]],
[[120,-6,-69],[111,-26,-64],[99,-26,-83,],0xFF0000,[385,386,387],[387,388,389],[386,387,388,417,418,419]],
[[99,-26,-83],[111,-26,-64],[85,-41,-71,],0xFF0000,[386,387,388,417,418,419],[387,388,389],[378,379,388,389]],
[[111,-26,-64],[96,-41,-56],[85,-41,-71,],0xFF0000,[387,388,389],[379,389],[378,379,388,389]],
[[51,53,-42],[42,53,-51],[35,42,-29,],0xFF0000,[360,361,372,373,390,402],[390,391,402,403],[390,391,392]],
[[35,42,-29],[42,53,-51],[29,42,-35,],0xFF0000,[390,391,392],[390,391,402,403],[391,392,393,420,421,422]],
[[35,42,-29],[29,42,-35],[25,25,-21,],0xFF0000,[390,391,392],[391,392,393,420,421,422],[363,364,365,392,393,394]],
[[29,42,-35],[21,25,-25],[25,25,-21,],0xFF0000,[391,392,393,420,421,422],[393,394,395,422,423,424],[363,364,365,392,393,394]],
[[25,25,-21],[21,25,-25],[21,4,-17,],0xFF0000,[363,364,365,392,393,394],[393,394,395,422,423,424],[394,395,396]],
[[21,25,-25],[17,4,-21],[21,4,-17,],0xFF0000,[393,394,395,422,423,424],[395,396,397,424,425,426],[394,395,396]],
[[21,4,-17],[17,4,-21],[25,-17,-21,],0xFF0000,[394,395,396],[395,396,397,424,425,426],[367,368,369,396,397,398]],
[[17,4,-21],[21,-17,-25],[25,-17,-21,],0xFF0000,[395,396,397,424,425,426],[397,398,399,426,427,428],[367,368,369,396,397,398]],
[[25,-17,-21],[21,-17,-25],[35,-34,-29,],0xFF0000,[367,368,369,396,397,398],[397,398,399,426,427,428],[369,370,371,398,399,400]],
[[21,-17,-25],[29,-34,-35],[35,-34,-29,],0xFF0000,[397,398,399,426,427,428],[399,400,401,428,429,430],[369,370,371,398,399,400]],
[[35,-34,-29],[29,-34,-35],[51,-45,-42,],0xFF0000,[369,370,371,398,399,400],[399,400,401,428,429,430],[400,401,406]],
[[29,-34,-35],[42,-45,-51],[51,-45,-42,],0xFF0000,[399,400,401,428,429,430],[401,406,407,430,431,436],[400,401,406]],
[[51,53,-42],[68,55,-57],[42,53,-51,],0xFF0000,[360,361,372,373,390,402],[402,403,404,405],[390,391,402,403]],
[[68,55,-57],[57,55,-68],[42,53,-51,],0xFF0000,[402,403,404,405],[403,404],[390,391,402,403]],
[[68,55,-57],[71,49,-85],[57,55,-68,],0xFF0000,[402,403,404,405],[404,405,410],[403,404]],
[[71,49,-85],[68,55,-57],[85,49,-71,],0xFF0000,[404,405,410],[402,403,404,405],[405,410,411]],
[[51,-45,-42],[42,-45,-51],[68,-47,-57,],0xFF0000,[400,401,406],[401,406,407,430,431,436],[377,378,406,407,408,409]],
[[68,-47,-57],[42,-45,-51],[57,-47,-68,],0xFF0000,[377,378,406,407,408,409],[401,406,407,430,431,436],[407,408,436,437,438,439]],
[[57,-47,-68],[71,-41,-85],[68,-47,-57,],0xFF0000,[407,408,436,437,438,439],[408,409,418,419,439,449],[377,378,406,407,408,409]],
[[68,-47,-57],[71,-41,-85],[85,-41,-71,],0xFF0000,[377,378,406,407,408,409],[408,409,418,419,439,449],[409,419]],
[[71,49,-85],[85,49,-71],[83,34,-99,],0xFF0000,[404,405,410],[405,410,411],[410,411,412]],
[[85,49,-71],[99,34,-83],[83,34,-99,],0xFF0000,[405,410,411],[411,412,413],[410,411,412]],
[[83,34,-99],[99,34,-83],[89,14,-106,],0xFF0000,[410,411,412],[411,412,413],[412,413,414]],
[[99,34,-83],[106,14,-89],[89,14,-106,],0xFF0000,[411,412,413],[413,414,415],[412,413,414]],
[[89,14,-106],[106,14,-89],[89,-6,-106,],0xFF0000,[412,413,414],[413,414,415],[414,415,416]],
[[106,14,-89],[106,-6,-89],[89,-6,-106,],0xFF0000,[413,414,415],[415,416,417],[414,415,416]],
[[89,-6,-106],[106,-6,-89],[83,-26,-99,],0xFF0000,[414,415,416],[415,416,417],[416,417,418]],
[[106,-6,-89],[99,-26,-83],[83,-26,-99,],0xFF0000,[415,416,417],[386,387,388,417,418,419],[416,417,418]],
[[83,-26,-99],[99,-26,-83],[71,-41,-85,],0xFF0000,[416,417,418],[386,387,388,417,418,419],[408,409,418,419,439,449]],
[[99,-26,-83],[85,-41,-71],[71,-41,-85,],0xFF0000,[386,387,388,417,418,419],[409,419],[408,409,418,419,439,449]],
[[42,53,-51],[33,53,-57],[29,42,-35,],0xFF0000,[420,432],[420,421,432,433],[391,392,393,420,421,422]],
[[29,42,-35],[33,53,-57],[23,42,-40,],0xFF0000,[391,392,393,420,421,422],[420,421,432,433],[421,422,423]],
[[29,42,-35],[23,42,-40],[21,25,-25,],0xFF0000,[391,392,393,420,421,422],[421,422,423],[393,394,395,422,423,424]],
[[23,42,-40],[16,25,-28],[21,25,-25,],0xFF0000,[421,422,423],[423,424,425],[393,394,395,422,423,424]],
[[21,25,-25],[16,25,-28],[17,4,-21,],0xFF0000,[393,394,395,422,423,424],[423,424,425],[395,396,397,424,425,426]],
[[16,25,-28],[13,4,-24],[17,4,-21,],0xFF0000,[423,424,425],[425,426,427],[395,396,397,424,425,426]],
[[17,4,-21],[13,4,-24],[21,-17,-25,],0xFF0000,[395,396,397,424,425,426],[425,426,427],[397,398,399,426,427,428]],
[[13,4,-24],[16,-17,-28],[21,-17,-25,],0xFF0000,[425,426,427],[427,428,429],[397,398,399,426,427,428]],
[[21,-17,-25],[16,-17,-28],[29,-34,-35,],0xFF0000,[397,398,399,426,427,428],[427,428,429],[399,400,401,428,429,430]],
[[16,-17,-28],[23,-34,-40],[29,-34,-35,],0xFF0000,[427,428,429],[429,430,431],[399,400,401,428,429,430]],
[[29,-34,-35],[23,-34,-40],[42,-45,-51,],0xFF0000,[399,400,401,428,429,430],[429,430,431],[401,406,407,430,431,436]],
[[23,-34,-40],[33,-45,-57],[42,-45,-51,],0xFF0000,[429,430,431],[431,436,437],[401,406,407,430,431,436]],
[[42,53,-51],[57,55,-68],[33,53,-57,],0xFF0000,[420,432],[432,433,434,435],[420,421,432,433]],
[[57,55,-68],[44,55,-77],[33,53,-57,],0xFF0000,[432,433,434,435],[433,434],[420,421,432,433]],
[[57,55,-68],[56,49,-96],[44,55,-77,],0xFF0000,[432,433,434,435],[434,435,440],[433,434]],
[[56,49,-96],[57,55,-68],[71,49,-85,],0xFF0000,[434,435,440],[432,433,434,435],[435,440,441]],
[[42,-45,-51],[33,-45,-57],[57,-47,-68,],0xFF0000,[401,406,407,430,431,436],[431,436,437],[407,408,436,437,438,439]],
[[57,-47,-68],[33,-45,-57],[44,-47,-77,],0xFF0000,[407,408,436,437,438,439],[431,436,437],[437,438]],
[[44,-47,-77],[55,-41,-96],[57,-47,-68,],0xFF0000,[437,438],[438,439,448,449],[407,408,436,437,438,439]],
[[57,-47,-68],[55,-41,-96],[71,-41,-85,],0xFF0000,[407,408,436,437,438,439],[438,439,448,449],[408,409,418,419,439,449]],
[[56,49,-96],[71,49,-85],[64,34,-111,],0xFF0000,[434,435,440],[435,440,441],[440,441,442]],
[[71,49,-85],[83,34,-99],[64,34,-111,],0xFF0000,[435,440,441],[441,442,443],[440,441,442]],
[[64,34,-111],[83,34,-99],[69,14,-120,],0xFF0000,[440,441,442],[441,442,443],[442,443,444]],
[[83,34,-99],[89,14,-106],[69,14,-120,],0xFF0000,[441,442,443],[443,444,445],[442,443,444]],
[[69,14,-120],[89,14,-106],[69,-6,-120,],0xFF0000,[442,443,444],[443,444,445],[444,445,446]],
[[89,14,-106],[89,-6,-106],[69,-6,-120,],0xFF0000,[443,444,445],[445,446,447],[444,445,446]],
[[69,-6,-120],[89,-6,-106],[64,-26,-111,],0xFF0000,[444,445,446],[445,446,447],[446,447,448]],
[[89,-6,-106],[83,-26,-99],[64,-26,-111,],0xFF0000,[445,446,447],[447,448,449],[446,447,448]],
[[64,-26,-111],[83,-26,-99],[55,-41,-96,],0xFF0000,[446,447,448],[447,448,449],[438,439,448,449]],
[[83,-26,-99],[71,-41,-85],[55,-41,-96,],0xFF0000,[447,448,449],[408,409,418,419,439,449],[438,439,448,449]],
[[33,53,-57],[22,53,-62],[23,42,-40,],0xFF0000,[450,462],[450,451,462,463],[450,451,452]],
[[23,42,-40],[22,53,-62],[15,42,-43,],0xFF0000,[450,451,452],[450,451,462,463],[451,452,453,480,481,482]],
[[23,42,-40],[15,42,-43],[16,25,-28,],0xFF0000,[450,451,452],[451,452,453,480,481,482],[452,453,454]],
[[15,42,-43],[11,25,-30],[16,25,-28,],0xFF0000,[451,452,453,480,481,482],[453,454,455],[452,453,454]],
[[16,25,-28],[11,25,-30],[13,4,-24,],0xFF0000,[452,453,454],[453,454,455],[454,455,456]],
[[11,25,-30],[9,4,-26],[13,4,-24,],0xFF0000,[453,454,455],[455,456,457],[454,455,456]],
[[13,4,-24],[9,4,-26],[16,-17,-28,],0xFF0000,[454,455,456],[455,456,457],[456,457,458]],
[[9,4,-26],[11,-17,-30],[16,-17,-28,],0xFF0000,[455,456,457],[457,458,459],[456,457,458]],
[[16,-17,-28],[11,-17,-30],[23,-34,-40,],0xFF0000,[456,457,458],[457,458,459],[458,459,460]],
[[11,-17,-30],[15,-34,-43],[23,-34,-40,],0xFF0000,[457,458,459],[459,460,461],[458,459,460]],
[[23,-34,-40],[15,-34,-43],[33,-45,-57,],0xFF0000,[458,459,460],[459,460,461],[460,461,466]],
[[15,-34,-43],[22,-45,-62],[33,-45,-57,],0xFF0000,[459,460,461],[461,466,467],[460,461,466]],
[[33,53,-57],[44,55,-77],[22,53,-62,],0xFF0000,[450,462],[462,463,464,465],[450,451,462,463]],
[[44,55,-77],[30,55,-84],[22,53,-62,],0xFF0000,[462,463,464,465],[463,464],[450,451,462,463]],
[[44,55,-77],[38,49,-105],[30,55,-84,],0xFF0000,[462,463,464,465],[464,465,470],[463,464]],
[[38,49,-105],[44,55,-77],[56,49,-96,],0xFF0000,[464,465,470],[462,463,464,465],[465,470,471]],
[[33,-45,-57],[22,-45,-62],[44,-47,-77,],0xFF0000,[460,461,466],[461,466,467],[466,467,468,469]],
[[44,-47,-77],[22,-45,-62],[30,-47,-84,],0xFF0000,[466,467,468,469],[461,466,467],[467,468]],
[[30,-47,-84],[38,-41,-105],[44,-47,-77,],0xFF0000,[467,468],[468,469,478,479],[466,467,468,469]],
[[44,-47,-77],[38,-41,-105],[55,-41,-96,],0xFF0000,[466,467,468,469],[468,469,478,479],[469,479]],
[[38,49,-105],[56,49,-96],[44,34,-121,],0xFF0000,[464,465,470],[465,470,471],[470,471,472]],
[[56,49,-96],[64,34,-111],[44,34,-121,],0xFF0000,[465,470,471],[471,472,473],[470,471,472]],
[[44,34,-121],[64,34,-111],[47,14,-130,],0xFF0000,[470,471,472],[471,472,473],[472,473,474]],
[[64,34,-111],[69,14,-120],[47,14,-130,],0xFF0000,[471,472,473],[473,474,475],[472,473,474]],
[[47,14,-130],[69,14,-120],[47,-6,-130,],0xFF0000,[472,473,474],[473,474,475],[474,475,476]],
[[69,14,-120],[69,-6,-120],[47,-6,-130,],0xFF0000,[473,474,475],[475,476,477],[474,475,476]],
[[47,-6,-130],[69,-6,-120],[44,-26,-121,],0xFF0000,[474,475,476],[475,476,477],[476,477,478]],
[[69,-6,-120],[64,-26,-111],[44,-26,-121,],0xFF0000,[475,476,477],[477,478,479],[476,477,478]],
[[44,-26,-121],[64,-26,-111],[38,-41,-105,],0xFF0000,[476,477,478],[477,478,479],[468,469,478,479]],
[[64,-26,-111],[55,-41,-96],[38,-41,-105,],0xFF0000,[477,478,479],[469,479],[468,469,478,479]],
[[22,53,-62],[11,53,-65],[15,42,-43,],0xFF0000,[480,492],[480,481,492,493],[451,452,453,480,481,482]],
[[15,42,-43],[11,53,-65],[8,42,-45,],0xFF0000,[451,452,453,480,481,482],[480,481,492,493],[481,482,483]],
[[15,42,-43],[8,42,-45],[11,25,-30,],0xFF0000,[451,452,453,480,481,482],[481,482,483],[482,483,484]],
[[8,42,-45],[5,25,-32],[11,25,-30,],0xFF0000,[481,482,483],[483,484,485],[482,483,484]],
[[11,25,-30],[5,25,-32],[9,4,-26,],0xFF0000,[482,483,484],[483,484,485],[484,485,486]],
[[5,25,-32],[4,4,-27],[9,4,-26,],0xFF0000,[483,484,485],[485,486,487],[484,485,486]],
[[9,4,-26],[4,4,-27],[11,-17,-30,],0xFF0000,[484,485,486],[485,486,487],[486,487,488]],
[[4,4,-27],[5,-17,-32],[11,-17,-30,],0xFF0000,[485,486,487],[487,488,489],[486,487,488]],
[[11,-17,-30],[5,-17,-32],[15,-34,-43,],0xFF0000,[486,487,488],[487,488,489],[488,489,490]],
[[5,-17,-32],[8,-34,-45],[15,-34,-43,],0xFF0000,[487,488,489],[489,490,491,518,519,520],[488,489,490]],
[[15,-34,-43],[8,-34,-45],[22,-45,-62,],0xFF0000,[488,489,490],[489,490,491,518,519,520],[490,491,496]],
[[8,-34,-45],[11,-45,-65],[22,-45,-62,],0xFF0000,[489,490,491,518,519,520],[491,496,497,520,521,526],[490,491,496]],
[[22,53,-62],[30,55,-84],[11,53,-65,],0xFF0000,[480,492],[492,493,494,495],[480,481,492,493]],
[[30,55,-84],[15,55,-88],[11,53,-65,],0xFF0000,[492,493,494,495],[493,494],[480,481,492,493]],
[[30,55,-84],[19,49,-110],[15,55,-88,],0xFF0000,[492,493,494,495],[494,495,500,525,530,531],[493,494]],
[[19,49,-110],[30,55,-84],[38,49,-105,],0xFF0000,[494,495,500,525,530,531],[492,493,494,495],[495,500,501]],
[[22,-45,-62],[11,-45,-65],[30,-47,-84,],0xFF0000,[490,491,496],[491,496,497,520,521,526],[496,497,498,499]],
[[30,-47,-84],[11,-45,-65],[15,-47,-88,],0xFF0000,[496,497,498,499],[491,496,497,520,521,526],[497,498]],
[[15,-47,-88],[19,-41,-110],[30,-47,-84,],0xFF0000,[497,498],[498,499,508,509],[496,497,498,499]],
[[30,-47,-84],[19,-41,-110],[38,-41,-105,],0xFF0000,[496,497,498,499],[498,499,508,509],[499,509]],
[[19,49,-110],[38,49,-105],[22,34,-127,],0xFF0000,[494,495,500,525,530,531],[495,500,501],[500,501,502,531,532,533]],
[[38,49,-105],[44,34,-121],[22,34,-127,],0xFF0000,[495,500,501],[501,502,503],[500,501,502,531,532,533]],
[[22,34,-127],[44,34,-121],[24,14,-136,],0xFF0000,[500,501,502,531,532,533],[501,502,503],[502,503,504]],
[[44,34,-121],[47,14,-130],[24,14,-136,],0xFF0000,[501,502,503],[503,504,505],[502,503,504]],
[[24,14,-136],[47,14,-130],[24,-6,-136,],0xFF0000,[502,503,504],[503,504,505],[504,505,506]],
[[47,14,-130],[47,-6,-130],[24,-6,-136,],0xFF0000,[503,504,505],[505,506,507],[504,505,506]],
[[24,-6,-136],[47,-6,-130],[22,-26,-127,],0xFF0000,[504,505,506],[505,506,507],[506,507,508]],
[[47,-6,-130],[44,-26,-121],[22,-26,-127,],0xFF0000,[505,506,507],[507,508,509],[506,507,508]],
[[22,-26,-127],[44,-26,-121],[19,-41,-110,],0xFF0000,[506,507,508],[507,508,509],[498,499,508,509]],
[[44,-26,-121],[38,-41,-105],[19,-41,-110,],0xFF0000,[507,508,509],[499,509],[498,499,508,509]],
[[11,53,-65],[0,53,-66],[8,42,-45,],0xFF0000,[510,522],[510,511,522,523],[510,511,512]],
[[8,42,-45],[0,53,-66],[0,42,-46,],0xFF0000,[510,511,512],[510,511,522,523],[511,512,513]],
[[8,42,-45],[0,42,-46],[5,25,-32,],0xFF0000,[510,511,512],[511,512,513],[512,513,514]],
[[0,42,-46],[0,25,-32],[5,25,-32,],0xFF0000,[511,512,513],[513,514,515],[512,513,514]],
[[5,25,-32],[0,25,-32],[4,4,-27,],0xFF0000,[512,513,514],[513,514,515],[514,515,516]],
[[0,25,-32],[0,4,-27],[4,4,-27,],0xFF0000,[513,514,515],[515,516,517],[514,515,516]],
[[4,4,-27],[0,4,-27],[5,-17,-32,],0xFF0000,[514,515,516],[515,516,517],[516,517,518]],
[[0,4,-27],[0,-17,-32],[5,-17,-32,],0xFF0000,[515,516,517],[517,518,519],[516,517,518]],
[[5,-17,-32],[0,-17,-32],[8,-34,-45,],0xFF0000,[516,517,518],[517,518,519],[489,490,491,518,519,520]],
[[0,-17,-32],[0,-34,-46],[8,-34,-45,],0xFF0000,[517,518,519],[519,520,521],[489,490,491,518,519,520]],
[[8,-34,-45],[0,-34,-46],[11,-45,-65,],0xFF0000,[489,490,491,518,519,520],[519,520,521],[491,496,497,520,521,526]],
[[0,-34,-46],[0,-45,-66],[11,-45,-65,],0xFF0000,[519,520,521],[521,526,527],[491,496,497,520,521,526]],
[[11,53,-65],[15,55,-88],[0,53,-66,],0xFF0000,[510,522],[522,523,524,525],[510,511,522,523]],
[[15,55,-88],[0,55,-89],[0,53,-66,],0xFF0000,[522,523,524,525],[523,524,1080,1081,1094,1095],[510,511,522,523]],
[[15,55,-88],[0,49,-112],[0,55,-89,],0xFF0000,[522,523,524,525],[524,525,530],[523,524,1080,1081,1094,1095]],
[[0,49,-112],[15,55,-88],[19,49,-110,],0xFF0000,[524,525,530],[522,523,524,525],[494,495,500,525,530,531]],
[[11,-45,-65],[0,-45,-66],[15,-47,-88,],0xFF0000,[491,496,497,520,521,526],[521,526,527],[526,527,528,529]],
[[15,-47,-88],[0,-45,-66],[0,-47,-89,],0xFF0000,[526,527,528,529],[521,526,527],[527,528]],
[[0,-47,-89],[0,-41,-111],[15,-47,-88,],0xFF0000,[527,528],[528,529,538,539],[526,527,528,529]],
[[15,-47,-88],[0,-41,-111],[19,-41,-110,],0xFF0000,[526,527,528,529],[528,529,538,539],[529,539]],
[[0,49,-112],[19,49,-110],[0,34,-129,],0xFF0000,[524,525,530],[494,495,500,525,530,531],[530,531,532]],
[[19,49,-110],[22,34,-127],[0,34,-129,],0xFF0000,[494,495,500,525,530,531],[500,501,502,531,532,533],[530,531,532]],
[[0,34,-129],[22,34,-127],[0,14,-138,],0xFF0000,[530,531,532],[500,501,502,531,532,533],[532,533,534]],
[[22,34,-127],[24,14,-136],[0,14,-138,],0xFF0000,[500,501,502,531,532,533],[533,534,535],[532,533,534]],
[[0,14,-138],[24,14,-136],[0,-6,-138,],0xFF0000,[532,533,534],[533,534,535],[534,535,536]],
[[24,14,-136],[24,-6,-136],[0,-6,-138,],0xFF0000,[533,534,535],[535,536,537],[534,535,536]],
[[0,-6,-138],[24,-6,-136],[0,-26,-129,],0xFF0000,[534,535,536],[535,536,537],[536,537,538,567,568,569,1103,1104,1105]],
[[24,-6,-136],[22,-26,-127],[0,-26,-129,],0xFF0000,[535,536,537],[537,538,539],[536,537,538,567,568,569,1103,1104,1105]],
[[0,-26,-129],[22,-26,-127],[0,-41,-111,],0xFF0000,[536,537,538,567,568,569,1103,1104,1105],[537,538,539],[528,529,538,539]],
[[22,-26,-127],[19,-41,-110],[0,-41,-111,],0xFF0000,[537,538,539],[529,539],[528,529,538,539]],
[[0,53,-66],[0,42,-46],[-11,53,-65,],0xFF0000,[540,552,1081,1082],[540,541,542],[540,541,552,553]],
[[0,42,-46],[-8,42,-45],[-11,53,-65,],0xFF0000,[540,541,542],[541,542,543,1083,1084,1085],[540,541,552,553]],
[[0,42,-46],[0,25,-32],[-8,42,-45,],0xFF0000,[540,541,542],[542,543,544,1084,1085,1086],[541,542,543,1083,1084,1085]],
[[-8,42,-45],[0,25,-32],[-5,25,-32,],0xFF0000,[541,542,543,1083,1084,1085],[542,543,544,1084,1085,1086],[543,544,545]],
[[0,25,-32],[0,4,-27],[-5,25,-32,],0xFF0000,[542,543,544,1084,1085,1086],[544,545,546],[543,544,545]],
[[-5,25,-32],[0,4,-27],[-4,4,-27,],0xFF0000,[543,544,545],[544,545,546],[545,546,547]],
[[0,4,-27],[0,-17,-32],[-4,4,-27,],0xFF0000,[544,545,546],[546,547,548,1088,1089,1090],[545,546,547]],
[[-4,4,-27],[0,-17,-32],[-5,-17,-32,],0xFF0000,[545,546,547],[546,547,548,1088,1089,1090],[547,548,549]],
[[0,-17,-32],[0,-34,-46],[-5,-17,-32,],0xFF0000,[546,547,548,1088,1089,1090],[548,549,550,1090,1091,1092],[547,548,549]],
[[-5,-17,-32],[0,-34,-46],[-8,-34,-45,],0xFF0000,[547,548,549],[548,549,550,1090,1091,1092],[549,550,551,1091,1092,1093]],
[[0,-34,-46],[0,-45,-66],[-8,-34,-45,],0xFF0000,[548,549,550,1090,1091,1092],[550,551,556],[549,550,551,1091,1092,1093]],
[[-8,-34,-45],[0,-45,-66],[-11,-45,-65,],0xFF0000,[549,550,551,1091,1092,1093],[550,551,556],[551,556,557]],
[[0,53,-66],[0,55,-89],[-11,53,-65,],0xFF0000,[540,552,1081,1082],[552,553,554,555],[540,541,552,553]],
[[0,55,-89],[-15,55,-88],[-11,53,-65,],0xFF0000,[552,553,554,555],[553,554],[540,541,552,553]],
[[0,55,-89],[-19,49,-110],[-15,55,-88,],0xFF0000,[552,553,554,555],[554,555,560],[553,554]],
[[-19,49,-110],[0,55,-89],[0,49,-112,],0xFF0000,[554,555,560],[552,553,554,555],[555,560,561,1095,1096,1097]],
[[0,-45,-66],[-11,-45,-65],[0,-47,-89,],0xFF0000,[550,551,556],[551,556,557],[556,557,558,559,1107,1108,1109]],
[[0,-47,-89],[-11,-45,-65],[-15,-47,-88,],0xFF0000,[556,557,558,559,1107,1108,1109],[551,556,557],[557,558]],
[[-15,-47,-88],[-19,-41,-110],[0,-47,-89,],0xFF0000,[557,558],[558,559,568,569],[556,557,558,559,1107,1108,1109]],
[[0,-47,-89],[-19,-41,-110],[0,-41,-111,],0xFF0000,[556,557,558,559,1107,1108,1109],[558,559,568,569],[559,569]],
[[-19,49,-110],[-22,34,-127],[0,49,-112,],0xFF0000,[554,555,560],[560,561,562],[555,560,561,1095,1096,1097]],
[[0,49,-112],[-22,34,-127],[0,34,-129,],0xFF0000,[555,560,561,1095,1096,1097],[560,561,562],[561,562,563]],
[[-22,34,-127],[-24,14,-136],[0,34,-129,],0xFF0000,[560,561,562],[562,563,564],[561,562,563]],
[[0,34,-129],[-24,14,-136],[0,14,-138,],0xFF0000,[561,562,563],[562,563,564],[563,564,565]],
[[-24,14,-136],[-24,-6,-136],[0,14,-138,],0xFF0000,[562,563,564],[564,565,566],[563,564,565]],
[[0,14,-138],[-24,-6,-136],[0,-6,-138,],0xFF0000,[563,564,565],[564,565,566],[565,566,567]],
[[-24,-6,-136],[-22,-26,-127],[0,-6,-138,],0xFF0000,[564,565,566],[566,567,568],[565,566,567]],
[[0,-6,-138],[-22,-26,-127],[0,-26,-129,],0xFF0000,[565,566,567],[566,567,568],[536,537,538,567,568,569,1103,1104,1105]],
[[-22,-26,-127],[-19,-41,-110],[0,-26,-129,],0xFF0000,[566,567,568],[558,559,568,569],[536,537,538,567,568,569,1103,1104,1105]],
[[0,-26,-129],[-19,-41,-110],[0,-41,-111,],0xFF0000,[536,537,538,567,568,569,1103,1104,1105],[558,559,568,569],[559,569]],
[[-65,53,11],[-62,53,22],[-45,42,8,],0xFF0000,[570,583],[570,571,582,583,614,629],[570,571,572,813,814,815]],
[[-45,42,8],[-62,53,22],[-43,42,15,],0xFF0000,[570,571,572,813,814,815],[570,571,582,583,614,629],[571,572,573,614,615,616]],
[[-45,42,8],[-43,42,15],[-32,25,5,],0xFF0000,[570,571,572,813,814,815],[571,572,573,614,615,616],[572,573,574]],
[[-43,42,15],[-30,25,11],[-32,25,5,],0xFF0000,[571,572,573,614,615,616],[573,574,575,616,617,618],[572,573,574]],
[[-32,25,5],[-30,25,11],[-27,4,4,],0xFF0000,[572,573,574],[573,574,575,616,617,618],[574,575,576]],
[[-30,25,11],[-26,4,9],[-27,4,4,],0xFF0000,[573,574,575,616,617,618],[575,576,577,618,619,620],[574,575,576]],
[[-27,4,4],[-26,4,9],[-32,-17,5,],0xFF0000,[574,575,576],[575,576,577,618,619,620],[576,577,578]],
[[-26,4,9],[-30,-17,11],[-32,-17,5,],0xFF0000,[575,576,577,618,619,620],[577,578,579,620,621,622],[576,577,578]],
[[-32,-17,5],[-30,-17,11],[-45,-34,8,],0xFF0000,[576,577,578],[577,578,579,620,621,622],[578,579,580]],
[[-30,-17,11],[-43,-34,15],[-45,-34,8,],0xFF0000,[577,578,579,620,621,622],[579,580,581,622,623,624],[578,579,580]],
[[-45,-34,8],[-43,-34,15],[-65,-45,11,],0xFF0000,[578,579,580],[579,580,581,622,623,624],[580,581,585]],
[[-43,-34,15],[-62,-45,22],[-65,-45,11,],0xFF0000,[579,580,581,622,623,624],[581,584,585,624,625,627],[580,581,585]],
[[-84,55,30],[-62,53,22],[-88,55,15,],0xFF0000,[582,586,600,601,628,629],[570,571,582,583,614,629],[582,583,586,587]],
[[-62,53,22],[-65,53,11],[-88,55,15,],0xFF0000,[570,571,582,583,614,629],[570,583],[582,583,586,587]],
[[-84,-47,30],[-88,-47,15],[-62,-45,22,],0xFF0000,[584,598,599,613,626,627],[584,585,599],[581,584,585,624,625,627]],
[[-62,-45,22],[-88,-47,15],[-65,-45,11,],0xFF0000,[581,584,585,624,625,627],[584,585,599],[580,581,585]],
[[-84,55,30],[-88,55,15],[-105,49,38,],0xFF0000,[582,586,600,601,628,629],[582,583,586,587],[586,587,588,601,602,603]],
[[-105,49,38],[-88,55,15],[-110,49,19,],0xFF0000,[586,587,588,601,602,603],[582,583,586,587],[587,588,589]],
[[-105,49,38],[-110,49,19],[-121,34,44,],0xFF0000,[586,587,588,601,602,603],[587,588,589],[588,589,590,603,604,605]],
[[-110,49,19],[-127,34,22],[-121,34,44,],0xFF0000,[587,588,589],[589,590,591],[588,589,590,603,604,605]],
[[-121,34,44],[-127,34,22],[-130,14,47,],0xFF0000,[588,589,590,603,604,605],[589,590,591],[590,591,592,605,606,607]],
[[-127,34,22],[-136,14,24],[-130,14,47,],0xFF0000,[589,590,591],[591,592,593],[590,591,592,605,606,607]],
[[-130,14,47],[-136,14,24],[-130,-6,47,],0xFF0000,[590,591,592,605,606,607],[591,592,593],[592,593,594,607,608,609]],
[[-136,14,24],[-136,-6,24],[-130,-6,47,],0xFF0000,[591,592,593],[593,594,595],[592,593,594,607,608,609]],
[[-130,-6,47],[-136,-6,24],[-121,-26,44,],0xFF0000,[592,593,594,607,608,609],[593,594,595],[594,595,596,609,610,611]],
[[-136,-6,24],[-127,-26,22],[-121,-26,44,],0xFF0000,[593,594,595],[595,596,597],[594,595,596,609,610,611]],
[[-121,-26,44],[-127,-26,22],[-105,-41,38,],0xFF0000,[594,595,596,609,610,611],[595,596,597],[596,597,598,611,612,613]],
[[-127,-26,22],[-110,-41,19],[-105,-41,38,],0xFF0000,[595,596,597],[597,598,599],[596,597,598,611,612,613]],
[[-105,-41,38],[-110,-41,19],[-84,-47,30,],0xFF0000,[596,597,598,611,612,613],[597,598,599],[584,598,599,613,626,627]],
[[-110,-41,19],[-88,-47,15],[-84,-47,30,],0xFF0000,[597,598,599],[584,585,599],[584,598,599,613,626,627]],
[[-77,55,44],[-84,55,30],[-96,49,56,],0xFF0000,[600,628],[582,586,600,601,628,629],[600,601,602]],
[[-96,49,56],[-84,55,30],[-105,49,38,],0xFF0000,[600,601,602],[582,586,600,601,628,629],[586,587,588,601,602,603]],
[[-96,49,56],[-105,49,38],[-111,34,64,],0xFF0000,[600,601,602],[586,587,588,601,602,603],[602,603,604]],
[[-105,49,38],[-121,34,44],[-111,34,64,],0xFF0000,[586,587,588,601,602,603],[588,589,590,603,604,605],[602,603,604]],
[[-111,34,64],[-121,34,44],[-120,14,69,],0xFF0000,[602,603,604],[588,589,590,603,604,605],[604,605,606]],
[[-121,34,44],[-130,14,47],[-120,14,69,],0xFF0000,[588,589,590,603,604,605],[590,591,592,605,606,607],[604,605,606]],
[[-120,14,69],[-130,14,47],[-120,-6,69,],0xFF0000,[604,605,606],[590,591,592,605,606,607],[606,607,608]],
[[-130,14,47],[-130,-6,47],[-120,-6,69,],0xFF0000,[590,591,592,605,606,607],[592,593,594,607,608,609],[606,607,608]],
[[-120,-6,69],[-130,-6,47],[-111,-26,64,],0xFF0000,[606,607,608],[592,593,594,607,608,609],[608,609,610]],
[[-130,-6,47],[-121,-26,44],[-111,-26,64,],0xFF0000,[592,593,594,607,608,609],[594,595,596,609,610,611],[608,609,610]],
[[-111,-26,64],[-121,-26,44],[-96,-41,55,],0xFF0000,[608,609,610],[594,595,596,609,610,611],[610,611,612]],
[[-121,-26,44],[-105,-41,38],[-96,-41,55,],0xFF0000,[594,595,596,609,610,611],[596,597,598,611,612,613],[610,611,612]],
[[-96,-41,55],[-105,-41,38],[-77,-47,44,],0xFF0000,[610,611,612],[596,597,598,611,612,613],[612,613,626]],
[[-105,-41,38],[-84,-47,30],[-77,-47,44,],0xFF0000,[596,597,598,611,612,613],[584,598,599,613,626,627],[612,613,626]],
[[-62,53,22],[-57,53,33],[-43,42,15,],0xFF0000,[570,571,582,583,614,629],[614,615,628,629],[571,572,573,614,615,616]],
[[-43,42,15],[-57,53,33],[-40,42,23,],0xFF0000,[571,572,573,614,615,616],[614,615,628,629],[615,616,617]],
[[-43,42,15],[-40,42,23],[-30,25,11,],0xFF0000,[571,572,573,614,615,616],[615,616,617],[573,574,575,616,617,618]],
[[-40,42,23],[-28,25,16],[-30,25,11,],0xFF0000,[615,616,617],[617,618,619],[573,574,575,616,617,618]],
[[-30,25,11],[-28,25,16],[-26,4,9,],0xFF0000,[573,574,575,616,617,618],[617,618,619],[575,576,577,618,619,620]],
[[-28,25,16],[-24,4,13],[-26,4,9,],0xFF0000,[617,618,619],[619,620,621],[575,576,577,618,619,620]],
[[-26,4,9],[-24,4,13],[-30,-17,11,],0xFF0000,[575,576,577,618,619,620],[619,620,621],[577,578,579,620,621,622]],
[[-24,4,13],[-28,-17,16],[-30,-17,11,],0xFF0000,[619,620,621],[621,622,623],[577,578,579,620,621,622]],
[[-30,-17,11],[-28,-17,16],[-43,-34,15,],0xFF0000,[577,578,579,620,621,622],[621,622,623],[579,580,581,622,623,624]],
[[-28,-17,16],[-40,-34,23],[-43,-34,15,],0xFF0000,[621,622,623],[623,624,625],[579,580,581,622,623,624]],
[[-43,-34,15],[-40,-34,23],[-62,-45,22,],0xFF0000,[579,580,581,622,623,624],[623,624,625],[581,584,585,624,625,627]],
[[-40,-34,23],[-57,-45,33],[-62,-45,22,],0xFF0000,[623,624,625],[625,626,627],[581,584,585,624,625,627]],
[[-77,-47,44],[-84,-47,30],[-57,-45,33,],0xFF0000,[612,613,626],[584,598,599,613,626,627],[625,626,627]],
[[-57,-45,33],[-84,-47,30],[-62,-45,22,],0xFF0000,[625,626,627],[584,598,599,613,626,627],[581,584,585,624,625,627]],
[[-77,55,44],[-57,53,33],[-84,55,30,],0xFF0000,[600,628],[614,615,628,629],[582,586,600,601,628,629]],
[[-57,53,33],[-62,53,22],[-84,55,30,],0xFF0000,[614,615,628,629],[570,571,582,583,614,629],[582,586,600,601,628,629]],
[[-68,55,57],[-77,55,44],[-85,49,71,],0xFF0000,[630,658,660,661,688,689],[630,631,658,659],[630,631,632]],
[[-85,49,71],[-77,55,44],[-96,49,56,],0xFF0000,[630,631,632],[630,631,658,659],[631,632,633]],
[[-85,49,71],[-96,49,56],[-99,34,83,],0xFF0000,[630,631,632],[631,632,633],[632,633,634]],
[[-96,49,56],[-111,34,64],[-99,34,83,],0xFF0000,[631,632,633],[633,634,635],[632,633,634]],
[[-99,34,83],[-111,34,64],[-106,14,89,],0xFF0000,[632,633,634],[633,634,635],[634,635,636]],
[[-111,34,64],[-120,14,69],[-106,14,89,],0xFF0000,[633,634,635],[635,636,637],[634,635,636]],
[[-106,14,89],[-120,14,69],[-106,-6,89,],0xFF0000,[634,635,636],[635,636,637],[636,637,638]],
[[-120,14,69],[-120,-6,69],[-106,-6,89,],0xFF0000,[635,636,637],[637,638,639],[636,637,638]],
[[-106,-6,89],[-120,-6,69],[-99,-26,83,],0xFF0000,[636,637,638],[637,638,639],[638,639,640]],
[[-120,-6,69],[-111,-26,64],[-99,-26,83,],0xFF0000,[637,638,639],[639,640,641],[638,639,640]],
[[-99,-26,83],[-111,-26,64],[-85,-41,71,],0xFF0000,[638,639,640],[639,640,641],[640,641,642]],
[[-111,-26,64],[-96,-41,55],[-85,-41,71,],0xFF0000,[639,640,641],[641,642,643],[640,641,642]],
[[-85,-41,71],[-96,-41,55],[-68,-47,57,],0xFF0000,[640,641,642],[641,642,643],[642,643,656]],
[[-96,-41,55],[-77,-47,44],[-68,-47,57,],0xFF0000,[641,642,643],[643,656,657],[642,643,656]],
[[-57,53,33],[-51,53,42],[-40,42,23,],0xFF0000,[644,659],[644,645,658,659],[644,645,646]],
[[-40,42,23],[-51,53,42],[-35,42,29,],0xFF0000,[644,645,646],[644,645,658,659],[645,646,647]],
[[-40,42,23],[-35,42,29],[-28,25,16,],0xFF0000,[644,645,646],[645,646,647],[646,647,648]],
[[-35,42,29],[-25,25,21],[-28,25,16,],0xFF0000,[645,646,647],[647,648,649],[646,647,648]],
[[-28,25,16],[-25,25,21],[-24,4,13,],0xFF0000,[646,647,648],[647,648,649],[648,649,650]],
[[-25,25,21],[-21,4,17],[-24,4,13,],0xFF0000,[647,648,649],[649,650,651],[648,649,650]],
[[-24,4,13],[-21,4,17],[-28,-17,16,],0xFF0000,[648,649,650],[649,650,651],[650,651,652]],
[[-21,4,17],[-25,-17,21],[-28,-17,16,],0xFF0000,[649,650,651],[651,652,653],[650,651,652]],
[[-28,-17,16],[-25,-17,21],[-40,-34,23,],0xFF0000,[650,651,652],[651,652,653],[652,653,654]],
[[-25,-17,21],[-35,-34,29],[-40,-34,23,],0xFF0000,[651,652,653],[653,654,655],[652,653,654]],
[[-40,-34,23],[-35,-34,29],[-57,-45,33,],0xFF0000,[652,653,654],[653,654,655],[654,655,657]],
[[-35,-34,29],[-51,-45,42],[-57,-45,33,],0xFF0000,[653,654,655],[655,656,657],[654,655,657]],
[[-68,-47,57],[-77,-47,44],[-51,-45,42,],0xFF0000,[642,643,656],[643,656,657],[655,656,657]],
[[-51,-45,42],[-77,-47,44],[-57,-45,33,],0xFF0000,[655,656,657],[643,656,657],[654,655,657]],
[[-68,55,57],[-51,53,42],[-77,55,44,],0xFF0000,[630,658,660,661,688,689],[644,645,658,659],[630,631,658,659]],
[[-51,53,42],[-57,53,33],[-77,55,44,],0xFF0000,[644,645,658,659],[644,659],[630,631,658,659]],
[[-57,55,68],[-68,55,57],[-71,49,85,],0xFF0000,[660,688],[630,658,660,661,688,689],[660,661,662,691,692,693]],
[[-71,49,85],[-68,55,57],[-85,49,71,],0xFF0000,[660,661,662,691,692,693],[630,658,660,661,688,689],[661,662,663]],
[[-71,49,85],[-85,49,71],[-83,34,99,],0xFF0000,[660,661,662,691,692,693],[661,662,663],[662,663,664,693,694,695]],
[[-85,49,71],[-99,34,83],[-83,34,99,],0xFF0000,[661,662,663],[663,664,665],[662,663,664,693,694,695]],
[[-83,34,99],[-99,34,83],[-89,14,106,],0xFF0000,[662,663,664,693,694,695],[663,664,665],[664,665,666,695,696,697]],
[[-99,34,83],[-106,14,89],[-89,14,106,],0xFF0000,[663,664,665],[665,666,667],[664,665,666,695,696,697]],
[[-89,14,106],[-106,14,89],[-89,-6,106,],0xFF0000,[664,665,666,695,696,697],[665,666,667],[666,667,668,697,698,699]],
[[-106,14,89],[-106,-6,89],[-89,-6,106,],0xFF0000,[665,666,667],[667,668,669],[666,667,668,697,698,699]],
[[-89,-6,106],[-106,-6,89],[-83,-26,99,],0xFF0000,[666,667,668,697,698,699],[667,668,669],[668,669,670]],
[[-106,-6,89],[-99,-26,83],[-83,-26,99,],0xFF0000,[667,668,669],[669,670,671],[668,669,670]],
[[-83,-26,99],[-99,-26,83],[-71,-41,85,],0xFF0000,[668,669,670],[669,670,671],[670,671,672,701,702,703]],
[[-99,-26,83],[-85,-41,71],[-71,-41,85,],0xFF0000,[669,670,671],[671,672,673],[670,671,672,701,702,703]],
[[-71,-41,85],[-85,-41,71],[-57,-47,68,],0xFF0000,[670,671,672,701,702,703],[671,672,673],[672,673,686,703,716,717]],
[[-85,-41,71],[-68,-47,57],[-57,-47,68,],0xFF0000,[671,672,673],[673,686,687],[672,673,686,703,716,717]],
[[-51,53,42],[-42,53,51],[-35,42,29,],0xFF0000,[674,689],[674,675,688,689],[674,675,676]],
[[-35,42,29],[-42,53,51],[-29,42,35,],0xFF0000,[674,675,676],[674,675,688,689],[675,676,677,704,705,706]],
[[-35,42,29],[-29,42,35],[-25,25,21,],0xFF0000,[674,675,676],[675,676,677,704,705,706],[676,677,678]],
[[-29,42,35],[-21,25,25],[-25,25,21,],0xFF0000,[675,676,677,704,705,706],[677,678,679,706,707,708],[676,677,678]],
[[-25,25,21],[-21,25,25],[-21,4,17,],0xFF0000,[676,677,678],[677,678,679,706,707,708],[678,679,680]],
[[-21,25,25],[-17,4,21],[-21,4,17,],0xFF0000,[677,678,679,706,707,708],[679,680,681,708,709,710],[678,679,680]],
[[-21,4,17],[-17,4,21],[-25,-17,21,],0xFF0000,[678,679,680],[679,680,681,708,709,710],[680,681,682]],
[[-17,4,21],[-21,-17,25],[-25,-17,21,],0xFF0000,[679,680,681,708,709,710],[681,682,683,710,711,712],[680,681,682]],
[[-25,-17,21],[-21,-17,25],[-35,-34,29,],0xFF0000,[680,681,682],[681,682,683,710,711,712],[682,683,684]],
[[-21,-17,25],[-29,-34,35],[-35,-34,29,],0xFF0000,[681,682,683,710,711,712],[683,684,685],[682,683,684]],
[[-35,-34,29],[-29,-34,35],[-51,-45,42,],0xFF0000,[682,683,684],[683,684,685],[684,685,687]],
[[-29,-34,35],[-42,-45,51],[-51,-45,42,],0xFF0000,[683,684,685],[685,686,687],[684,685,687]],
[[-57,-47,68],[-68,-47,57],[-42,-45,51,],0xFF0000,[672,673,686,703,716,717],[673,686,687],[685,686,687]],
[[-42,-45,51],[-68,-47,57],[-51,-45,42,],0xFF0000,[685,686,687],[673,686,687],[684,685,687]],
[[-57,55,68],[-42,53,51],[-68,55,57,],0xFF0000,[660,688],[674,675,688,689],[630,658,660,661,688,689]],
[[-42,53,51],[-51,53,42],[-68,55,57,],0xFF0000,[674,675,688,689],[674,689],[630,658,660,661,688,689]],
[[-44,55,77],[-57,55,68],[-56,49,96,],0xFF0000,[690,718],[690,691,718,719],[690,691,692]],
[[-56,49,96],[-57,55,68],[-71,49,85,],0xFF0000,[690,691,692],[690,691,718,719],[660,661,662,691,692,693]],
[[-56,49,96],[-71,49,85],[-64,34,111,],0xFF0000,[690,691,692],[660,661,662,691,692,693],[692,693,694]],
[[-71,49,85],[-83,34,99],[-64,34,111,],0xFF0000,[660,661,662,691,692,693],[662,663,664,693,694,695],[692,693,694]],
[[-64,34,111],[-83,34,99],[-69,14,120,],0xFF0000,[692,693,694],[662,663,664,693,694,695],[694,695,696]],
[[-83,34,99],[-89,14,106],[-69,14,120,],0xFF0000,[662,663,664,693,694,695],[664,665,666,695,696,697],[694,695,696]],
[[-69,14,120],[-89,14,106],[-69,-6,120,],0xFF0000,[694,695,696],[664,665,666,695,696,697],[696,697,698]],
[[-89,14,106],[-89,-6,106],[-69,-6,120,],0xFF0000,[664,665,666,695,696,697],[666,667,668,697,698,699],[696,697,698]],
[[-69,-6,120],[-89,-6,106],[-64,-26,111,],0xFF0000,[696,697,698],[666,667,668,697,698,699],[698,699,700]],
[[-89,-6,106],[-83,-26,99],[-64,-26,111,],0xFF0000,[666,667,668,697,698,699],[699,700,701],[698,699,700]],
[[-64,-26,111],[-83,-26,99],[-55,-41,96,],0xFF0000,[698,699,700],[699,700,701],[700,701,702]],
[[-83,-26,99],[-71,-41,85],[-55,-41,96,],0xFF0000,[699,700,701],[670,671,672,701,702,703],[700,701,702]],
[[-55,-41,96],[-71,-41,85],[-44,-47,77,],0xFF0000,[700,701,702],[670,671,672,701,702,703],[702,703,716]],
[[-71,-41,85],[-57,-47,68],[-44,-47,77,],0xFF0000,[670,671,672,701,702,703],[672,673,686,703,716,717],[702,703,716]],
[[-42,53,51],[-33,53,57],[-29,42,35,],0xFF0000,[704,719],[704,705,718,719],[675,676,677,704,705,706]],
[[-29,42,35],[-33,53,57],[-23,42,40,],0xFF0000,[675,676,677,704,705,706],[704,705,718,719],[705,706,707]],
[[-29,42,35],[-23,42,40],[-21,25,25,],0xFF0000,[675,676,677,704,705,706],[705,706,707],[677,678,679,706,707,708]],
[[-23,42,40],[-16,25,28],[-21,25,25,],0xFF0000,[705,706,707],[707,708,709],[677,678,679,706,707,708]],
[[-21,25,25],[-16,25,28],[-17,4,21,],0xFF0000,[677,678,679,706,707,708],[707,708,709],[679,680,681,708,709,710]],
[[-16,25,28],[-13,4,24],[-17,4,21,],0xFF0000,[707,708,709],[709,710,711],[679,680,681,708,709,710]],
[[-17,4,21],[-13,4,24],[-21,-17,25,],0xFF0000,[679,680,681,708,709,710],[709,710,711],[681,682,683,710,711,712]],
[[-13,4,24],[-16,-17,28],[-21,-17,25,],0xFF0000,[709,710,711],[711,712,713],[681,682,683,710,711,712]],
[[-21,-17,25],[-16,-17,28],[-29,-34,35,],0xFF0000,[681,682,683,710,711,712],[711,712,713],[712,713,714]],
[[-16,-17,28],[-23,-34,40],[-29,-34,35,],0xFF0000,[711,712,713],[713,714,715],[712,713,714]],
[[-29,-34,35],[-23,-34,40],[-42,-45,51,],0xFF0000,[712,713,714],[713,714,715],[714,715,717]],
[[-23,-34,40],[-33,-45,57],[-42,-45,51,],0xFF0000,[713,714,715],[715,716,717],[714,715,717]],
[[-44,-47,77],[-57,-47,68],[-33,-45,57,],0xFF0000,[702,703,716],[672,673,686,703,716,717],[715,716,717]],
[[-33,-45,57],[-57,-47,68],[-42,-45,51,],0xFF0000,[715,716,717],[672,673,686,703,716,717],[714,715,717]],
[[-44,55,77],[-33,53,57],[-57,55,68,],0xFF0000,[690,718],[704,705,718,719],[690,691,718,719]],
[[-33,53,57],[-42,53,51],[-57,55,68,],0xFF0000,[704,705,718,719],[704,719],[690,691,718,719]],
[[-30,55,84],[-44,55,77],[-38,49,105,],0xFF0000,[720,748],[720,721,748,749],[720,721,722]],
[[-38,49,105],[-44,55,77],[-56,49,96,],0xFF0000,[720,721,722],[720,721,748,749],[721,722,723]],
[[-38,49,105],[-56,49,96],[-44,34,121,],0xFF0000,[720,721,722],[721,722,723],[722,723,724]],
[[-56,49,96],[-64,34,111],[-44,34,121,],0xFF0000,[721,722,723],[723,724,725],[722,723,724]],
[[-44,34,121],[-64,34,111],[-47,14,130,],0xFF0000,[722,723,724],[723,724,725],[724,725,726]],
[[-64,34,111],[-69,14,120],[-47,14,130,],0xFF0000,[723,724,725],[725,726,727],[724,725,726]],
[[-47,14,130],[-69,14,120],[-47,-6,130,],0xFF0000,[724,725,726],[725,726,727],[726,727,728]],
[[-69,14,120],[-69,-6,120],[-47,-6,130,],0xFF0000,[725,726,727],[727,728,729],[726,727,728]],
[[-47,-6,130],[-69,-6,120],[-44,-26,121,],0xFF0000,[726,727,728],[727,728,729],[728,729,730]],
[[-69,-6,120],[-64,-26,111],[-44,-26,121,],0xFF0000,[727,728,729],[729,730,731],[728,729,730]],
[[-44,-26,121],[-64,-26,111],[-38,-41,105,],0xFF0000,[728,729,730],[729,730,731],[730,731,732]],
[[-64,-26,111],[-56,-41,96],[-38,-41,105,],0xFF0000,[729,730,731],[731,732,733],[730,731,732]],
[[-38,-41,105],[-56,-41,96],[-30,-47,84,],0xFF0000,[730,731,732],[731,732,733],[732,733,746]],
[[-56,-41,96],[-44,-47,77],[-30,-47,84,],0xFF0000,[731,732,733],[733,746,747],[732,733,746]],
[[-33,53,57],[-22,53,62],[-23,42,40,],0xFF0000,[734,749],[734,735,748,749],[734,735,736]],
[[-23,42,40],[-22,53,62],[-15,42,43,],0xFF0000,[734,735,736],[734,735,748,749],[735,736,737]],
[[-23,42,40],[-15,42,43],[-16,25,28,],0xFF0000,[734,735,736],[735,736,737],[736,737,738]],
[[-15,42,43],[-11,25,30],[-16,25,28,],0xFF0000,[735,736,737],[737,738,739],[736,737,738]],
[[-16,25,28],[-11,25,30],[-14,4,24,],0xFF0000,[736,737,738],[737,738,739],[738,739,740]],
[[-11,25,30],[-9,4,26],[-14,4,24,],0xFF0000,[737,738,739],[739,740,741],[738,739,740]],
[[-14,4,24],[-9,4,26],[-16,-17,28,],0xFF0000,[738,739,740],[739,740,741],[740,741,742]],
[[-9,4,26],[-11,-17,30],[-16,-17,28,],0xFF0000,[739,740,741],[741,742,743],[740,741,742]],
[[-16,-17,28],[-11,-17,30],[-23,-34,40,],0xFF0000,[740,741,742],[741,742,743],[742,743,744]],
[[-11,-17,30],[-15,-34,43],[-23,-34,40,],0xFF0000,[741,742,743],[743,744,745],[742,743,744]],
[[-23,-34,40],[-15,-34,43],[-33,-45,57,],0xFF0000,[742,743,744],[743,744,745],[744,745,747]],
[[-15,-34,43],[-22,-45,62],[-33,-45,57,],0xFF0000,[743,744,745],[745,746,747],[744,745,747]],
[[-30,-47,84],[-44,-47,77],[-22,-45,62,],0xFF0000,[732,733,746],[733,746,747],[745,746,747]],
[[-22,-45,62],[-44,-47,77],[-33,-45,57,],0xFF0000,[745,746,747],[733,746,747],[744,745,747]],
[[-30,55,84],[-22,53,62],[-44,55,77,],0xFF0000,[720,748],[734,735,748,749],[720,721,748,749]],
[[-22,53,62],[-33,53,57],[-44,55,77,],0xFF0000,[734,735,748,749],[734,749],[720,721,748,749]],
[[-15,55,88],[-30,55,84],[-19,49,110,],0xFF0000,[750,778],[750,751,778,779],[750,751,752]],
[[-19,49,110],[-30,55,84],[-38,49,105,],0xFF0000,[750,751,752],[750,751,778,779],[751,752,753]],
[[-19,49,110],[-38,49,105],[-22,34,127,],0xFF0000,[750,751,752],[751,752,753],[752,753,754]],
[[-38,49,105],[-44,34,121],[-22,34,127,],0xFF0000,[751,752,753],[753,754,755],[752,753,754]],
[[-22,34,127],[-44,34,121],[-24,14,136,],0xFF0000,[752,753,754],[753,754,755],[754,755,756]],
[[-44,34,121],[-47,14,130],[-24,14,136,],0xFF0000,[753,754,755],[755,756,757],[754,755,756]],
[[-24,14,136],[-47,14,130],[-24,-6,136,],0xFF0000,[754,755,756],[755,756,757],[756,757,758]],
[[-47,14,130],[-47,-6,130],[-24,-6,136,],0xFF0000,[755,756,757],[757,758,759],[756,757,758]],
[[-24,-6,136],[-47,-6,130],[-22,-26,127,],0xFF0000,[756,757,758],[757,758,759],[758,759,760,789,790,791]],
[[-47,-6,130],[-44,-26,121],[-22,-26,127,],0xFF0000,[757,758,759],[759,760,761],[758,759,760,789,790,791]],
[[-22,-26,127],[-44,-26,121],[-19,-41,110,],0xFF0000,[758,759,760,789,790,791],[759,760,761],[760,761,762]],
[[-44,-26,121],[-38,-41,105],[-19,-41,110,],0xFF0000,[759,760,761],[761,762,763],[760,761,762]],
[[-19,-41,110],[-38,-41,105],[-15,-47,88,],0xFF0000,[760,761,762],[761,762,763],[762,763,776]],
[[-38,-41,105],[-30,-47,84],[-15,-47,88,],0xFF0000,[761,762,763],[763,776,777],[762,763,776]],
[[-22,53,62],[-11,53,65],[-15,42,43,],0xFF0000,[764,779],[764,765,778,779],[764,765,766]],
[[-15,42,43],[-11,53,65],[-8,42,45,],0xFF0000,[764,765,766],[764,765,778,779],[765,766,767]],
[[-15,42,43],[-8,42,45],[-11,25,30,],0xFF0000,[764,765,766],[765,766,767],[766,767,768]],
[[-8,42,45],[-5,25,32],[-11,25,30,],0xFF0000,[765,766,767],[767,768,769],[766,767,768]],
[[-11,25,30],[-5,25,32],[-9,4,26,],0xFF0000,[766,767,768],[767,768,769],[768,769,770]],
[[-5,25,32],[-4,4,27],[-9,4,26,],0xFF0000,[767,768,769],[769,770,771],[768,769,770]],
[[-9,4,26],[-4,4,27],[-11,-17,30,],0xFF0000,[768,769,770],[769,770,771],[770,771,772]],
[[-4,4,27],[-5,-17,32],[-11,-17,30,],0xFF0000,[769,770,771],[771,772,773],[770,771,772]],
[[-11,-17,30],[-5,-17,32],[-15,-34,43,],0xFF0000,[770,771,772],[771,772,773],[772,773,774]],
[[-5,-17,32],[-8,-34,45],[-15,-34,43,],0xFF0000,[771,772,773],[773,774,775],[772,773,774]],
[[-15,-34,43],[-8,-34,45],[-22,-45,62,],0xFF0000,[772,773,774],[773,774,775],[774,775,777]],
[[-8,-34,45],[-11,-45,65],[-22,-45,62,],0xFF0000,[773,774,775],[775,776,777],[774,775,777]],
[[-15,-47,88],[-30,-47,84],[-11,-45,65,],0xFF0000,[762,763,776],[763,776,777],[775,776,777]],
[[-11,-45,65],[-30,-47,84],[-22,-45,62,],0xFF0000,[775,776,777],[763,776,777],[774,775,777]],
[[-15,55,88],[-11,53,65],[-30,55,84,],0xFF0000,[750,778],[764,765,778,779],[750,751,778,779]],
[[-11,53,65],[-22,53,62],[-30,55,84,],0xFF0000,[764,765,778,779],[764,779],[750,751,778,779]],
[[0,55,89],[-15,55,88],[0,49,112,],0xFF0000,[780,808],[780,781,808,809],[780,781,782]],
[[0,49,112],[-15,55,88],[-19,49,110,],0xFF0000,[780,781,782],[780,781,808,809],[781,782,783]],
[[0,49,112],[-19,49,110],[0,34,129,],0xFF0000,[780,781,782],[781,782,783],[782,783,784]],
[[-19,49,110],[-22,34,127],[0,34,129,],0xFF0000,[781,782,783],[783,784,785],[782,783,784]],
[[0,34,129],[-22,34,127],[0,14,138,],0xFF0000,[782,783,784],[783,784,785],[784,785,786]],
[[-22,34,127],[-24,14,136],[0,14,138,],0xFF0000,[783,784,785],[785,786,787],[784,785,786]],
[[0,14,138],[-24,14,136],[0,-6,138,],0xFF0000,[784,785,786],[785,786,787],[786,787,788]],
[[-24,14,136],[-24,-6,136],[0,-6,138,],0xFF0000,[785,786,787],[787,788,789],[786,787,788]],
[[0,-6,138],[-24,-6,136],[0,-26,129,],0xFF0000,[786,787,788],[787,788,789],[788,789,790]],
[[-24,-6,136],[-22,-26,127],[0,-26,129,],0xFF0000,[787,788,789],[758,759,760,789,790,791],[788,789,790]],
[[0,-26,129],[-22,-26,127],[0,-41,111,],0xFF0000,[788,789,790],[758,759,760,789,790,791],[790,791,792]],
[[-22,-26,127],[-19,-41,110],[0,-41,111,],0xFF0000,[758,759,760,789,790,791],[791,792,793],[790,791,792]],
[[0,-41,111],[-19,-41,110],[0,-47,89,],0xFF0000,[790,791,792],[791,792,793],[792,793,806]],
[[-19,-41,110],[-15,-47,88],[0,-47,89,],0xFF0000,[791,792,793],[793,806,807],[792,793,806]],
[[-11,53,65],[0,53,66],[-8,42,45,],0xFF0000,[794,809],[794,795,808,809],[794,795,796]],
[[-8,42,45],[0,53,66],[0,42,46,],0xFF0000,[794,795,796],[794,795,808,809],[795,796,797]],
[[-8,42,45],[0,42,46],[-5,25,32,],0xFF0000,[794,795,796],[795,796,797],[796,797,798]],
[[0,42,46],[0,25,32],[-5,25,32,],0xFF0000,[795,796,797],[797,798,799],[796,797,798]],
[[-5,25,32],[0,25,32],[-4,4,27,],0xFF0000,[796,797,798],[797,798,799],[798,799,800]],
[[0,25,32],[0,4,27],[-4,4,27,],0xFF0000,[797,798,799],[799,800,801],[798,799,800]],
[[-4,4,27],[0,4,27],[-5,-17,32,],0xFF0000,[798,799,800],[799,800,801],[800,801,802]],
[[0,4,27],[0,-17,32],[-5,-17,32,],0xFF0000,[799,800,801],[801,802,803],[800,801,802]],
[[-5,-17,32],[0,-17,32],[-8,-34,45,],0xFF0000,[800,801,802],[801,802,803],[802,803,804]],
[[0,-17,32],[0,-34,46],[-8,-34,45,],0xFF0000,[801,802,803],[803,804,805],[802,803,804]],
[[-8,-34,45],[0,-34,46],[-11,-45,65,],0xFF0000,[802,803,804],[803,804,805],[804,805,807]],
[[0,-34,46],[0,-45,66],[-11,-45,65,],0xFF0000,[803,804,805],[805,806,807],[804,805,807]],
[[0,-47,89],[-15,-47,88],[0,-45,66,],0xFF0000,[792,793,806],[793,806,807],[805,806,807]],
[[0,-45,66],[-15,-47,88],[-11,-45,65,],0xFF0000,[805,806,807],[793,806,807],[804,805,807]],
[[0,55,89],[0,53,66],[-15,55,88,],0xFF0000,[780,808],[794,795,808,809],[780,781,808,809]],
[[0,53,66],[-11,53,65],[-15,55,88,],0xFF0000,[794,795,808,809],[794,809],[780,781,808,809]],
[[-88,55,15],[-65,53,11],[-89,55,0,],0xFF0000,[810,824],[810,811,812,813],[810,811,824,825]],
[[-65,53,11],[-66,53,0],[-89,55,0,],0xFF0000,[810,811,812,813],[811,812],[810,811,824,825]],
[[-66,53,0],[-65,53,11],[-46,42,0,],0xFF0000,[811,812],[810,811,812,813],[812,813,814]],
[[-46,42,0],[-65,53,11],[-45,42,8,],0xFF0000,[812,813,814],[810,811,812,813],[570,571,572,813,814,815]],
[[-46,42,0],[-45,42,8],[-32,25,0,],0xFF0000,[812,813,814],[570,571,572,813,814,815],[814,815,816,845,846,847]],
[[-45,42,8],[-32,25,5],[-32,25,0,],0xFF0000,[570,571,572,813,814,815],[815,816,817],[814,815,816,845,846,847]],
[[-32,25,0],[-32,25,5],[-27,4,0,],0xFF0000,[814,815,816,845,846,847],[815,816,817],[816,817,818]],
[[-32,25,5],[-27,4,4],[-27,4,0,],0xFF0000,[815,816,817],[817,818,819],[816,817,818]],
[[-27,4,0],[-27,4,4],[-32,-17,0,],0xFF0000,[816,817,818],[817,818,819],[818,819,820,849,850,851]],
[[-27,4,4],[-32,-17,5],[-32,-17,0,],0xFF0000,[817,818,819],[819,820,821],[818,819,820,849,850,851]],
[[-32,-17,0],[-32,-17,5],[-46,-34,0,],0xFF0000,[818,819,820,849,850,851],[819,820,821],[820,821,822]],
[[-32,-17,5],[-45,-34,8],[-46,-34,0,],0xFF0000,[819,820,821],[821,822,823],[820,821,822]],
[[-46,-34,0],[-45,-34,8],[-66,-45,0,],0xFF0000,[820,821,822],[821,822,823],[822,823,839]],
[[-45,-34,8],[-65,-45,11],[-66,-45,0,],0xFF0000,[821,822,823],[823,838,839],[822,823,839]],
[[-88,55,15],[-89,55,0],[-110,49,19,],0xFF0000,[810,824],[810,811,824,825],[824,825,826]],
[[-110,49,19],[-89,55,0],[-112,49,0,],0xFF0000,[824,825,826],[810,811,824,825],[825,826,827]],
[[-110,49,19],[-112,49,0],[-127,34,22,],0xFF0000,[824,825,826],[825,826,827],[826,827,828]],
[[-112,49,0],[-129,34,0],[-127,34,22,],0xFF0000,[825,826,827],[827,828,829],[826,827,828]],
[[-127,34,22],[-129,34,0],[-136,14,24,],0xFF0000,[826,827,828],[827,828,829],[828,829,830]],
[[-129,34,0],[-138,14,0],[-136,14,24,],0xFF0000,[827,828,829],[829,830,831],[828,829,830]],
[[-136,14,24],[-138,14,0],[-136,-6,24,],0xFF0000,[828,829,830],[829,830,831],[830,831,832]],
[[-138,14,0],[-138,-6,0],[-136,-6,24,],0xFF0000,[829,830,831],[831,832,833],[830,831,832]],
[[-136,-6,24],[-138,-6,0],[-127,-26,22,],0xFF0000,[830,831,832],[831,832,833],[832,833,834]],
[[-138,-6,0],[-129,-26,0],[-127,-26,22,],0xFF0000,[831,832,833],[833,834,835],[832,833,834]],
[[-127,-26,22],[-129,-26,0],[-110,-41,19,],0xFF0000,[832,833,834],[833,834,835],[834,835,836]],
[[-129,-26,0],[-111,-41,0],[-110,-41,19,],0xFF0000,[833,834,835],[835,836,837],[834,835,836]],
[[-110,-41,19],[-111,-41,0],[-88,-47,15,],0xFF0000,[834,835,836],[835,836,837],[836,837,838]],
[[-111,-41,0],[-89,-47,0],[-88,-47,15,],0xFF0000,[835,836,837],[837,838,839],[836,837,838]],
[[-88,-47,15],[-89,-47,0],[-65,-45,11,],0xFF0000,[836,837,838],[837,838,839],[823,838,839]],
[[-65,-45,11],[-89,-47,0],[-66,-45,0,],0xFF0000,[823,838,839],[837,838,839],[822,823,839]],
[[-89,55,0],[-66,53,0],[-88,55,-15,],0xFF0000,[840,854],[840,841,842,843],[840,841,854,855]],
[[-66,53,0],[-65,53,-11],[-88,55,-15,],0xFF0000,[840,841,842,843],[841,842],[840,841,854,855]],
[[-65,53,-11],[-66,53,0],[-45,42,-8,],0xFF0000,[841,842],[840,841,842,843],[842,843,844]],
[[-45,42,-8],[-66,53,0],[-46,42,0,],0xFF0000,[842,843,844],[840,841,842,843],[843,844,845]],
[[-45,42,-8],[-46,42,0],[-32,25,-5,],0xFF0000,[842,843,844],[843,844,845],[844,845,846]],
[[-46,42,0],[-32,25,0],[-32,25,-5,],0xFF0000,[843,844,845],[814,815,816,845,846,847],[844,845,846]],
[[-32,25,-5],[-32,25,0],[-27,4,-4,],0xFF0000,[844,845,846],[814,815,816,845,846,847],[846,847,848]],
[[-32,25,0],[-27,4,0],[-27,4,-4,],0xFF0000,[814,815,816,845,846,847],[847,848,849],[846,847,848]],
[[-27,4,-4],[-27,4,0],[-32,-17,-5,],0xFF0000,[846,847,848],[847,848,849],[848,849,850]],
[[-27,4,0],[-32,-17,0],[-32,-17,-5,],0xFF0000,[847,848,849],[818,819,820,849,850,851],[848,849,850]],
[[-32,-17,-5],[-32,-17,0],[-45,-34,-8,],0xFF0000,[848,849,850],[818,819,820,849,850,851],[850,851,852]],
[[-32,-17,0],[-46,-34,0],[-45,-34,-8,],0xFF0000,[818,819,820,849,850,851],[851,852,853],[850,851,852]],
[[-45,-34,-8],[-46,-34,0],[-65,-45,-11,],0xFF0000,[850,851,852],[851,852,853],[852,853,869]],
[[-46,-34,0],[-66,-45,0],[-65,-45,-11,],0xFF0000,[851,852,853],[853,868,869],[852,853,869]],
[[-89,55,0],[-88,55,-15],[-112,49,0,],0xFF0000,[840,854],[840,841,854,855],[854,855,856]],
[[-112,49,0],[-88,55,-15],[-110,49,-19,],0xFF0000,[854,855,856],[840,841,854,855],[855,856,857]],
[[-112,49,0],[-110,49,-19],[-129,34,0,],0xFF0000,[854,855,856],[855,856,857],[856,857,858]],
[[-110,49,-19],[-127,34,-22],[-129,34,0,],0xFF0000,[855,856,857],[857,858,859],[856,857,858]],
[[-129,34,0],[-127,34,-22],[-138,14,0,],0xFF0000,[856,857,858],[857,858,859],[858,859,860]],
[[-127,34,-22],[-136,14,-24],[-138,14,0,],0xFF0000,[857,858,859],[859,860,861],[858,859,860]],
[[-138,14,0],[-136,14,-24],[-138,-6,0,],0xFF0000,[858,859,860],[859,860,861],[860,861,862]],
[[-136,14,-24],[-136,-6,-24],[-138,-6,0,],0xFF0000,[859,860,861],[861,862,863],[860,861,862]],
[[-138,-6,0],[-136,-6,-24],[-129,-26,0,],0xFF0000,[860,861,862],[861,862,863],[862,863,864]],
[[-136,-6,-24],[-127,-26,-22],[-129,-26,0,],0xFF0000,[861,862,863],[863,864,865],[862,863,864]],
[[-129,-26,0],[-127,-26,-22],[-111,-41,0,],0xFF0000,[862,863,864],[863,864,865],[864,865,866]],
[[-127,-26,-22],[-110,-41,-19],[-111,-41,0,],0xFF0000,[863,864,865],[865,866,867],[864,865,866]],
[[-111,-41,0],[-110,-41,-19],[-89,-47,0,],0xFF0000,[864,865,866],[865,866,867],[866,867,868]],
[[-110,-41,-19],[-88,-47,-15],[-89,-47,0,],0xFF0000,[865,866,867],[867,868,869],[866,867,868]],
[[-89,-47,0],[-88,-47,-15],[-66,-45,0,],0xFF0000,[866,867,868],[867,868,869],[853,868,869]],
[[-66,-45,0],[-88,-47,-15],[-65,-45,-11,],0xFF0000,[853,868,869],[867,868,869],[852,853,869]],
[[-88,55,-15],[-65,53,-11],[-84,55,-30,],0xFF0000,[870,884],[870,871,872,873],[870,871,884,885]],
[[-65,53,-11],[-62,53,-22],[-84,55,-30,],0xFF0000,[870,871,872,873],[871,872],[870,871,884,885]],
[[-62,53,-22],[-65,53,-11],[-43,42,-15,],0xFF0000,[871,872],[870,871,872,873],[872,873,874]],
[[-43,42,-15],[-65,53,-11],[-45,42,-8,],0xFF0000,[872,873,874],[870,871,872,873],[873,874,875]],
[[-43,42,-15],[-45,42,-8],[-30,25,-11,],0xFF0000,[872,873,874],[873,874,875],[874,875,876]],
[[-45,42,-8],[-32,25,-5],[-30,25,-11,],0xFF0000,[873,874,875],[875,876,877],[874,875,876]],
[[-30,25,-11],[-32,25,-5],[-26,4,-9,],0xFF0000,[874,875,876],[875,876,877],[876,877,878]],
[[-32,25,-5],[-27,4,-4],[-26,4,-9,],0xFF0000,[875,876,877],[877,878,879],[876,877,878]],
[[-26,4,-9],[-27,4,-4],[-30,-17,-11,],0xFF0000,[876,877,878],[877,878,879],[878,879,880]],
[[-27,4,-4],[-32,-17,-5],[-30,-17,-11,],0xFF0000,[877,878,879],[879,880,881],[878,879,880]],
[[-30,-17,-11],[-32,-17,-5],[-43,-34,-15,],0xFF0000,[878,879,880],[879,880,881],[880,881,882]],
[[-32,-17,-5],[-45,-34,-8],[-43,-34,-15,],0xFF0000,[879,880,881],[881,882,883],[880,881,882]],
[[-43,-34,-15],[-45,-34,-8],[-62,-45,-22,],0xFF0000,[880,881,882],[881,882,883],[882,883,899]],
[[-45,-34,-8],[-65,-45,-11],[-62,-45,-22,],0xFF0000,[881,882,883],[883,898,899],[882,883,899]],
[[-88,55,-15],[-84,55,-30],[-110,49,-19,],0xFF0000,[870,884],[870,871,884,885],[884,885,886]],
[[-110,49,-19],[-84,55,-30],[-105,49,-38,],0xFF0000,[884,885,886],[870,871,884,885],[885,886,887]],
[[-110,49,-19],[-105,49,-38],[-127,34,-22,],0xFF0000,[884,885,886],[885,886,887],[886,887,888]],
[[-105,49,-38],[-121,34,-44],[-127,34,-22,],0xFF0000,[885,886,887],[887,888,889],[886,887,888]],
[[-127,34,-22],[-121,34,-44],[-136,14,-24,],0xFF0000,[886,887,888],[887,888,889],[888,889,890]],
[[-121,34,-44],[-130,14,-47],[-136,14,-24,],0xFF0000,[887,888,889],[889,890,891,918,919,920],[888,889,890]],
[[-136,14,-24],[-130,14,-47],[-136,-6,-24,],0xFF0000,[888,889,890],[889,890,891,918,919,920],[890,891,892]],
[[-130,14,-47],[-130,-6,-47],[-136,-6,-24,],0xFF0000,[889,890,891,918,919,920],[891,892,893,920,921,922],[890,891,892]],
[[-136,-6,-24],[-130,-6,-47],[-127,-26,-22,],0xFF0000,[890,891,892],[891,892,893,920,921,922],[892,893,894]],
[[-130,-6,-47],[-121,-26,-44],[-127,-26,-22,],0xFF0000,[891,892,893,920,921,922],[893,894,895],[892,893,894]],
[[-127,-26,-22],[-121,-26,-44],[-110,-41,-19,],0xFF0000,[892,893,894],[893,894,895],[894,895,896]],
[[-121,-26,-44],[-105,-41,-38],[-110,-41,-19,],0xFF0000,[893,894,895],[895,896,897],[894,895,896]],
[[-110,-41,-19],[-105,-41,-38],[-88,-47,-15,],0xFF0000,[894,895,896],[895,896,897],[896,897,898]],
[[-105,-41,-38],[-84,-47,-30],[-88,-47,-15,],0xFF0000,[895,896,897],[897,898,899],[896,897,898]],
[[-88,-47,-15],[-84,-47,-30],[-65,-45,-11,],0xFF0000,[896,897,898],[897,898,899],[883,898,899]],
[[-65,-45,-11],[-84,-47,-30],[-62,-45,-22,],0xFF0000,[883,898,899],[897,898,899],[882,883,899]],
[[-84,55,-30],[-62,53,-22],[-77,55,-44,],0xFF0000,[900,914],[900,901,902,903],[900,901,914,915]],
[[-62,53,-22],[-57,53,-33],[-77,55,-44,],0xFF0000,[900,901,902,903],[901,902,930,931,932,933],[900,901,914,915]],
[[-57,53,-33],[-62,53,-22],[-40,42,-23,],0xFF0000,[901,902,930,931,932,933],[900,901,902,903],[902,903,904,933,934,935]],
[[-40,42,-23],[-62,53,-22],[-43,42,-15,],0xFF0000,[902,903,904,933,934,935],[900,901,902,903],[903,904,905]],
[[-40,42,-23],[-43,42,-15],[-28,25,-16,],0xFF0000,[902,903,904,933,934,935],[903,904,905],[904,905,906,935,936,937]],
[[-43,42,-15],[-30,25,-11],[-28,25,-16,],0xFF0000,[903,904,905],[905,906,907],[904,905,906,935,936,937]],
[[-28,25,-16],[-30,25,-11],[-24,4,-13,],0xFF0000,[904,905,906,935,936,937],[905,906,907],[906,907,908]],
[[-30,25,-11],[-26,4,-9],[-24,4,-13,],0xFF0000,[905,906,907],[907,908,909],[906,907,908]],
[[-24,4,-13],[-26,4,-9],[-28,-17,-16,],0xFF0000,[906,907,908],[907,908,909],[908,909,910,939,940,941]],
[[-26,4,-9],[-30,-17,-11],[-28,-17,-16,],0xFF0000,[907,908,909],[909,910,911],[908,909,910,939,940,941]],
[[-28,-17,-16],[-30,-17,-11],[-40,-34,-23,],0xFF0000,[908,909,910,939,940,941],[909,910,911],[910,911,912,941,942,943]],
[[-30,-17,-11],[-43,-34,-15],[-40,-34,-23,],0xFF0000,[909,910,911],[911,912,913],[910,911,912,941,942,943]],
[[-40,-34,-23],[-43,-34,-15],[-57,-45,-33,],0xFF0000,[910,911,912,941,942,943],[911,912,913],[912,913,929]],
[[-43,-34,-15],[-62,-45,-22],[-57,-45,-33,],0xFF0000,[911,912,913],[913,928,929],[912,913,929]],
[[-84,55,-30],[-77,55,-44],[-105,49,-38,],0xFF0000,[900,914],[900,901,914,915],[914,915,916]],
[[-105,49,-38],[-77,55,-44],[-96,49,-56,],0xFF0000,[914,915,916],[900,901,914,915],[915,916,917]],
[[-105,49,-38],[-96,49,-56],[-121,34,-44,],0xFF0000,[914,915,916],[915,916,917],[916,917,918]],
[[-96,49,-56],[-111,34,-64],[-121,34,-44,],0xFF0000,[915,916,917],[917,918,919],[916,917,918]],
[[-121,34,-44],[-111,34,-64],[-130,14,-47,],0xFF0000,[916,917,918],[917,918,919],[889,890,891,918,919,920]],
[[-111,34,-64],[-120,14,-69],[-130,14,-47,],0xFF0000,[917,918,919],[919,920,921,948,949,950],[889,890,891,918,919,920]],
[[-130,14,-47],[-120,14,-69],[-130,-6,-47,],0xFF0000,[889,890,891,918,919,920],[919,920,921,948,949,950],[891,892,893,920,921,922]],
[[-120,14,-69],[-120,-6,-69],[-130,-6,-47,],0xFF0000,[919,920,921,948,949,950],[921,922,923,950,951,952],[891,892,893,920,921,922]],
[[-130,-6,-47],[-120,-6,-69],[-121,-26,-44,],0xFF0000,[891,892,893,920,921,922],[921,922,923,950,951,952],[922,923,924]],
[[-120,-6,-69],[-111,-26,-64],[-121,-26,-44,],0xFF0000,[921,922,923,950,951,952],[923,924,925],[922,923,924]],
[[-121,-26,-44],[-111,-26,-64],[-105,-41,-38,],0xFF0000,[922,923,924],[923,924,925],[924,925,926]],
[[-111,-26,-64],[-96,-41,-55],[-105,-41,-38,],0xFF0000,[923,924,925],[925,926,927],[924,925,926]],
[[-105,-41,-38],[-96,-41,-55],[-84,-47,-30,],0xFF0000,[924,925,926],[925,926,927],[926,927,928]],
[[-96,-41,-55],[-77,-47,-44],[-84,-47,-30,],0xFF0000,[925,926,927],[927,928,929],[926,927,928]],
[[-84,-47,-30],[-77,-47,-44],[-62,-45,-22,],0xFF0000,[926,927,928],[927,928,929],[913,928,929]],
[[-62,-45,-22],[-77,-47,-44],[-57,-45,-33,],0xFF0000,[913,928,929],[927,928,929],[912,913,929]],
[[-77,55,-44],[-57,53,-33],[-68,55,-57,],0xFF0000,[930,944],[901,902,930,931,932,933],[930,931,944,945]],
[[-57,53,-33],[-51,53,-42],[-68,55,-57,],0xFF0000,[901,902,930,931,932,933],[931,932],[930,931,944,945]],
[[-51,53,-42],[-57,53,-33],[-35,42,-29,],0xFF0000,[931,932],[901,902,930,931,932,933],[932,933,934]],
[[-35,42,-29],[-57,53,-33],[-40,42,-23,],0xFF0000,[932,933,934],[901,902,930,931,932,933],[902,903,904,933,934,935]],
[[-35,42,-29],[-40,42,-23],[-25,25,-21,],0xFF0000,[932,933,934],[902,903,904,933,934,935],[934,935,936]],
[[-40,42,-23],[-28,25,-16],[-25,25,-21,],0xFF0000,[902,903,904,933,934,935],[904,905,906,935,936,937],[934,935,936]],
[[-25,25,-21],[-28,25,-16],[-21,4,-17,],0xFF0000,[934,935,936],[904,905,906,935,936,937],[936,937,938]],
[[-28,25,-16],[-24,4,-13],[-21,4,-17,],0xFF0000,[904,905,906,935,936,937],[937,938,939],[936,937,938]],
[[-21,4,-17],[-24,4,-13],[-25,-17,-21,],0xFF0000,[936,937,938],[937,938,939],[938,939,940]],
[[-24,4,-13],[-28,-17,-16],[-25,-17,-21,],0xFF0000,[937,938,939],[908,909,910,939,940,941],[938,939,940]],
[[-25,-17,-21],[-28,-17,-16],[-35,-34,-29,],0xFF0000,[938,939,940],[908,909,910,939,940,941],[940,941,942]],
[[-28,-17,-16],[-40,-34,-23],[-35,-34,-29,],0xFF0000,[908,909,910,939,940,941],[910,911,912,941,942,943],[940,941,942]],
[[-35,-34,-29],[-40,-34,-23],[-51,-45,-42,],0xFF0000,[940,941,942],[910,911,912,941,942,943],[942,943,959]],
[[-40,-34,-23],[-57,-45,-33],[-51,-45,-42,],0xFF0000,[910,911,912,941,942,943],[943,958,959],[942,943,959]],
[[-77,55,-44],[-68,55,-57],[-96,49,-56,],0xFF0000,[930,944],[930,931,944,945],[944,945,946]],
[[-96,49,-56],[-68,55,-57],[-85,49,-71,],0xFF0000,[944,945,946],[930,931,944,945],[945,946,947]],
[[-96,49,-56],[-85,49,-71],[-111,34,-64,],0xFF0000,[944,945,946],[945,946,947],[946,947,948]],
[[-85,49,-71],[-99,34,-83],[-111,34,-64,],0xFF0000,[945,946,947],[947,948,949],[946,947,948]],
[[-111,34,-64],[-99,34,-83],[-120,14,-69,],0xFF0000,[946,947,948],[947,948,949],[919,920,921,948,949,950]],
[[-99,34,-83],[-106,14,-89],[-120,14,-69,],0xFF0000,[947,948,949],[949,950,951],[919,920,921,948,949,950]],
[[-120,14,-69],[-106,14,-89],[-120,-6,-69,],0xFF0000,[919,920,921,948,949,950],[949,950,951],[921,922,923,950,951,952]],
[[-106,14,-89],[-106,-6,-89],[-120,-6,-69,],0xFF0000,[949,950,951],[951,952,953],[921,922,923,950,951,952]],
[[-120,-6,-69],[-106,-6,-89],[-111,-26,-64,],0xFF0000,[921,922,923,950,951,952],[951,952,953],[952,953,954]],
[[-106,-6,-89],[-99,-26,-83],[-111,-26,-64,],0xFF0000,[951,952,953],[953,954,955],[952,953,954]],
[[-111,-26,-64],[-99,-26,-83],[-96,-41,-55,],0xFF0000,[952,953,954],[953,954,955],[954,955,956]],
[[-99,-26,-83],[-85,-41,-71],[-96,-41,-55,],0xFF0000,[953,954,955],[955,956,957],[954,955,956]],
[[-96,-41,-55],[-85,-41,-71],[-77,-47,-44,],0xFF0000,[954,955,956],[955,956,957],[956,957,958]],
[[-85,-41,-71],[-68,-47,-57],[-77,-47,-44,],0xFF0000,[955,956,957],[957,958,959],[956,957,958]],
[[-77,-47,-44],[-68,-47,-57],[-57,-45,-33,],0xFF0000,[956,957,958],[957,958,959],[943,958,959]],
[[-57,-45,-33],[-68,-47,-57],[-51,-45,-42,],0xFF0000,[943,958,959],[957,958,959],[942,943,959]],
[[-68,55,-57],[-51,53,-42],[-57,55,-68,],0xFF0000,[960,974],[960,961,962,963],[960,961,974,975]],
[[-51,53,-42],[-42,53,-51],[-57,55,-68,],0xFF0000,[960,961,962,963],[961,962],[960,961,974,975]],
[[-42,53,-51],[-51,53,-42],[-29,42,-35,],0xFF0000,[961,962],[960,961,962,963],[962,963,964]],
[[-29,42,-35],[-51,53,-42],[-35,42,-29,],0xFF0000,[962,963,964],[960,961,962,963],[963,964,965]],
[[-29,42,-35],[-35,42,-29],[-21,25,-25,],0xFF0000,[962,963,964],[963,964,965],[964,965,966]],
[[-35,42,-29],[-25,25,-21],[-21,25,-25,],0xFF0000,[963,964,965],[965,966,967],[964,965,966]],
[[-21,25,-25],[-25,25,-21],[-17,4,-21,],0xFF0000,[964,965,966],[965,966,967],[966,967,968]],
[[-25,25,-21],[-21,4,-17],[-17,4,-21,],0xFF0000,[965,966,967],[967,968,969],[966,967,968]],
[[-17,4,-21],[-21,4,-17],[-21,-17,-25,],0xFF0000,[966,967,968],[967,968,969],[968,969,970]],
[[-21,4,-17],[-25,-17,-21],[-21,-17,-25,],0xFF0000,[967,968,969],[969,970,971],[968,969,970]],
[[-21,-17,-25],[-25,-17,-21],[-29,-34,-35,],0xFF0000,[968,969,970],[969,970,971],[970,971,972,1001,1002,1003]],
[[-25,-17,-21],[-35,-34,-29],[-29,-34,-35,],0xFF0000,[969,970,971],[971,972,973],[970,971,972,1001,1002,1003]],
[[-29,-34,-35],[-35,-34,-29],[-42,-45,-51,],0xFF0000,[970,971,972,1001,1002,1003],[971,972,973],[972,973,989]],
[[-35,-34,-29],[-51,-45,-42],[-42,-45,-51,],0xFF0000,[971,972,973],[973,988,989],[972,973,989]],
[[-68,55,-57],[-57,55,-68],[-85,49,-71,],0xFF0000,[960,974],[960,961,974,975],[974,975,976]],
[[-85,49,-71],[-57,55,-68],[-71,49,-85,],0xFF0000,[974,975,976],[960,961,974,975],[975,976,977]],
[[-85,49,-71],[-71,49,-85],[-99,34,-83,],0xFF0000,[974,975,976],[975,976,977],[976,977,978]],
[[-71,49,-85],[-83,34,-99],[-99,34,-83,],0xFF0000,[975,976,977],[977,978,979,1006,1007,1008],[976,977,978]],
[[-99,34,-83],[-83,34,-99],[-106,14,-89,],0xFF0000,[976,977,978],[977,978,979,1006,1007,1008],[978,979,980]],
[[-83,34,-99],[-89,14,-106],[-106,14,-89,],0xFF0000,[977,978,979,1006,1007,1008],[979,980,981],[978,979,980]],
[[-106,14,-89],[-89,14,-106],[-106,-6,-89,],0xFF0000,[978,979,980],[979,980,981],[980,981,982]],
[[-89,14,-106],[-89,-6,-106],[-106,-6,-89,],0xFF0000,[979,980,981],[981,982,983],[980,981,982]],
[[-106,-6,-89],[-89,-6,-106],[-99,-26,-83,],0xFF0000,[980,981,982],[981,982,983],[982,983,984]],
[[-89,-6,-106],[-83,-26,-99],[-99,-26,-83,],0xFF0000,[981,982,983],[983,984,985],[982,983,984]],
[[-99,-26,-83],[-83,-26,-99],[-85,-41,-71,],0xFF0000,[982,983,984],[983,984,985],[984,985,986]],
[[-83,-26,-99],[-71,-41,-85],[-85,-41,-71,],0xFF0000,[983,984,985],[985,986,987],[984,985,986]],
[[-85,-41,-71],[-71,-41,-85],[-68,-47,-57,],0xFF0000,[984,985,986],[985,986,987],[986,987,988]],
[[-71,-41,-85],[-57,-47,-68],[-68,-47,-57,],0xFF0000,[985,986,987],[987,988,989],[986,987,988]],
[[-68,-47,-57],[-57,-47,-68],[-51,-45,-42,],0xFF0000,[986,987,988],[987,988,989],[973,988,989]],
[[-51,-45,-42],[-57,-47,-68],[-42,-45,-51,],0xFF0000,[973,988,989],[987,988,989],[972,973,989]],
[[-57,55,-68],[-42,53,-51],[-44,55,-77,],0xFF0000,[990,1004],[990,991,992,993],[990,991,1004,1005,1020,1034]],
[[-42,53,-51],[-33,53,-57],[-44,55,-77,],0xFF0000,[990,991,992,993],[991,992,1020,1021,1022,1023],[990,991,1004,1005,1020,1034]],
[[-33,53,-57],[-42,53,-51],[-23,42,-40,],0xFF0000,[991,992,1020,1021,1022,1023],[990,991,992,993],[992,993,994,1023,1024,1025]],
[[-23,42,-40],[-42,53,-51],[-29,42,-35,],0xFF0000,[992,993,994,1023,1024,1025],[990,991,992,993],[993,994,995]],
[[-23,42,-40],[-29,42,-35],[-16,25,-28,],0xFF0000,[992,993,994,1023,1024,1025],[993,994,995],[994,995,996,1025,1026,1027]],
[[-29,42,-35],[-21,25,-25],[-16,25,-28,],0xFF0000,[993,994,995],[995,996,997],[994,995,996,1025,1026,1027]],
[[-16,25,-28],[-21,25,-25],[-14,4,-24,],0xFF0000,[994,995,996,1025,1026,1027],[995,996,997],[996,997,998]],
[[-21,25,-25],[-17,4,-21],[-14,4,-24,],0xFF0000,[995,996,997],[997,998,999],[996,997,998]],
[[-14,4,-24],[-17,4,-21],[-16,-17,-28,],0xFF0000,[996,997,998],[997,998,999],[998,999,1000,1029,1030,1031]],
[[-17,4,-21],[-21,-17,-25],[-16,-17,-28,],0xFF0000,[997,998,999],[999,1000,1001],[998,999,1000,1029,1030,1031]],
[[-16,-17,-28],[-21,-17,-25],[-23,-34,-40,],0xFF0000,[998,999,1000,1029,1030,1031],[999,1000,1001],[1000,1001,1002,1031,1032,1033]],
[[-21,-17,-25],[-29,-34,-35],[-23,-34,-40,],0xFF0000,[999,1000,1001],[970,971,972,1001,1002,1003],[1000,1001,1002,1031,1032,1033]],
[[-23,-34,-40],[-29,-34,-35],[-33,-45,-57,],0xFF0000,[1000,1001,1002,1031,1032,1033],[970,971,972,1001,1002,1003],[1002,1003,1019]],
[[-29,-34,-35],[-42,-45,-51],[-33,-45,-57,],0xFF0000,[970,971,972,1001,1002,1003],[1003,1018,1019],[1002,1003,1019]],
[[-57,55,-68],[-44,55,-77],[-71,49,-85,],0xFF0000,[990,1004],[990,991,1004,1005,1020,1034],[1004,1005,1006]],
[[-71,49,-85],[-44,55,-77],[-56,49,-96,],0xFF0000,[1004,1005,1006],[990,991,1004,1005,1020,1034],[1005,1006,1007]],
[[-71,49,-85],[-56,49,-96],[-83,34,-99,],0xFF0000,[1004,1005,1006],[1005,1006,1007],[977,978,979,1006,1007,1008]],
[[-56,49,-96],[-64,34,-111],[-83,34,-99,],0xFF0000,[1005,1006,1007],[1007,1008,1009],[977,978,979,1006,1007,1008]],
[[-83,34,-99],[-64,34,-111],[-89,14,-106,],0xFF0000,[977,978,979,1006,1007,1008],[1007,1008,1009],[1008,1009,1010]],
[[-64,34,-111],[-69,14,-120],[-89,14,-106,],0xFF0000,[1007,1008,1009],[1009,1010,1011],[1008,1009,1010]],
[[-89,14,-106],[-69,14,-120],[-89,-6,-106,],0xFF0000,[1008,1009,1010],[1009,1010,1011],[1010,1011,1012]],
[[-69,14,-120],[-69,-6,-120],[-89,-6,-106,],0xFF0000,[1009,1010,1011],[1011,1012,1013],[1010,1011,1012]],
[[-89,-6,-106],[-69,-6,-120],[-83,-26,-99,],0xFF0000,[1010,1011,1012],[1011,1012,1013],[1012,1013,1014]],
[[-69,-6,-120],[-64,-26,-111],[-83,-26,-99,],0xFF0000,[1011,1012,1013],[1013,1014,1015],[1012,1013,1014]],
[[-83,-26,-99],[-64,-26,-111],[-71,-41,-85,],0xFF0000,[1012,1013,1014],[1013,1014,1015],[1014,1015,1016]],
[[-64,-26,-111],[-56,-41,-96],[-71,-41,-85,],0xFF0000,[1013,1014,1015],[1015,1016,1017],[1014,1015,1016]],
[[-71,-41,-85],[-56,-41,-96],[-57,-47,-68,],0xFF0000,[1014,1015,1016],[1015,1016,1017],[1016,1017,1018]],
[[-56,-41,-96],[-44,-47,-77],[-57,-47,-68,],0xFF0000,[1015,1016,1017],[1017,1018,1019],[1016,1017,1018]],
[[-57,-47,-68],[-44,-47,-77],[-42,-45,-51,],0xFF0000,[1016,1017,1018],[1017,1018,1019],[1003,1018,1019]],
[[-42,-45,-51],[-44,-47,-77],[-33,-45,-57,],0xFF0000,[1003,1018,1019],[1017,1018,1019],[1002,1003,1019]],
[[-44,55,-77],[-33,53,-57],[-30,55,-84,],0xFF0000,[990,991,1004,1005,1020,1034],[991,992,1020,1021,1022,1023],[1020,1021,1034,1035]],
[[-33,53,-57],[-22,53,-62],[-30,55,-84,],0xFF0000,[991,992,1020,1021,1022,1023],[1021,1022],[1020,1021,1034,1035]],
[[-22,53,-62],[-33,53,-57],[-15,42,-43,],0xFF0000,[1021,1022],[991,992,1020,1021,1022,1023],[1022,1023,1024]],
[[-15,42,-43],[-33,53,-57],[-23,42,-40,],0xFF0000,[1022,1023,1024],[991,992,1020,1021,1022,1023],[992,993,994,1023,1024,1025]],
[[-15,42,-43],[-23,42,-40],[-11,25,-30,],0xFF0000,[1022,1023,1024],[992,993,994,1023,1024,1025],[1024,1025,1026,1055,1056,1057]],
[[-23,42,-40],[-16,25,-28],[-11,25,-30,],0xFF0000,[992,993,994,1023,1024,1025],[994,995,996,1025,1026,1027],[1024,1025,1026,1055,1056,1057]],
[[-11,25,-30],[-16,25,-28],[-9,4,-26,],0xFF0000,[1024,1025,1026,1055,1056,1057],[994,995,996,1025,1026,1027],[1026,1027,1028,1057,1058,1059]],
[[-16,25,-28],[-14,4,-24],[-9,4,-26,],0xFF0000,[994,995,996,1025,1026,1027],[1027,1028,1029],[1026,1027,1028,1057,1058,1059]],
[[-9,4,-26],[-14,4,-24],[-11,-17,-30,],0xFF0000,[1026,1027,1028,1057,1058,1059],[1027,1028,1029],[1028,1029,1030,1059,1060,1061]],
[[-14,4,-24],[-16,-17,-28],[-11,-17,-30,],0xFF0000,[1027,1028,1029],[998,999,1000,1029,1030,1031],[1028,1029,1030,1059,1060,1061]],
[[-11,-17,-30],[-16,-17,-28],[-15,-34,-43,],0xFF0000,[1028,1029,1030,1059,1060,1061],[998,999,1000,1029,1030,1031],[1030,1031,1032,1061,1062,1063]],
[[-16,-17,-28],[-23,-34,-40],[-15,-34,-43,],0xFF0000,[998,999,1000,1029,1030,1031],[1000,1001,1002,1031,1032,1033],[1030,1031,1032,1061,1062,1063]],
[[-15,-34,-43],[-23,-34,-40],[-22,-45,-62,],0xFF0000,[1030,1031,1032,1061,1062,1063],[1000,1001,1002,1031,1032,1033],[1032,1033,1049]],
[[-23,-34,-40],[-33,-45,-57],[-22,-45,-62,],0xFF0000,[1000,1001,1002,1031,1032,1033],[1033,1048,1049],[1032,1033,1049]],
[[-44,55,-77],[-30,55,-84],[-56,49,-96,],0xFF0000,[990,991,1004,1005,1020,1034],[1020,1021,1034,1035],[1034,1035,1036]],
[[-56,49,-96],[-30,55,-84],[-38,49,-105,],0xFF0000,[1034,1035,1036],[1020,1021,1034,1035],[1035,1036,1037,1064,1065,1066]],
[[-56,49,-96],[-38,49,-105],[-64,34,-111,],0xFF0000,[1034,1035,1036],[1035,1036,1037,1064,1065,1066],[1036,1037,1038]],
[[-38,49,-105],[-44,34,-121],[-64,34,-111,],0xFF0000,[1035,1036,1037,1064,1065,1066],[1037,1038,1039,1066,1067,1068],[1036,1037,1038]],
[[-64,34,-111],[-44,34,-121],[-69,14,-120,],0xFF0000,[1036,1037,1038],[1037,1038,1039,1066,1067,1068],[1038,1039,1040]],
[[-44,34,-121],[-47,14,-130],[-69,14,-120,],0xFF0000,[1037,1038,1039,1066,1067,1068],[1039,1040,1041,1068,1069,1070],[1038,1039,1040]],
[[-69,14,-120],[-47,14,-130],[-69,-6,-120,],0xFF0000,[1038,1039,1040],[1039,1040,1041,1068,1069,1070],[1040,1041,1042]],
[[-47,14,-130],[-47,-6,-130],[-69,-6,-120,],0xFF0000,[1039,1040,1041,1068,1069,1070],[1041,1042,1043,1070,1071,1072],[1040,1041,1042]],
[[-69,-6,-120],[-47,-6,-130],[-64,-26,-111,],0xFF0000,[1040,1041,1042],[1041,1042,1043,1070,1071,1072],[1042,1043,1044]],
[[-47,-6,-130],[-44,-26,-121],[-64,-26,-111,],0xFF0000,[1041,1042,1043,1070,1071,1072],[1043,1044,1045],[1042,1043,1044]],
[[-64,-26,-111],[-44,-26,-121],[-56,-41,-96,],0xFF0000,[1042,1043,1044],[1043,1044,1045],[1044,1045,1046]],
[[-44,-26,-121],[-38,-41,-105],[-56,-41,-96,],0xFF0000,[1043,1044,1045],[1045,1046,1047,1074,1075,1076],[1044,1045,1046]],
[[-56,-41,-96],[-38,-41,-105],[-44,-47,-77,],0xFF0000,[1044,1045,1046],[1045,1046,1047,1074,1075,1076],[1046,1047,1048]],
[[-38,-41,-105],[-30,-47,-84],[-44,-47,-77,],0xFF0000,[1045,1046,1047,1074,1075,1076],[1047,1048,1049],[1046,1047,1048]],
[[-44,-47,-77],[-30,-47,-84],[-33,-45,-57,],0xFF0000,[1046,1047,1048],[1047,1048,1049],[1033,1048,1049]],
[[-33,-45,-57],[-30,-47,-84],[-22,-45,-62,],0xFF0000,[1033,1048,1049],[1047,1048,1049],[1032,1033,1049]],
[[-30,55,-84],[-22,53,-62],[-15,55,-88,],0xFF0000,[1050,1064],[1050,1051,1052,1053],[1050,1051,1064,1065]],
[[-22,53,-62],[-11,53,-65],[-15,55,-88,],0xFF0000,[1050,1051,1052,1053],[1051,1052],[1050,1051,1064,1065]],
[[-11,53,-65],[-22,53,-62],[-8,42,-45,],0xFF0000,[1051,1052],[1050,1051,1052,1053],[1052,1053,1054]],
[[-8,42,-45],[-22,53,-62],[-15,42,-43,],0xFF0000,[1052,1053,1054],[1050,1051,1052,1053],[1053,1054,1055]],
[[-8,42,-45],[-15,42,-43],[-5,25,-32,],0xFF0000,[1052,1053,1054],[1053,1054,1055],[1054,1055,1056]],
[[-15,42,-43],[-11,25,-30],[-5,25,-32,],0xFF0000,[1053,1054,1055],[1024,1025,1026,1055,1056,1057],[1054,1055,1056]],
[[-5,25,-32],[-11,25,-30],[-4,4,-27,],0xFF0000,[1054,1055,1056],[1024,1025,1026,1055,1056,1057],[1056,1057,1058]],
[[-11,25,-30],[-9,4,-26],[-4,4,-27,],0xFF0000,[1024,1025,1026,1055,1056,1057],[1026,1027,1028,1057,1058,1059],[1056,1057,1058]],
[[-4,4,-27],[-9,4,-26],[-5,-17,-32,],0xFF0000,[1056,1057,1058],[1026,1027,1028,1057,1058,1059],[1058,1059,1060]],
[[-9,4,-26],[-11,-17,-30],[-5,-17,-32,],0xFF0000,[1026,1027,1028,1057,1058,1059],[1028,1029,1030,1059,1060,1061],[1058,1059,1060]],
[[-5,-17,-32],[-11,-17,-30],[-8,-34,-45,],0xFF0000,[1058,1059,1060],[1028,1029,1030,1059,1060,1061],[1060,1061,1062]],
[[-11,-17,-30],[-15,-34,-43],[-8,-34,-45,],0xFF0000,[1028,1029,1030,1059,1060,1061],[1030,1031,1032,1061,1062,1063],[1060,1061,1062]],
[[-8,-34,-45],[-15,-34,-43],[-11,-45,-65,],0xFF0000,[1060,1061,1062],[1030,1031,1032,1061,1062,1063],[1062,1063,1079]],
[[-15,-34,-43],[-22,-45,-62],[-11,-45,-65,],0xFF0000,[1030,1031,1032,1061,1062,1063],[1063,1078,1079],[1062,1063,1079]],
[[-30,55,-84],[-15,55,-88],[-38,49,-105,],0xFF0000,[1050,1064],[1050,1051,1064,1065],[1035,1036,1037,1064,1065,1066]],
[[-38,49,-105],[-15,55,-88],[-19,49,-110,],0xFF0000,[1035,1036,1037,1064,1065,1066],[1050,1051,1064,1065],[1065,1066,1067]],
[[-38,49,-105],[-19,49,-110],[-44,34,-121,],0xFF0000,[1035,1036,1037,1064,1065,1066],[1065,1066,1067],[1037,1038,1039,1066,1067,1068]],
[[-19,49,-110],[-22,34,-127],[-44,34,-121,],0xFF0000,[1065,1066,1067],[1067,1068,1069],[1037,1038,1039,1066,1067,1068]],
[[-44,34,-121],[-22,34,-127],[-47,14,-130,],0xFF0000,[1037,1038,1039,1066,1067,1068],[1067,1068,1069],[1039,1040,1041,1068,1069,1070]],
[[-22,34,-127],[-24,14,-136],[-47,14,-130,],0xFF0000,[1067,1068,1069],[1069,1070,1071],[1039,1040,1041,1068,1069,1070]],
[[-47,14,-130],[-24,14,-136],[-47,-6,-130,],0xFF0000,[1039,1040,1041,1068,1069,1070],[1069,1070,1071],[1041,1042,1043,1070,1071,1072]],
[[-24,14,-136],[-24,-6,-136],[-47,-6,-130,],0xFF0000,[1069,1070,1071],[1071,1072,1073],[1041,1042,1043,1070,1071,1072]],
[[-47,-6,-130],[-24,-6,-136],[-44,-26,-121,],0xFF0000,[1041,1042,1043,1070,1071,1072],[1071,1072,1073],[1072,1073,1074]],
[[-24,-6,-136],[-22,-26,-127],[-44,-26,-121,],0xFF0000,[1071,1072,1073],[1073,1074,1075],[1072,1073,1074]],
[[-44,-26,-121],[-22,-26,-127],[-38,-41,-105,],0xFF0000,[1072,1073,1074],[1073,1074,1075],[1045,1046,1047,1074,1075,1076]],
[[-22,-26,-127],[-19,-41,-110],[-38,-41,-105,],0xFF0000,[1073,1074,1075],[1075,1076,1077],[1045,1046,1047,1074,1075,1076]],
[[-38,-41,-105],[-19,-41,-110],[-30,-47,-84,],0xFF0000,[1045,1046,1047,1074,1075,1076],[1075,1076,1077],[1076,1077,1078]],
[[-19,-41,-110],[-15,-47,-88],[-30,-47,-84,],0xFF0000,[1075,1076,1077],[1077,1078,1079],[1076,1077,1078]],
[[-30,-47,-84],[-15,-47,-88],[-22,-45,-62,],0xFF0000,[1076,1077,1078],[1077,1078,1079],[1063,1078,1079]],
[[-22,-45,-62],[-15,-47,-88],[-11,-45,-65,],0xFF0000,[1063,1078,1079],[1077,1078,1079],[1062,1063,1079]],
[[-15,55,-88],[-11,53,-65],[0,55,-89,],0xFF0000,[1080,1094],[1080,1081,1082,1083],[523,524,1080,1081,1094,1095]],
[[-11,53,-65],[0,53,-66],[0,55,-89,],0xFF0000,[1080,1081,1082,1083],[540,552,1081,1082],[523,524,1080,1081,1094,1095]],
[[0,53,-66],[-11,53,-65],[0,42,-46,],0xFF0000,[540,552,1081,1082],[1080,1081,1082,1083],[1082,1083,1084]],
[[0,42,-46],[-11,53,-65],[-8,42,-45,],0xFF0000,[1082,1083,1084],[1080,1081,1082,1083],[541,542,543,1083,1084,1085]],
[[0,42,-46],[-8,42,-45],[0,25,-32,],0xFF0000,[1082,1083,1084],[541,542,543,1083,1084,1085],[542,543,544,1084,1085,1086]],
[[-8,42,-45],[-5,25,-32],[0,25,-32,],0xFF0000,[541,542,543,1083,1084,1085],[1085,1086,1087],[542,543,544,1084,1085,1086]],
[[0,25,-32],[-5,25,-32],[0,4,-27,],0xFF0000,[542,543,544,1084,1085,1086],[1085,1086,1087],[1086,1087,1088]],
[[-5,25,-32],[-4,4,-27],[0,4,-27,],0xFF0000,[1085,1086,1087],[1087,1088,1089],[1086,1087,1088]],
[[0,4,-27],[-4,4,-27],[0,-17,-32,],0xFF0000,[1086,1087,1088],[1087,1088,1089],[546,547,548,1088,1089,1090]],
[[-4,4,-27],[-5,-17,-32],[0,-17,-32,],0xFF0000,[1087,1088,1089],[1089,1090,1091],[546,547,548,1088,1089,1090]],
[[0,-17,-32],[-5,-17,-32],[0,-34,-46,],0xFF0000,[546,547,548,1088,1089,1090],[1089,1090,1091],[548,549,550,1090,1091,1092]],
[[-5,-17,-32],[-8,-34,-45],[0,-34,-46,],0xFF0000,[1089,1090,1091],[549,550,551,1091,1092,1093],[548,549,550,1090,1091,1092]],
[[0,-34,-46],[-8,-34,-45],[0,-45,-66,],0xFF0000,[548,549,550,1090,1091,1092],[549,550,551,1091,1092,1093],[1092,1093,1109]],
[[-8,-34,-45],[-11,-45,-65],[0,-45,-66,],0xFF0000,[549,550,551,1091,1092,1093],[1093,1108,1109],[1092,1093,1109]],
[[-15,55,-88],[0,55,-89],[-19,49,-110,],0xFF0000,[1080,1094],[523,524,1080,1081,1094,1095],[1094,1095,1096]],
[[-19,49,-110],[0,55,-89],[0,49,-112,],0xFF0000,[1094,1095,1096],[523,524,1080,1081,1094,1095],[555,560,561,1095,1096,1097]],
[[-19,49,-110],[0,49,-112],[-22,34,-127,],0xFF0000,[1094,1095,1096],[555,560,561,1095,1096,1097],[1096,1097,1098]],
[[0,49,-112],[0,34,-129],[-22,34,-127,],0xFF0000,[555,560,561,1095,1096,1097],[1097,1098,1099],[1096,1097,1098]],
[[-22,34,-127],[0,34,-129],[-24,14,-136,],0xFF0000,[1096,1097,1098],[1097,1098,1099],[1098,1099,1100]],
[[0,34,-129],[0,14,-138],[-24,14,-136,],0xFF0000,[1097,1098,1099],[1099,1100,1101],[1098,1099,1100]],
[[-24,14,-136],[0,14,-138],[-24,-6,-136,],0xFF0000,[1098,1099,1100],[1099,1100,1101],[1100,1101,1102]],
[[0,14,-138],[0,-6,-138],[-24,-6,-136,],0xFF0000,[1099,1100,1101],[1101,1102,1103],[1100,1101,1102]],
[[-24,-6,-136],[0,-6,-138],[-22,-26,-127,],0xFF0000,[1100,1101,1102],[1101,1102,1103],[1102,1103,1104]],
[[0,-6,-138],[0,-26,-129],[-22,-26,-127,],0xFF0000,[1101,1102,1103],[536,537,538,567,568,569,1103,1104,1105],[1102,1103,1104]],
[[-22,-26,-127],[0,-26,-129],[-19,-41,-110,],0xFF0000,[1102,1103,1104],[536,537,538,567,568,569,1103,1104,1105],[1104,1105,1106]],
[[0,-26,-129],[0,-41,-111],[-19,-41,-110,],0xFF0000,[536,537,538,567,568,569,1103,1104,1105],[1105,1106,1107],[1104,1105,1106]],
[[-19,-41,-110],[0,-41,-111],[-15,-47,-88,],0xFF0000,[1104,1105,1106],[1105,1106,1107],[1106,1107,1108]],
[[0,-41,-111],[0,-47,-89],[-15,-47,-88,],0xFF0000,[1105,1106,1107],[556,557,558,559,1107,1108,1109],[1106,1107,1108]],
[[-15,-47,-88],[0,-47,-89],[-11,-45,-65,],0xFF0000,[1106,1107,1108],[556,557,558,559,1107,1108,1109],[1093,1108,1109]],
[[-11,-45,-65],[0,-47,-89],[0,-45,-66,],0xFF0000,[1093,1108,1109],[556,557,558,559,1107,1108,1109],[1092,1093,1109]],

	
];
		
		public static var scr_width:Number = 500;
		public static var scr_height:Number = 500;
		public static var world_cordinate:Array = new Array(local_cordinate.length);
		public static var screen_cordinate:Array = new Array(local_cordinate.length);
		public static var light:Light = new Light();
		public static var position:Array = new Array(3);
		public static var xRotMatrix:Array = new Array(3);
		public static var yRotMatrix:Array = new Array(3);
		public static var zRotMatrix:Array = new Array(3);
		public static var result:Array = new Array(3);
		public static var fl:Number = 250;
		public static var vpX:Number = 0;
		public static var vpY:Number = 0;
		public static var cX:Number = 0;
		public static var cY:Number = 0;
		public static var cZ:Number = 0;
		public static var init_scr:BitmapData = new BitmapData(scr_width, scr_height);
		public static var scr:BitmapData = new BitmapData(scr_width, scr_height);
		public static var z_buffer:Array;
		public static var z_buf:Boolean = true;
		public static var wire:Boolean = false;
		public static var rotate:Boolean = false;
		
	}