/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5zP3
 */

//
//	渦、台風っぽく
//	高速化しないと重いな
//	ブラーもかけたいかも
//	じっと見てると目をまわします
//
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * ...
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private var spire:Spire;
		private var powders:Array = new Array();
		private static const POWDER_NUM:int = 3000;
		
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			spire = new Spire();
			
			for ( var i:int = 0; i < POWDER_NUM; i++ )
			{
				var x:Number = Math.random() * stage.stageWidth;
				var y:Number = Math.random() * stage.stageHeight;
				powders.push( new Powder(x, y, int(Math.random() * 1000)) );
			}
			
			
			addEventListener( Event.ENTER_FRAME, EnterFrame );
		}
		
		private function EnterFrame(e:Event):void
		{
			var i:int = 0;
			
			spire.Update( stage.mouseX, stage.mouseY );
			for ( i = 0; i < POWDER_NUM; i++ )
			{
				powders[i].Move( spire );
			}			
			
			graphics.clear();
			graphics.beginFill(0x000000);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			for ( i = 0; i < POWDER_NUM; i++ )
			{
				graphics.beginFill(0xFFFFFF, powders[i].alpha);
				graphics.drawCircle( powders[i].posX, powders[i].posY, 2 );
				graphics.endFill();
			}
			
		}
		
	}
	
}
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
import flash.display.Stage;

/**
 * 渦エネルギー
 */
class Spire {
	
	public	var centerX:int;
	public	var centerY:int;
	
	public	var	rotatePower:Number = 10;
	
	/**
	 * 更新
	 * @param	_x
	 * @param	_y
	 */
	public	function Update(_x:int, _y:int):void 
	{
		centerX = _x;
		centerY = _y;
	}
}

/**
 * 渦エネルギーの犠牲となる粉
 */
class Powder {
	
	public	var posX:Number;
	public	var posY:Number;
	public	var defX:Number;
	public	var defY:Number;
	
	public	var life:int;
	public	var alpha:Number = 0;
	
	public	function Powder(_x:Number, _y:Number, _l:int)
	{
		Set(_x, _y, _l);
	}
	
	public	function Set(_x:Number, _y:Number, _l:int):void
	{
		posX = _x;
		posY = _y;
		life = _l;
		defX = _x;
		defY = _y;
		alpha = 1;
	}
	
	public	function Move(s:Spire):void 
	{
		var vecX:Number = (posX - s.centerX);
		var vecY:Number = (posY - s.centerY);
		var r:Number = Math.sqrt( vecX * vecX + vecY * vecY );
		var angle:Number = Math.atan2( vecY, vecX ) * 180 / Math.PI;
		var vecX2:Number = Math.cos( (angle + s.rotatePower) * Math.PI / 180 ) * r;
		var vecY2:Number = Math.sin( (angle + s.rotatePower) * Math.PI / 180 ) * r;
		
		vecX = (vecX2 - vecX);
		vecY = (vecY2 - vecY);
		r = Math.sqrt( vecX * vecX + vecY * vecY );
		
		vecX /= r;
		vecY /= r;
		
		posX += vecX * 5;
		posY += vecY * 5;
	
		life--;
		if ( life <= 0 )
		{
			posX = defX;
			posY = defY;
			life = 1000;
			alpha = 0;
		}
		if ( alpha < 1 )	alpha += 0.1;
		
	}
}
