/**
 * Copyright www0z0k ( http://wonderfl.net/user/www0z0k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5yZq
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     *
     * @author www0z0k
     */
    [SWF(width='400', height='300', frameRate='30')]
    public class NewClass extends Sprite {
        private const URL_1:String = 'http://www0z0k.narod.ru/silence.flv';
        private const URL_2:String = 'http://www0z0k.narod.ru/niva_ramp.flv';
        private const NAME_1:String = 'vid 1';
        private const NAME_2:String = 'vid 2';
        public static const BTN_WIDTH:int = 50;
        
        private var player:SimplePlayer;
        private var btnsBG:Sprite;
        public function NewClass():void {
            player = new SimplePlayer();
            addChild(player);
            player.alpha = 0;
            player.addEventListener(player.TYPE, onVideoFinished);
            
            btnsBG = new Sprite();
            addChild(btnsBG);
            var btn1:TextBtn = new TextBtn(NAME_1, URL_1);
            btn1.addEventListener(ClickEvent.TYPE, btnClicked);
            var btn2:TextBtn = new TextBtn(NAME_2, URL_2);
            btn2.addEventListener(ClickEvent.TYPE, btnClicked);            
            btnsBG.addChild(btn1);
            btnsBG.addChild(btn2);
            btn2.y = 30;
        }        
        
        private function onVideoFinished(e:Event):void {
            btnsBG.alpha = 1;
            player.alpha = 0;
        }
        
        private function btnClicked(e:ClickEvent):void {
            btnsBG.alpha = 0;
            player.alpha = 1;
            player.url = e.url;
        }
    }    
}    

    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.media.Video;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.events.Event;
    import flash.text.TextField;
    class SimplePlayer extends Sprite{
        private var nc:NetConnection;
        private var ns:NetStream;
        private var vid:Video;
        private var _url:String;
        public const TYPE:String = 'finished';
        public function SimplePlayer() {
            nc = new NetConnection();
            nc.addEventListener(NetStatusEvent.NET_STATUS, onStatus);
            nc.connect(null);
            vid = new Video();
            addChild(vid);
        }
        
        private function onStatus(e:NetStatusEvent):void {
            //trace(e.info.code);
            if (e.info.code == 'NetStream.Play.Stop') {
                dispatchEvent(new Event(TYPE));
            }
        }
        
        public function set url(value:String):void {
            _url = value;
            ns = new NetStream(nc);
            ns.addEventListener(NetStatusEvent.NET_STATUS, onStatus);
            ns.client = new Object();
            ns.client.onMetaData = function(info:Object):void { };
            vid.attachNetStream(ns);
            ns.play(_url);
        }
        
    }    
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextFieldAutoSize;
    class TextBtn extends Sprite{
        private var tf:TextField;
        private var url:String;
        public function TextBtn(caption:String, _url:String) {
            tf = new TextField();
            addChild(tf);
            tf.selectable = false;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = caption;
            url = _url;
            tf.background = true;
            tf.backgroundColor = 0x0000ff;
            addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onClick(e:MouseEvent):void {
            dispatchEvent(new ClickEvent(url));
        }
        
    }    
    
    
    import flash.events.Event;
    
    /**
     * ...
     * @author www0z0k
     */
    class ClickEvent extends Event 
    {
        public static const TYPE:String = 'clicked';
        public var url: String;
        public function ClickEvent(_url:String, bubbles:Boolean=false, cancelable:Boolean=false) 
        { 
            super(TYPE, bubbles, cancelable);
            url = _url;
        } 
        
        public override function clone():Event 
        { 
            return new ClickEvent(url, bubbles, cancelable);
        } 
        
        public override function toString():String 
        { 
            return formatToString("ClickEvent", "type", "url", "bubbles", "cancelable", "eventPhase"); 
        }
        
    }
