/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ySm
 */

package {
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            skin = new BitmapData(256,256, false, 0x808080);
            var i:int; var k:int;
            var r:Rectangle; r = new Rectangle(0,0, 32,32);
            
            for (i = 0; i < 8; i++)
            {for (k = 0; k < 5; k++)
            {
              r.x = k * 64 + (i % 2)*32;
              r.y = i * 32;
              skin.fillRect(r, 0x203080);   
            } }
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public var mat:Matrix = new Matrix();
        public var mat3:Matrix3D = new Matrix3D();
        public var vec:Vector.<Number> = new Vector.<Number>(16,false);
        
        public var gt:int = 0;
        
        public var skin:BitmapData;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            
            var ang:Number;
            ang = gt *0.01;
            
            mat3.identity();
            mat3.appendRotation(ang*(180/3.1415), Vector3D.Y_AXIS);
            mat3.appendRotation(30, Vector3D.X_AXIS); //note -- 30 is a guess
            mat3.appendTranslation(235,235,0);
            mat3.appendTranslation(0,128,0);
            vec = mat3.rawData;


            ang = -ang;
            mat.identity();
            mat.a = Math.cos(ang);
            mat.b = -Math.sin(ang)*0.5; 
            mat.c = Math.sin(ang);
            mat.d = Math.cos(ang)*0.5;
            mat.tx = Math.sin(ang) *- 128 + Math.cos(ang)*-128;
            mat.ty = Math.cos(ang) * -64  + Math.sin(ang)* 64; 
            mat.scale(2,2); 
            mat.ty += 465*0.5;
            mat.tx += 465*0.5; 
            mat.ty += 128;
            
            graphics.beginBitmapFill(skin, mat, false, false);
            graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            
            var w:Number; w= 512;
            drawLine(-w,0,0, w,0,0);
            drawLine(0,0,-w, 0,0,w);
           // drawLine(w,0,-w, w,0,w);
           // drawLine(-w,0,w, w,0,w);
            
            graphics.beginFill(0x8080ff, 1);
            graphics.drawRect(0,0, 465, 256);
            graphics.endFill();
            
            drawSphere(64,-32,0, 32);
            drawSphere(64,-24,64+32, 24);
            drawSphere(0,-16,64, 16);
            
            
            gt += 1;
            
        }//onenter

        public function drawSphere(x0:Number, y0:Number, z0:Number, r:Number=32):void
        {
            var ax:Number, ay:Number;
            ax = vec[0] * x0 + vec[4]*y0 + vec[8] * z0 + vec[12];
            ay = vec[1] * x0 + vec[5]*y0 + vec[9] * z0 + vec[13];
            graphics.drawCircle(ax,ay, r);
        }//drawsphere

        
        public function drawLine(x0:Number, y0:Number, z0:Number,
        x1:Number, y1:Number, z1:Number):void
        {
            var ax:Number, ay:Number, az:Number;
            ax = vec[0] * x0 + vec[4]*y0 + vec[8] * z0 + vec[12];
            ay = vec[1] * x0 + vec[5]*y0 + vec[9] * z0 + vec[13];
            //az = vec[2] * x0 + vec[6]*y1 + vec[10] * z1 + vec[14];
            graphics.moveTo(ax,ay);
            ax = vec[0] * x1 + vec[4]*y1 + vec[8] * z1 + vec[12];
            ay = vec[1] * x1 + vec[5]*y1 + vec[9] * z1 + vec[13];
            graphics.lineTo(ax,ay);
            
        }//drawline
        
        
        
    }//claasend
    
    
}