/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5yOy
 */

// forked from wh0's whatever 9
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.utils.*;
    public class FlashTest extends Sprite {
        
        // see pixel bender assembly at bottom
        private static const POLAR:ByteArray = ba(249, [-1593769472,810831,1970553711,1869767680,-1560279949,1919090849,33816832,258241396,10551553,33556575,1885953842,10617188,1701208437,1819563617,1819632896,1070141403,-1593769726,291689,2053439650,23356774,1635085428,1449225333,1694516096,41217,33685507,1937205618,1811980802,1684366945,1970041942,1634497893,0,0,1901312,-2147483584,393984,-2147483648,2360064,1090519056,328448,-1056833520,1901312,822214832,197376,537067584,328448,268632128,66304,-2147286912,66304,-2147286848,197376,-1056833456,525056,-2147352512,3145984,-251461616,1901824,-2147352512,722176,-2147286976,196864,268763136,0]);
        private static const ORIGIN:Point = new Point();
        
        private static const QE:int = 128;
        private static const AB:Number = QE / 6;
        private static const RB:Number = QE / 3;
        private static const OCTAVES:uint = 2;
        private static const THRESHOLD:int = 140;
        
        private var current:DisplayObject;
        
        public function FlashTest() {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            
            click(null);
            stage.addEventListener(MouseEvent.CLICK, click);
        }
        
        private function click(e:Event):void {
            if (current) removeChild(current);
            current = circle();
            current.x = 232;
            current.y = 232;
            addChild(current);
        }
        
        // make four copies for complete circle
        private function circle():DisplayObject {
            var s:Sprite = new Sprite();
            var e:BitmapData = br();
            for (var r:int = 0; r < 360; r += 90) {
                var b:Bitmap = new Bitmap(e);
                b.rotation = r;
                s.addChild(b);
            }
            return s;
        }
        
        // render one quadrant
        private function br():BitmapData {
            // these offsets prevent the center from being always the same
            var o:Array = new Array(OCTAVES);
            for (var i:int = 0; i < OCTAVES; i++) o[i] = new Point(
                0,
                Math.random() * RB
            );
            
            // start with something random
            var p:BitmapData = new BitmapData(QE, QE, false, 0x000000);
            p.perlinNoise(AB, RB, OCTAVES, Math.random() * 0x10000, true, true, 1, false, o);
            
            // remap from polar coordinates and swirl
            var wd:Number = Math.pow(3 * Math.random() - 1.5, 3);
            var wi:Number = Math.pow(2 * Math.random() - 1, 5);
            var sf:ShaderFilter = new ShaderFilter(new Shader(POLAR));
            sf.shader.data.size.value = [QE as Number];
            sf.shader.data.swirl.value = [wd, wi];
            var q:BitmapData = new BitmapData(QE, QE, true, 0x00000000);
            q.applyFilter(p, p.rect, ORIGIN, sf);
            
            // color it
            var r:uint = Math.random() * 0x600;
            var c:uint = hue(r);
            gradientMap(q, [0x000000, c, 0xffffff], [255, 255, 255], [0, 124, 128]);
            return q;
        }
        
        private static const TWO_FIVE_SIX:Matrix = function ():Matrix { var m:Matrix = new Matrix(); m.createGradientBox(256, 1); return m;}();
        private static function gradientMap(bd:BitmapData, colors:Array, alphas:Array, ratios:Array, spreadMethod:String=SpreadMethod.PAD, interpolationMethod:String=InterpolationMethod.LINEAR_RGB):void {
            var sh:Shape = new Shape();
            sh.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, TWO_FIVE_SIX, spreadMethod, interpolationMethod);
            sh.graphics.drawRect(0, 0, 256, 1);
            var row:BitmapData = new BitmapData(256, 1, true, 0x00000000);
            row.draw(sh);
            var v:Vector.<uint> = row.getVector(row.rect); // %%%
            var map:Array = new Array(256);
            for (var i:int = 0; i < 256; i++) map[i] = v[i];
            bd.paletteMap(bd, bd.rect, ORIGIN, map);
        }
        
        private static function hue(r:uint):uint {
            return (
                0x010000 * Math.max(0, Math.min(0xff, Math.abs(r - 0x300) - 0x100)) +
                0x000100 * Math.max(0, Math.min(0xff, 0x200 - Math.abs(r - 0x200))) +
                           Math.max(0, Math.min(0xff, 0x200 - Math.abs(r - 0x400)))
            );
        }
        
        private static function ba(l:int, d:Array):ByteArray {
            var r:ByteArray = new ByteArray();
            for each (var w:int in d)
                r.writeInt(w);
            r.length = l;
            return r;
        }
        
    }
}

/*
parameter "_OutCoord", float2, f0.rg, in
texture "src", t0
parameter "dst", float4, f1, out

parameter "_pi_2", float, f2.r, in
meta "defaultValue", 1.5707963267948966192313216916398

parameter "size", float, f2.g, in
meta "defaultValue", 256

parameter "swirl", float2, f2.ba, in
meta "defaultValue", 0, 0

; put angle in f3.r
mov f3.r, f0.g
atan2 f3.r, f0.r

; put the radius in f3.g
len f3.g, f0.rg

; scale to 0..1
div f3.rg, f2.rg

; add swirliness
mov f3.ba, f2.ba
mul f3.b, f3.g
div f3.a, f3.g
add f3.r, f3.b
add f3.r, f3.a

; scale to 0..size
mul f3.rg, f2.gg

; wrap
mod f3.r, f2.g

; sample it
texn f1, f3.rg, t0

; knock out the outside
mov f5.r, f2.g
step f5.r, f3.g
mul f1.a, f5.r
*/