/**
 * Copyright kto12 ( http://wonderfl.net/user/kto12 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5y53
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite 
    {
        
        private var tf:TextField = new TextField();
        private var weightArr:Array = [0.4, 0.3, 0.2, 0.1];
        private var criteriaArr:Array = new Array();
        private var freqArr:Array = new Array();
        //total number of iteration to run the test
        private var totalIter:int = 1000;
        
        public function FlashTest() {
            // setup tf
            tf.text = "hello World";
            tf.width = 400;
            tf.height = 400;
            tf.border = true;
            addChild(tf);
            tf.addEventListener(MouseEvent.CLICK, function():void{runTest();printFreq();});
            tf.addEventListener(MouseEvent.MOUSE_OUT, function():void{tf.text="";});
            
            //init for mtd 3
            initCriteriaArr();
            
            //get results
            runTest();
            
            //print out results
            //printOut(calcFreq().toString());
            printFreq();
        }//end of constructor
        
        private function runTest():void
        {
            freqArr = new Array();
            for(var i:int = 0; i < totalIter; i++)
            {
                recordFreq(getHit());
            }
        }
        //calc hit according to weight
        private function getHit():int
        {
            return mtd3();
        }
        private function mtd1():int
        {
            var id:int;
            
            id = Math.floor(Math.random()*3);
            
            return id;
        }
        private function mtd2():int
        {
            var iter:int = weightArr.length - 1;
            var id:int;
            var randNum:Number = Math.random();
            
            if(randNum < weightArr[0])
            {
                id = 0;
            }
            else if(randNum < weightArr[1])
            {
                id = 1;
            }
            else
            {
                id = 2;
            }
            
            return id;
        }
        private function mtd3():int
        {
            var iter:int = criteriaArr.length;
            var id:int;
            var randNum:Number = Math.random();
            var hit:Boolean = false;
            
            for(var i:int = 0; i < iter; i++)
            {
                if(randNum < criteriaArr[i])
                {
                    id = i;
                    hit = true;
                    break;
                }
            }
            
            if(!hit)
            {
                id = iter;
            }
            
            return id;
        }
        private function initCriteriaArr():void
        {
            var iter:int = weightArr.length - 1;
            var value:Number = 0;
            
            for(var i:int = 0; i < iter; i++)
            {
                value += weightArr[i];
                criteriaArr[i] = value;
            }
            printOut("criteriaArr " + criteriaArr.toString());
        }
        //calc freq
        private function recordFreq(id:int):void
        {
            if(freqArr[id] == null)
            {
                freqArr[id] = 1;
            }
            else
                freqArr[id]++;
        }
        private function calcFreq():Array
        {
            var arr:Array = new Array();
            var iter:int = freqArr.length;
            
            for(var i:int = 0; i < iter; i++)
            {
                if(freqArr[i] == null)
                {
                    arr[i] = 0;
                }
                else
                    arr[i] = freqArr[i]/totalIter;
            }
            return arr;    
        }
        //print to tf
        private function printOut(input:String):void
        {
            tf.appendText("\n"+input);
        }
        private function printFreq():void
        {
            var iter:int = freqArr.length;
            var arr:Array = calcFreq();
            
            for(var i:int = 0; i < iter; i++)
            {
                tf.appendText("\n" + "[" + i + "] - " + arr[i]*100);
            }
            tf.appendText("\n");
        }
    }//end of class
}