/**
 * Copyright Co-Tam ( http://wonderfl.net/user/Co-Tam )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5xDU
 */

package {
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="465",height="465",backgroundColor="0x000000")]
    public class Main extends Sprite {
        private var bmpData:BitmapData;
        private var sprite:Sprite;
        private var matrix:Matrix;
        
        public function Main() {
            // BitmapDataを表示リストに追加
            bmpData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
            addChild(new Bitmap(bmpData));
            
            //グラフィックの作成
            sprite = newFig(232, 232, 40, 0xFFFFFF);
            //Matrixをインスタンス化
            matrix = new Matrix();
            //イベント登録
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
        }
        
        private function enterFrameHandler(in_e:Event):void {
            //Matrix
            matrix.identity();
            var s:Number = Math.random()*2;
            matrix.scale(s, s);
            matrix.rotate(Math.PI*Math.random());
            matrix.translate(mouseX, mouseY);
            //BitMapへ描画
            bmpData.draw(sprite, matrix);
        }
        
        private function mouseDownHandler(in_e:MouseEvent):void{
            bmpData.fillRect(bmpData.rect , 0xFFFFFF);            
        }

        
        private function newFig( cx:Number, cy:Number, size:Number, col:uint):Sprite{
            var shape:Sprite = new Sprite();
            shape.graphics.lineStyle(0, 0x000000, 0.3);
            shape.graphics.beginFill(col);
            shape.graphics.drawCircle(cx, cy, size*0.5);
            shape.graphics.drawCircle(cx, cy, size*0.4);
            
            //var w:Number = size*0.6;
            //var h:Number = size *0.15;
            //shape.graphics.drawRect(cx - w/2, cy - h/2, w, h);
            shape.graphics.endFill();
            return shape;
        }
    }
}