/**
 * Copyright asahiufo ( http://wonderfl.net/user/asahiufo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5x2w
 */

package
{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.utils.getTimer;
	
	public class FlashTest extends Sprite
	{
		private var _tracer:TextField;
		
		public function FlashTest()
		{
			_tracer = new TextField();
			_tracer.autoSize = TextFieldAutoSize.LEFT;
			addChild(_tracer);
			
			_test(100);
			_test(1000);
			_test(10000);
		}
		
		private function _test(times:uint):void
		{
			var time:int;
			
			_tracer.appendText("===== " + times + "回 =====\n");
			
			// Vector fixed = true
			time = getTimer();
			_vectorTest1(times);
			_tracer.appendText("    Vector fixed = true: " + (getTimer() - time) + "\n");
			// Vector fixed = false
			time = getTimer();
			_vectorTest2(times);
			_tracer.appendText("    Vector fixed = false: " + (getTimer() - time) + "\n");
		}
		
		private function _vectorTest1(times:uint):void
		{
			var list:Vector.<int> = new Vector.<int>(times, true);
			for (var i:int = 0; i < times; i++)
			{
				list[i] = i;
				list.indexOf(i);
			}
		}
		private function _vectorTest2(times:uint):void
		{
			var list:Vector.<int> = new Vector.<int>(times, false);
			for (var i:int = 0; i < times; i++)
			{
				list[i] = i;
				list.indexOf(i);
			}
		}
	}
}