/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5wWc
 */

package
{ 
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.media.Camera;
    import flash.media.Video;
  [SWF(width='465',height='465',backgroundColor='0x00',frameRate='30')]   
    public class WonCam extends Sprite 
    {
    	private var _video:Video;
    	private var _camera:Camera;
    	private var _bmd:BitmapData;
    	
        public function WonCam() 
        { 
        	init();
        }
        
        private function init():void
        {
        	_camera = Camera.getCamera();
        	_video = new Video(120,120);
        	_video.attachCamera(_camera);
        	_bmd = new BitmapData(120,120,false,0x00);
        	_bmd.draw(_video,null,null,null,null);
        	
        	for(var cy:int=0; cy<8; cy++)
        	{
	        	for(var cx:int=0; cx<3; cx++)
	        	{
	        		var unit:Unit = addChild(new Unit(_bmd))as Unit;
	        		
	        		if(cy%2==0)
	        		{
	        			unit.x = cx*(unit.width+unit.width/2);
	        			unit.y = cy/2*unit.height;
	        		}
	        		else
	        		{
	        			unit.x = cx*(unit.width+unit.width/2)+unit.width/4*3;
	        			unit.y = (cy-1)/2*unit.height + unit.height/2;
	        		}
	        	}
        	}
        	addEventListener(Event.ENTER_FRAME,loop);
        }
        
        private function loop(e:Event):void
        {
        	_bmd.draw(_video,null,null,null,null);
        }
    } 
} 
    import flash.display.Shape; 
    import flash.display.Sprite; 
    import flash.geom.Point; 
    import flash.display.BitmapData; 
    import flash.geom.Matrix; 
    
class Unit extends Sprite
{
	private var _list:Array = [];
	
	public function Unit(_src:BitmapData)
	{
		for(var i:int=0; i<6; i++)
		{
			var one:One = addChild(new One(_src))as One;
			if(i%2==1)one.scaleX = -1;
			one.rotation = i*60;
		}
	}
}    
    
class One extends Shape 
{ 
	private var _mtr:Matrix;
	private var _secP:Point = new Point(0,0);
	private var _thiP:Point = new Point(0,0);
	
    public function One(_src:BitmapData) 
    {
    	_secP = Point.polar(80,60*Math.PI/180);
    	_thiP = Point.polar(80,120*Math.PI/180);
    	_mtr = new Matrix();
    	_mtr.translate(-60,0);
    	
    	with(this.graphics)
    	{
    		beginBitmapFill(_src,_mtr);
    		moveTo(0,0);
    		lineTo(_secP.x,_secP.y);
    		lineTo(_thiP.x,_thiP.y);
    		lineTo(0,0);
    		endFill();
    	}
    } 
}
