/**
 * Copyright CZQ ( http://wonderfl.net/user/CZQ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5wPt
 */

package {
    import flash.geom.Rectangle;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    //import com.greensock.TweenMax;
     
    [SWF (width="400", height="400", backgroundColor="0xFFFFFF")]
    public class FlashTest extends Sprite {
        private var time:TimeLine;
        public static const STAGE_WIDTH:int = 400;
        public static const STAGE_HEIGHT:int = 400;
        
        public function FlashTest() {
            // write as3 code here..
            time = new TimeLine();
            time.x = STAGE_WIDTH / 2;
            addChild(time);
            time.setStage(stage);
            time.init();
        }
        
    }
}
import flash.display.*;
import flash.text.*;
import flash.geom.*;
import flash.events.*;

class TimeLine extends Sprite{
    
    private var time:McTimeline;
    private var _events:Array;
    private var _stage:Stage;
    private var _startClickY:Number;
    private var _bg:Sprite;
    
    public function TimeLine(){
        trace(Utils.StartTime.time);
        _bg = new Sprite();
        _bg.graphics.beginFill(0, 0.001);
        _bg.graphics.drawRect( - FlashTest.STAGE_WIDTH / 2 , 0 ,  FlashTest.STAGE_WIDTH , FlashTest.STAGE_HEIGHT);
        _bg.graphics.endFill();
        addChild(_bg);
        time = new McTimeline();
        time.grow(4);
        _events = new Array(null,null,null,null);
        addChild(time);
        time.mouseEnabled = false;
    }
    
    public function init():void{
        _bg.addEventListener(MouseEvent.MOUSE_DOWN,onDragTimeline);
        _stage.addEventListener(MouseEvent.MOUSE_WHEEL,onScrollTimeline);
    }

    
    private function onDragTimeline(e:MouseEvent):void{
        time.startDrag(false, new Rectangle(time.x ,-99999, 0, 999999));
        _startClickY = time.y;
        _stage.addEventListener(MouseEvent.MOUSE_UP, onStopDragTimeline);
        _stage.addEventListener(MouseEvent.MOUSE_OUT,onMoveOut);
    }
        
    private function onStopDragTimeline(e:MouseEvent):void{
        time.stopDrag();
        _stage.removeEventListener(MouseEvent.MOUSE_UP, onStopDragTimeline);
        _stage.removeEventListener(MouseEvent.MOUSE_OUT, onMoveOut);
        var my:Number = time.mouseY;
        if (Math.abs(time.y - _startClickY) < 10 && my < time.height && my > 0) {
            //check the mouseY in which part of timeline
            var count:int = Math.round(my / McTimeline.LONG);
            trace(count);
            var b:EventBlock = new EventBlock();
            time.addChild(b);
            if (time.mouseX > 0) {
                b.isLeft = true;
            }else {
                b.isLeft = false;
            }
            b.time = Utils.getTime(count) ;
            b.update();
            b.x = 0;
             
            if (count > _events.length) {
                time.grow(1,count);
            }else {
                if (_events[count] == null) {
                    _events[count] = b;
                }else {
                    time.grow(1, count);
                    _events.splice(count, 0, b);
                }
            }
            updateAllEventBlock();
        }
    }
    
    private function updateAllEventBlock():void {
        for (var i:int = 0; i < _events.length; i++) {
            if (_events[i] != null) {
                (_events[i] as EventBlock).y = i * McTimeline.LONG;
                (_events[i] as EventBlock).time = Utils.getTime(i) ;
            }
        }
    }
    
    private function onMoveOut(e:MouseEvent):void {
         time.stopDrag();
        _stage.removeEventListener(MouseEvent.MOUSE_UP, onStopDragTimeline);
        _stage.removeEventListener(MouseEvent.MOUSE_OUT,onMoveOut);
    }
    
    private function onScrollTimeline(e:MouseEvent):void{
        if (e.delta > 0){
            time.y +=100;
        }else{
            time.y += -100;
        }
    }
    
    public function setStage(e:Stage):void{
        this._stage = e;
    }

}

class McTimeline extends Sprite{
    private var _long:int;
    private var _color:Array;
    
    public static const LONG:int = 70;
    public static const TIMELINE_WIDTH:int = 4;
    public function McTimeline() {
        _long = 0;
        _color = new Array();
    }
    
    public function grow( long:int, at:int = -1):void {
        if (at < 0 || at > _color.length) {
            at = _color.length;
        }
        for (var i:int = 0; i < long; i++) {
            var c:int = Math.random() * 16777215;
            _color.splice(at, 0, c);
        }
        update();
    }
    
    public function short( long:int, at:int = -1):void {
        if (at < 0) {
            at = _color.length - long;
        }
        for (var i:int = 0; i < long; i++) {       
            if (_color.length > 0)
                _color.splice(at, 1);
        }
        update();
    }
    
    public function update():void {
        var l:int = _color.length;
        var g:Graphics;
        var c:int;
        g = this.graphics;
        g.clear();
        for (var i:int = 0; i < l; i++) {       
            c = _color[i];
            g.lineStyle(TIMELINE_WIDTH,c);
            g.lineTo(0, (i + 1) * LONG);
        }
    }

}

class EventBlock extends Sprite{
    private var _mc:Sprite;
    private var _tf:TextField;
    private var _timeF:TextField;
    private var _branchWidth:int = 50;
    private var _title:String = "Work";
    private var _direction:int;//+1 or -1

    public function EventBlock(){
        _mc = new Sprite();
        _tf = new TextField();
        _timeF = new TextField();
        _timeF.type = TextFieldType.DYNAMIC;
        _timeF.selectable = false;
        _timeF.autoSize = TextFieldAutoSize.LEFT;
        _tf.type = TextFieldType.INPUT;
        _tf.addEventListener(Event.CHANGE, onChangeText);
        _tf.text = _title + int(Math.random()*100).toString();
        var now:Date = new Date();
        addChild(_mc);
        addChild(_tf);
        addChild(_timeF);
    }
    
    public function update():void {
        var g:Graphics = _mc.graphics;
        g.clear();
        g.lineStyle(2, Math.random() * 16000000);
        _tf.autoSize = TextFieldAutoSize.LEFT;
        _tf.y = - (_tf.height / 2);
        _timeF.y = - (_timeF.height / 2);
        g.moveTo( _direction * McTimeline.TIMELINE_WIDTH / 2 , 0);
        g.lineTo( _direction * _branchWidth, 0);
        //margin = 10px
        if (_direction > 0) {
            _timeF.x = _branchWidth + 5;
            _tf.x = _timeF.x + _timeF.width;
            g.lineStyle(4,Math.random() * 16000000);
            g.drawRoundRect( _branchWidth , - (_tf.height / 2) - 10, _branchWidth + _tf.width - 10 , _tf.height + 20 , 10 , 10);
        }else {
            _timeF.x = -( _branchWidth + 5) - _tf.width - _timeF.width;
            _tf.x = _timeF.x + _timeF.width;
            g.lineStyle(4,Math.random() * 16000000);
            g.drawRoundRect( _timeF.x - 5 , - (_tf.height / 2) - 10,  _branchWidth + _tf.width - 10 , _tf.height + 20 , 10 , 10);
        }
    }
    
    private function onChangeText(e:Event):void {
        update();
    }
    
    public function set branchWidth(s:int):void {
        _branchWidth = s;
    }
    
    public function set title(s:String):void {
        _title = s;
        _tf.text = _title;
    }
    
    public function set isLeft(s:Boolean):void {
        _direction = s? +1 : -1;
    }
    
    public function set time(s:String):void {
        _timeF.text = s;
    }
}

class Utils {
    public static var StartTime:Date = new Date();
    public static function getNow():String {
        var now:Date = new Date();
        return  now.getHours() + ":" + now.getMinutes();
    }
    
    public static function getTime(s:int):String {
        var t:Date = new Date();
        t.setTime(StartTime.time + s * 1800 * 1000);
        return  t.getHours() + ":" + t.getMinutes();
    }
}