/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5w2Z
 */

// forked from ProjectNya's Happy Birthday ! to clockmaker
////////////////////////////////////////////////////////////////////////////////
// Happy Birthday ! to clockmaker
//
// [PV3D] ドットひよこ
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1216
// [AS3.0] DetectPixelsクラスに挑戦！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1135
// [AS3.0] MiniVisualizerクラスだ！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1344
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.PixelSnapping;
    import flash.display.BlendMode;
    import flash.geom.Matrix;
    import flash.events.Event;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.effects.*;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var sw:uint = 465;
        private var sh:uint = 465;
        private var cx:uint = 232;
        private var cy:uint = 232;
        private static var cameraHeight:Number = 300;
        private static var radius:uint = 300;
        private var effect:BitmapEffectLayer;
        private var pixels:Pixels;
        private var bitmapData:BitmapData;
        private var matrix:Matrix;
        private static var bw:uint = 465;
        private static var bh:uint = 465;
        private static var scale:Number = 16;
        private var angle:Number = 90;
        private var map:Map;
        private var loader:PhotoLoader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        //アップロードした画像のパス
        private static var mapPath:String = "1/1b/1bf4/1bf4e977d87d173178432a1d655a7ff904414400";
        private var visualizer:SoundVisualizer;
        private var se:SoundEffect;
        private static var bgmPath:String = "http://www.project-nya.jp/images/bgm/project.mp3";

        public function Main() {
            //Wonderfl.capture_delay(12);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var wondflcolor:WonderflColor = new WonderflColor(465, 465);
            addChild(wondflcolor);
            scene = new Scene3D();
            viewport = new Viewport3D(0, 0, true, false);
            camera = new Camera3D();
            renderer = new BasicRenderEngine();
            setup();
            initialize();
            addChild(viewport);
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
            //
            var title:Label = new Label(200, 40, 36, Label.CENTER);
            addChild(title);
            title.x = 132;
            title.y  =2;
            title.textColor = 0xFFFFFF;
            title.text = "!";
            var subtitle:Label = new Label(200, 20, 14, Label.CENTER);
            addChild(subtitle);
            subtitle.x = 132;
            subtitle.y  =52;
            subtitle.textColor = 0xFFFFFF;
            subtitle.text = " ";
            //
            visualizer = new SoundVisualizer(16, 0xFFFFFF);
            addChild(visualizer);
            visualizer.x = 420;
            visualizer.y = 450;
            se = new SoundEffect();
            se.addEventListener(Event.COMPLETE, loaded, false, 0, true);
            se.load(bgmPath);
        }
        private function setup():void {
            viewport.interactive = true;
            camera.x = 0;
            camera.y = cameraHeight;
            camera.z = - radius;
            camera.zoom = 25;
            camera.focus = 20;
            camera.target = DisplayObject3D.ZERO;
        }
        private function initialize():void {
            setEffect();
            map = new Map(pixels);
            //
            loader = new PhotoLoader();
            loader.addEventListener(Event.INIT, complete, false, 0, true);
            //loader.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(basePath + mapPath, true);
        }
        private function complete(evt:Event):void {
            var bitmap:Bitmap = Bitmap(loader.content);
            map.setup(bitmap.bitmapData);
        }
        private function setEffect():void {
            effect = new BitmapEffectLayer(viewport, bw, bh);
            effect.addEffect(new BitmapColorEffect(1, 1, 1, 0.6));
            viewport.containerSprite.addLayer(effect);
            pixels = new Pixels(effect);
            scene.addChild(pixels);
            bitmapData = new BitmapData(bw/scale, bh/scale, false, 0xFF000000);
            var bitmap:Bitmap = new Bitmap(bitmapData, PixelSnapping.NEVER, true);
            bitmap.scaleX = bitmap.scaleY = scale;
            bitmap.blendMode = BlendMode.ADD;
            addChild(bitmap);
            matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
        }
        private function render(evt:Event):void {
            sparkle();
            angle ++;
            camera.x = Math.cos(angle*Math.PI/180)*radius;
            camera.y = cameraHeight;
            camera.z = Math.sin(angle*Math.PI/180)*radius;
            renderer.renderScene(scene, camera, viewport);
        }
        private function sparkle():void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0xFF000000);
            bitmapData.draw(viewport, matrix);
            bitmapData.unlock();
        }
        private function loaded(evt:Event):void {
            se.removeEventListener(Event.COMPLETE, loaded);
            visualizer.start();
            se.play(0.5, true);
        }

    }

}


//////////////////////////////////////////////////
// Mapクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.*;
import frocessing.color.ColorHSV;

class Map {
    private var detection:DetectPixels;
    private static var accuracy:uint = 2;
    private var threshold:uint = 0xFF808080;
    private var pixels:Pixels;
    private static var sw:uint = 400;
    private static var sh:uint = 200;
    private static var colors:Array;
    private var layers:Array;

    public function Map(p:Pixels) {
        pixels = p;
        init();
    }

    private function init():void {
        detection = new DetectPixels(accuracy);
    }
    public function setup(bitmapData:BitmapData):void {
        detection.search(bitmapData, bitmapData.rect, threshold);
        var map:Array = detection.pixels();
        //レイヤー指定
        layers = [map, map, map];
        //色相指定
        var hsv:ColorHSV = new ColorHSV(50, 1);
        for (var n:uint = 0; n < layers.length; n++) {
            //色相変化
            hsv.h = 180 + 20/layers.length*(layers.length - n);
            hsv.s = 1/layers.length*(layers.length - n);
            var color:uint = 0xFF << 24 | hsv.value;
            drawLayer(n, color);
        }
    }
    private function drawLayer(id:uint, color:uint):void {
        var map:Array = layers[id];
        for (var n:uint = 0; n < map.length; n++) {
            var dx:Number = sw/2 - map[n].x;
            var dy:Number = 8*id - 8*uint(layers.length/2);
            var dz:Number = map[n].y - sh/2;
            pixels.addPixel3D(new Pixel3D(color, dx, dy, dz));
        }
    }

}


//////////////////////////////////////////////////
// DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF):void {
        bd = t;
        rect = r;
        threshold = th;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x;
                    var py:int = y*accuracy + rect.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.display.Bitmap;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if (smoothing) content.smoothing = true;
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }

}


//////////////////////////////////////////////////
// SoundVisualizerクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.media.SoundMixer;
import flash.utils.ByteArray;

class SoundVisualizer extends Sprite {
    private var max:uint;
    private var color:uint;
    private static var bw:uint = 4;
    private static var bh:uint = 16;
    private static var xoffset:uint = 1;
    private static var yoffset:uint = 2;
    private var indicators:Array;
    private var timer:Timer;
    private static var interval:uint = 25;
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint;

    public function SoundVisualizer(m:uint, c:uint = 0x000000) {
        max = m;
        color = c;
        factors = uint(channels/max);
        draw();
    }

    private function draw():void {
        indicators = new Array();
        for (var n:uint = 0; n < max; n++) {
            var indicator:SoundIndicator = new SoundIndicator(bw, bh, color);
            addChild(indicator);
            indicator.x = - uint((bw + xoffset)*max/2) + (bw + xoffset)*n;
            indicator.y = uint(bh/2);
            indicators.push(indicator);
        }
        byteArray = new ByteArray();
    }
    public function start():void {
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, update, false, 0, true);
        timer.start();
    }
    public function stop():void {
        if (timer) {
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER, update);
        }
        reset();
    }
    public function update(evt:TimerEvent):void {
        try {
            SoundMixer.computeSpectrum(byteArray, true, factors);
        } catch (err:Error) {
            trace(err.message);
        }
        for (var n:uint = 0; n < max; n++) {
            var indicator:SoundIndicator = indicators[n];
            byteArray.position = factors*4*n;
            var percent:Number = byteArray.readFloat();
            indicator.update(percent);
        }
    }
    public function reset():void {
        for (var n:uint = 0; n < max; n++) {
            var indicator:SoundIndicator = indicators[n];
            indicator.reset();
        }
    }

}


//////////////////////////////////////////////////
// SoundIndicatorクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;

class SoundIndicator extends Sprite {
    private var bar:Shape;
    private var color:uint;
    private var _width:uint;
    private var _height:uint;

    public function SoundIndicator(w:uint, h:uint, c:uint = 0x000000) {
        _width = w;
        _height = h;
        color = c;
        draw();
        reset();
    }

    private function draw():void {
        var base:Shape = new Shape();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, _width, 1);
        base.graphics.endFill();
        //
        bar = new Shape();
        addChild(bar);
        bar.graphics.beginFill(color);
        bar.graphics.drawRect(0, 0, _width, - _height);
        bar.graphics.endFill();
    }
    public function update(percent:Number):void {
        bar.scaleY = percent;
        bar.height = uint(bar.height);
    }
    public function reset():void {
        bar.scaleY = 0;
    }

}


//////////////////////////////////////////////////
// SoundEffectクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundTransform;
import flash.net.URLRequest;
import flash.media.SoundLoaderContext;

class SoundEffect extends EventDispatcher {
    public var id:String;
    private var sound:Sound;
    private var channel:SoundChannel;
    private var level:Number;
    private var volume:Number = 1;
    private var looping:Boolean = false;
    public var initialized:Boolean = false;
    public var playing:Boolean = false;

    public function SoundEffect() {
    }

    public function init(Snd:Class):void {
        sound = new Snd();
    }
    public function load(filePath:String):void {
        sound = new Sound();
        sound.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
        try {
            sound.load(new URLRequest(filePath), new SoundLoaderContext(10, true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        initialized = true;
        channel = sound.play();
        channel.stop();
        dispatchEvent(evt);
    }
    public function play(lv:Number, loop:Boolean = false):void {
        playing = true;
        if (channel) channel.stop();
        level = lv;
        looping = loop;
        channel = sound.play();
        var transform:SoundTransform = channel.soundTransform;
        transform.volume = level*volume;
        channel.soundTransform = transform;
        if (looping) {
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
        }
    }
    public function stop():void {
        playing = false;
        if (channel) {
            channel.stop();
            channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        }
    }
    public function setVolume(v:Number):void {
        volume = v;
        if (channel) {
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        }
    }
    private function complete(evt:Event):void {
        channel.removeEventListener(Event.SOUND_COMPLETE, complete);
        if (looping) {
            channel = sound.play(0);
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            var transform:SoundTransform = channel.soundTransform;
            transform.volume = level*volume;
            channel.soundTransform = transform;
        } else {
            playing = false;
        }
    }

}


//////////////////////////////////////////////////
// WonderflColorクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class WonderflColor extends Sprite {
    private var color1:uint = 0x00AAE4;
    private var color2:uint = 0x0069A0;

    public function WonderflColor(w:uint, h:uint) {
        draw(w, h);
    }

    private function draw(w:uint, h:uint):void {
        var colors:Array = [color1, color2];
        var alphas:Array = [1, 1];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*1.5, h*1.5, 0, -w*0.25, -h*0.25);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawRect(0, 0, w, h);
        graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.display.BlendMode;
import flash.filters.DropShadowFilter;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
        blendMode = BlendMode.LAYER;
        var shade:DropShadowFilter = new DropShadowFilter(4, 90, 0x000000, 0.3, 8, 8, 2, 3, false, false);
        filters = [shade];
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
