/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5vUN
 */

package
{
    // Import External Classes
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='60')]
    
    /**
     * Name           : Main
     * Coded By       : Matt Wakeling
     * Date           : 08th May 2012
     * Description    : Main Class for the Application.
     *                  ActionScript 3 Tree Roots - based on code from Roger Bagula and Paul Bourke.
     *
     * @author Matt Wakeling
     */
    public class Main extends Sprite
    {
        private var $Resolution:int = 4;
        
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }
        
        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else
                addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage, false, 0, true);
        }
        
        // InitialiseStage Method
        private function InitialiseStage(evtInitialiseStage:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000, 1);
            this.graphics.drawRect(stage.x, stage.y, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
            
            initTreeRoots();
        
            //addChild(new Stats());
        }
        
        // initCliffordAttractor Method
        private function initTreeRoots():void
        {
            var scrTreeRoots:TreeRoots = new TreeRoots(stage.stageWidth, stage.stageHeight, $Resolution);
            scrTreeRoots.cacheAsBitmap = true;
            scrTreeRoots.scaleX = 1 / $Resolution;
            scrTreeRoots.scaleY = 1 / $Resolution;
            
            addChild(scrTreeRoots);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import frocessing.color.ColorHSV;

class TreeRoots extends Sprite
{
    private var $Width:int = 0;
    private var $Height:int = 0;
    private var $Scale:int = 10;
    
    private var $Points:int     = 10000;
    private var $Iterations:int = 10000000;
    
    private var $FrameCounter:int = 0;
    
    private var $BitmapData:BitmapData;
    private var $Bitmap:Bitmap;
    
    private var $XCoord1:Number = 0;
    private var $YCoord1:Number = 0;
    
    private var $XCoord2:Number = 0;
    private var $YCoord2:Number = 0;
    
    private var $DisplayX:Number = 0;
    private var $DisplayY:Number = 0;
    
    // TreeRoots Constructor
    public function TreeRoots($StageWidth:int, $StageHeight:int, $StageResolution:int)
    {
        
        $Width = $StageWidth * $StageResolution;
        $Height = $StageHeight * $StageResolution;
        
        $BitmapData = new BitmapData($Width, $Height, false, 0x000000);
        $Bitmap = new Bitmap($BitmapData);
        
        addChild($Bitmap);
        
        addEventListener(Event.ENTER_FRAME, FrameEvent);
    }
    
    // FrameEvent Method
    private function FrameEvent($Event:Event):void
    {
        $BitmapData.lock();
            
        for (var i:Number = 0; i < $Points; i++)
        {
            switch (Math.round(Math.random() % 1))
            {
                case 0: 
                    $XCoord1 = $YCoord2 / Math.SQRT2 + 1.5;
                    $YCoord1 = -$XCoord2 / Math.SQRT2 + 1.5;
                    break;
                case 1: 
                    $XCoord1 = -$YCoord2 / Math.SQRT2 + 0.5;
                    $YCoord1 = $XCoord2 / Math.SQRT2 + 0.5;
                    break;
            }
            
            
            switch (Math.round(Math.random() % 1))
            {
                case 0: 
                    $XCoord2 = $XCoord1 - 2;
                    $YCoord2 = $YCoord1;
                    break;
                case 1: 
                    var $Denominator:Number = ($XCoord1 - 2) * ($XCoord1 - 2) + $YCoord1 * $YCoord1;
                    $XCoord2 = ($XCoord1 - 2) / $Denominator;
                    $YCoord2 = $YCoord1 / $Denominator;
                    break;
            }
            
            $DisplayX = ($XCoord2 + 1.0) * ($Width / $Scale) + $Width / 2;
            $DisplayY = ($YCoord2 - 0.75) * ($Height / $Scale) + $Height / 2;
            
            if (($DisplayX >= 0 && $DisplayX <= $Width) && ($DisplayY >= 0 && $DisplayY <= $Height))
            {
                $BitmapData.setPixel($DisplayX, $DisplayY, 0xFFFFFF);
            }
    
            $FrameCounter ++;
        }
        
        $BitmapData.unlock();
        
        if ($FrameCounter++ >= $Iterations)
        {
            removeEventListener(Event.ENTER_FRAME, FrameEvent)            
        }
    }
    
}

