/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5vU5
 */

/**
 * Stardust Particle Engine
 * 
 * Homepage
 * 	http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import idv.cjcat.stardust.common.clocks.SteadyClock;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	[SWF(backgroundColor="#FFFFFF", frameRate=60)]
	
	public class Main extends Sprite {
		
		public static const FLOOR_Y:Number = 400;
		
		private var emitter:CircleEmitter;
		
		public function Main():void {
			emitter = new CircleEmitter(new SteadyClock(0.5));
			var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(this);
			renderer.addEmitter(emitter);
			
			//draw floor
			graphics.lineStyle(0);
			graphics.moveTo(0, FLOOR_Y);
			graphics.lineTo(465, FLOOR_Y);
			
			addEventListener(Event.ENTER_FRAME, mainLoop);
		}
		
		private function mainLoop(e:Event):void {
			emitter.step();
		}
	}
}

//------------------------------------------------------------------------------------------------

import flash.display.Shape;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.CollisionRadius;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.DeathZone;
import idv.cjcat.stardust.twoD.actions.Deflect;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.deflectors.LineDeflector;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.RectZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class CircleEmitter extends Emitter2D {
	
	public function CircleEmitter(clock:Clock) {
		super(clock);
		
		//initializers
		addInitializer(new DisplayObjectClass(Circle));
		addInitializer(new Life(new UniformRandom(200, 0)));
		addInitializer(new Position(new SinglePoint(232.5, 100)));
		addInitializer(new Velocity(new LazySectorZone(2, 2)));
		addInitializer(new Scale(new UniformRandom(1, 0.2)));
		addInitializer(new CollisionRadius(Circle.RADIUS));
		
		//actions
		var gravity:Gravity = new Gravity();
		gravity.addField(new UniformField(0, 0.3));
		
		var deflect:Deflect = new Deflect();
		deflect.addDeflector(new LineDeflector(0, Main.FLOOR_Y, 0, -1));
		
		addAction(gravity);
		addAction(deflect);
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new Move());
		addAction(new ScaleCurve(0, 10));
		addAction(new DeathZone(new RectZone( -50, -50, 565, 565), true));
	}
}

//------------------------------------------------------------------------------------------------

class Circle extends Shape {
	
	public static const RADIUS:Number = 10;
	
	public function Circle() {
		graphics.beginFill(0x808080);
		graphics.drawCircle(0, 0, RADIUS);
	}
}