/**
 * Copyright gurumi ( http://wonderfl.net/user/gurumi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5vEM
 */

// forked from hacker_v4337s3u's forked from: study090531
// forked from shossho's study090531
//練習用として

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#ffffff")]
	
	public class Node extends Sprite
	{
		private var particles:Array;
		private var numParticles:uint = 25;
		private var minDist:Number = 250;
		private var springAmount:Number = .0025;
		
		public function Node()
		{
			init();
		}
		
		private function init():void
		{
			particles = new Array();
			for(var i:uint = 0; i<numParticles; i++)
			{
				var size:Number = Math.random()*7+20;
				var particle:Ball = new Ball(size, Math.random()*0xFFFFFF, 0.5);
				particle.x = Math.random()*stage.stageWidth;
				particle.y = Math.random()*stage.stageHeight;
				particle.vx = Math.random()*6-4;
				particle.vy = Math.random()*6-4;
				particle.mass = size;
				addChild(particle);
				particles.push(particle);
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void
		{
			graphics.clear();
			for(var i:uint = 0; i<numParticles; i++)
			{
				var particle:Ball = particles[i];
				particle.x += particle.vx;
				particle.y += particle.vy;
				if(particle.x > stage.stageWidth)
				{
					particle.x = stage.stageWidth;
					particle.vx *= -1;
				}else if(particle.x < 0){
					particle.x = 0;
					particle.vx *= -1;
				}
				if(particle.y > stage.stageHeight)
				{
					particle.y = stage.stageHeight;
					particle.vy *= -1;
				}else if(particle.y < 0){
					particle.y = 0;
					particle.vy *= -1;
				}
					
			}
			for(i = 0; i<numParticles-1; i++)
			{
				var partA:Ball = particles[i];
				for(var j:uint = i+1; j<numParticles; j++)
				{
					var partB:Ball = particles[j];
					spring(partA, partB);
				}
			}
		}
		
		private function spring(partA:Ball, partB:Ball):void
		{
			var dx:Number = partB.x - partA.x;
			var dy:Number = partB.y - partA.y;
			var dist:Number = Math.sqrt(dx*dx + dy*dy);
			if(dist < minDist)
			{
				graphics.lineStyle(0.8, Math.random()*0xFF0000, 0.7-dist/minDist);
				graphics.moveTo(partA.x, partA.y);
				graphics.lineTo(partB.x, partB.y);
				var ax:Number = dx*springAmount;
				var ay:Number = dy*springAmount;
				partA.vx += ax/partA.mass;
				partA.vy += ay/partA.mass;
				partB.vx -= ax/partB.mass;
				partB.vy -= ay/partB.mass;
			}
                }
	}
}

import flash.display.Sprite;
	
class Ball extends Sprite
{
	public var radius:Number;
	public var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var mass:Number = 0;
	
	public function Ball(radius:Number, color:uint, alpha:Number)
	{
		this.radius = radius;
		this.color = color;
		this.alpha = alpha;
		init()
	}
	
	public function init():void
	{
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}

