/**
 * Copyright mapache ( http://wonderfl.net/user/mapache )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ulR
 */

// forked from ffffine's flash on 2010-8-23
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.utils.getTimer;

    [SWF(width = "465", height = "465", color = "0x000000" , frameRate = "30")];
    
    public class FlashTest extends Sprite {
        
        private var _num:Number = 150;
        private var _rad:Number = 200;
        private var _balls:Array = [];
        private var _addRot:Number = 0;
        private var _canvas:Bitmap;
        private var _bmpData:BitmapData;
        private var _colorTransform:ColorTransform;
            
        public function FlashTest() {
            _bmpData = new BitmapData(465, 465, false,0x000000);
            _canvas = new Bitmap(_bmpData,"auto",true);
            _colorTransform = new ColorTransform(0.97,0.97,0.97);
            addChild(_canvas);
            
            for (var i:int = 0; i < _num; i++) 
            {
                var sh:Shape = new Shape();
                var theta:Number = i * 360 / _num * Math.PI / 180;
                var h:Number = i * 360 / _num;
                var s:Number = 30;
                var v:Number = 99;    
                sh.graphics.beginFill(HSVtoRGB(h,s,v));
                sh.graphics.drawCircle(0, 0, 3);
                sh.graphics.endFill();
                sh.x = _rad * Math.cos(theta) + stage.stageWidth / 2;
                sh.y = _rad * Math.sin(theta) + stage.stageHeight / 2;
                addChild(sh);
                _balls.push(sh);
            }
            stage.addEventListener(Event.ENTER_FRAME, xEnterFrame);
        }
        
        private function xEnterFrame(e:Event):void 
        {
            var myrad:Number = _rad * Math.cos(getTimer() / 2000);
            for (var i:int = 0; i < _num; i++) 
            {
                var theta:Number = (i * 360/_num +(_addRot/2))* Math.PI/180;
                _balls[i].x = myrad * Math.cos(theta) + stage.stageWidth / 2;
                _balls[i].y = myrad * Math.sin(theta) + stage.stageHeight / 2;
                _balls[i].scaleX = _balls[i].scaleY = 1.5 * Math.cos(getTimer() / 2000);
            }
            _bmpData.draw(stage);
            _bmpData.colorTransform(_bmpData.rect, _colorTransform);
            _addRot++;            
        }
        
        private function HSVtoRGB(h:Number, s:Number, v:Number):uint
        {
            var tmpR:uint = 0;
            var tmpG:uint = 0;
            var tmpB:uint = 0;
            
            //0.0～360.0に丸める
            h = (h % 360.0 + 360.0) % 360.0;
        
            //0.0～1.0に丸める
            s = Math.min( Math.max(s, 0.0) , 1.0);
            v = Math.min( Math.max(v, 0.0) , 1.0);
        
            //sが0.0の時はすべての値がvに等しい
            if(s == 0.0)
            {
                tmpR = v;
                tmpG = v;
                tmpB = v;
            }
            else
            {
                var hi:uint = (h / 60) % 6;
                var f:Number = h / 60 - hi;
                var p:Number = v * (1.0 - s);
                var q:Number = v * (1.0 - f * s);
                var t:Number = v * (1.0 - (1.0 - f) * s);
            
                switch(hi)
                {
                    case 0:
                    {
                        tmpR = v * 255;
                        tmpG = t * 255;
                        tmpB = p * 255;
                        break;
                    }
                    case 1:
                    {
                        tmpR = q * 255;
                        tmpG = v * 255;
                        tmpB = p * 255;
                        break;
                    }
                    case 2:
                    {
                        tmpR = p * 255;
                        tmpG = v * 255;
                        tmpB = t * 255;
                        break;
                    }
                    case 3:
                    {
                        tmpR = p * 255;
                        tmpG = q * 255;
                        tmpB = v * 255;
                        break;
                    }
                    case 4:
                    {
                        tmpR = t * 255;
                        tmpG = p * 255;
                        tmpB = v * 255;
                        break;
                    }
                    case 5:
                    {
                        tmpR = v * 255;
                        tmpG = p * 255;
                        tmpB = q * 255;
                        break;
                    }
                    default:
                    {
                        tmpR = 0;
                        tmpG = 0;
                        tmpB = 0;
                        break;
                    }    
                }        
            }
        return tmpR << 16 | tmpG << 8 | tmpB;
        }
    }
}