/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5uSv
 */

package {
    import flash.events.Event;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    public class Triangulation extends Sprite {
        public var array:Array = [];
        
        public var bd:BitmapData;
        public var b:Bitmap;
        public var s:Sprite;
        
        public function Triangulation() {
            bd = new BitmapData(465, 465);
            b = new Bitmap(bd);
            this.addChild(b);
            s = new Sprite();
            
            array.push({x:Math.random() * 465, y:Math.random() * 465});
            array.push({x:Math.random() * 465, y:Math.random() * 465});
            
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0xffffff, 0);
            bg.graphics.drawRect(0, 0, 465, 465);
            bg.graphics.endFill();
            this.addChild(bg);
            
            bg.addEventListener(Event.ENTER_FRAME, triangle);
        }
        
        public function triangle(e:Event):void {
            array.push({x:Math.random() * 465, y:Math.random() * 465});
            
            var dis:Array = [];
            
            for (var i:int = 0; i < array.length; i++) {
                var op:Point = new Point(array[array.length - 1].x, array[array.length - 1].y);
                var tp:Point = new Point(array[i].x, array[i].y);
                
                if (!op.equals(tp)) {
                    dis.push({dis:Point.distance(op, tp), ind:i});
                }
            }
            
            dis.sortOn("dis", Array.NUMERIC|Array.DESCENDING);
            
            s.graphics.beginFill(Math.floor(Math.random() * 0xffffff), 1);
            s.graphics.moveTo(op.x, op.y);
            s.graphics.lineTo(array[dis[dis.length - 1].ind].x, array[dis[dis.length - 1].ind].y);
            s.graphics.lineTo(array[dis[dis.length - 2].ind].x, array[dis[dis.length - 2].ind].y);
            s.graphics.lineTo(op.x, op.y);
            s.graphics.endFill();
            
            bd.draw(s);
        }
    }
}