/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5tSi
 */

// forked from kotobuki's Gainer Basic Example: Analog Input with Scaler
// forked from kotobuki's Gainer Basic Example: Analog Input
// forked from kotobuki's Gainer Basic Example: SignalScope
// A very basic example on how to divide an analog input
// to two states with a SetPoint filter
// 
// Reference
// http://funnel.cc/Software/ActionScript3

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.*;

    [SWF(backgroundColor="0x808080")]
    
    public class GainerTest extends Sprite {
        private var gio:Gainer;
        private var scope:SignalScope;

        public function GainerTest() {
            gio = new Gainer();

            scope = new SignalScope(0, 5, 200, "ain 0");
            addChild(scope);

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;
            gui.setPosition(IOModuleGUI.LEFT_BOTTOM);

            // add a SetPoint filter to divide the analog input 0
            // アナログ入力0を分割するSetPointフィルタを追加する
            gio.analogInput(0).addFilter(new SetPoint([0.3, 0.1]));

            gio.analogInput(0).addEventListener(RISING_EDGE, onRisingEdge);
            gio.analogInput(0).addEventListener(FALLING_EDGE, onFallingEdge);

            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {
            scope.update(gio.analogInput(0));
        }

        private function onRisingEdge(e:Event):void {
            // turn on the on-board LED on an ain 0's rising edge
            gio.led.on();
        }

        private function onFallingEdge(e:Event):void {
            // turn off the on-board LED on an ain 0's falling edge
            gio.led.off();
        }

    }
}
