/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5tAv
 */

package {
    import flash.filters.GlowFilter;
    import flash.filters.DropShadowFilter;
    import flash.display.Graphics;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
     
       public var back:Sprite;
     
       public var spr:Sprite;
       
       public var canvas:Sprite;
       
       public var pic:Bitmap;
       public var bdat:BitmapData;
     
        public function FlashTest() 
        {
            bdat = new BitmapData(16,12,true,0xff8080FF);
            bdat.perlinNoise(16,12,5,2,true,false,3);
            pic = new Bitmap(bdat);
            pic.scaleX = 24;
            pic.scaleY = 16;
            pic.x = 32;
            pic.y = 20;
            pic.filters = [ new DropShadowFilter() ];
            spr = new Sprite();
            spr.addChild(pic);
            addChild(spr);
            
            back = new Sprite();
            back.graphics.clear();
            back.graphics.lineStyle(2,0);
            back.graphics.moveTo(8,8);
            back.graphics.lineTo(440, 8);
            
            back.graphics.moveTo(8,8);
            back.graphics.lineTo(8, 350);
            
            back.graphics.moveTo(440,8);
            back.graphics.lineTo(440,350);
            
            addChild(back);
            
            bx = 150;
            by = 250;
            vy = -3;
            
            canvas = new Sprite();
            canvas.filters = [new GlowFilter(), new DropShadowFilter()];
            addChild(canvas);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var px:Number = 0;
        public var py:Number = 300;
        
        public var bx:Number = 0;
        public var by:Number = 0;
        public var vx:Number = 0;
        public var vy:Number = 0;
        
        public function onEnter(e:Event):void
        {
            var g:Graphics;
            
            g = canvas.graphics;
            
            px = mouseX-20;
            if (px < 20) { px = 20; }
            if (px > 400) { px = 400; }
            
            g.clear();
            g.beginFill(0,1);
             g.drawRect(px,py,40,16);
            g.endFill();
            
            vy += 0.2;
            if (vy >= 8) { vy = 8; }
            
            vx *=0.99;
            
            bx += vx;
            by += vy;
            
            if (vy >= 0 && isOver())
            {
              vy *= -1.5   
              if (bx < px+20) { vx -=2; }
              else { vx+=2;}    
            }
            
            
            if (vx < 0 && bx < 20) { vx = -vx;}
            else if (vx > 0 && bx  > 440-8) { vx = -vx;}
            
            if (vy < 0 && by +8 < 8) { vy = 1; }
            
            if (by >= 350) { bx = 150; by = 250; vx =0; vy=-3;}
            
            g.beginFill(0xFF0000,1);
            g.drawCircle(bx,by,8);
            g.endFill();
            
            var rx:Number;
            var ry:Number;
            
            rx = Math.floor( (bx - pic.x) / pic.scaleX);
            ry = Math.floor( (by - pic.y) / pic.scaleY);
            
            if (bdat.getPixel(rx, ry) != 0) 
            { vx *= -0.5; vy *= -0.5; 
            
                bdat.setPixel32(rx, ry, 0);
            }
        }//onenter
        
        public function isObst(wx:Number, wy:Number):Boolean
        {
            
          return false; 
        }//isobst
        
        
        public function isOver():Boolean
        {
            if (bx+8 < px) { return false; }
            if (bx-8 > px+40) { return false;}
            if (by+8 < py) { return false; }
            if (by-8 > py+20) { return false; }
            
         return true;   
        }//isover
        
    }//classend
}