/**
 * Copyright fancyblock ( http://wonderfl.net/user/fancyblock )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5t7y
 */

package 
{
    import flash.geom.Point;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        protected var SPOT_CNT:int = 40;
        
        protected var m_spotList:Array = new Array();
        protected var m_canvas:Sprite = null;
        protected var m_bezier:Array = new Array();
        
        public function FlashTest() 
        {
            // set canvas
            m_canvas = new Sprite();
            this.addChild( m_canvas );
            
            // create the origin spot
            for( var i:int = 0; i < SPOT_CNT; i++ )
            {
                var spot:Spot = new Spot( this, i*460/SPOT_CNT+20, 220 );
                spot.addEventListener( MouseEvent.MOUSE_DOWN, onDown );
                spot.addEventListener( MouseEvent.MOUSE_UP, onUp );
                
                m_spotList.push( spot );
            }
            
            // draw the bezier
            this.calculateCurl();
            this.renderCurl();
        }
        
        //-------------------- private functions ----------------------
        
        // calculate bezier curl 
        protected function calculateCurl():void
        {
            m_bezier = new Array();
            var i:int;
            
            var iterateTime:int = m_spotList.length -1;
            
            var spotSet:Array = new Array();
            var originSpot:Array = new Array();
            spotSet.push( originSpot );
            
            for( i = 0; i < m_spotList.length; i++ )
            {
                originSpot.push( new Point( m_spotList[i].x, m_spotList[i].y ) );
            }

            // calculate the middle point
            for( i = 0; i < iterateTime; i++ )
            {
                var arr:Array = new Array();
                spotSet.push( arr );
                var parents:Array = spotSet[i];
                
                for( var ii:int = 0; ii < parents.length - 1; ii++ )
                {
                    var pt1:Point = parents[ii];
                    var pt2:Point = parents[ii+1];
                    
                    // calculate middle point
                    var midPt:Point = new Point();
                    midPt.x = ( pt1.x + pt2.x ) * 0.5;
                    midPt.y = ( pt1.y + pt2.y ) * 0.5;
                    
                    arr.push( midPt );
                }

            }
            
            // add nessary point to the array
            for( i = 0; i < spotSet.length; i++ )
            {
                m_bezier.push( spotSet[i][0] );
            }
            for( i = spotSet.length - 1; i >= 0; i-- )
            {
                m_bezier.push( spotSet[i][spotSet[i].length-1] );
            }

        }
        
        // draw the bezier curl 
        protected function renderCurl():void
        {
            m_canvas.graphics.clear();
            
            if( m_bezier.length > 0 )
            {
                var pt:Point = null;
                
                m_canvas.graphics.lineStyle( 2, 0xff1326 );
                
                pt = m_bezier[0];
                m_canvas.graphics.moveTo( pt.x, pt.y );
                
                for( var i:int = 1; i < m_bezier.length; i++ )
                {
                    pt = m_bezier[i];
                    m_canvas.graphics.lineTo( pt.x, pt.y );
                }

            }
        }
        
        // on mouse down
        protected function onDown( evt:MouseEvent ):void
        {
            evt.currentTarget.startDrag();
        }
        
        protected function onUp( evt:MouseEvent ):void
        {
            evt.currentTarget.stopDrag();
            
            this.calculateCurl();
            this.renderCurl();
        }


    }
}
import flash.display.BitmapData;
import flash.display.Bitmap;

import flash.geom.Point;
import flash.display.Sprite;

class Spot extends Sprite
{
    protected var m_parent:Sprite = null;
    protected var m_bitmap:Bitmap = null;
    
    public function Spot( parent:Sprite, x:Number, y:Number )
    {
        m_parent = parent;
        
        this.x = x;
        this.y = y;
        
        var bmpData:BitmapData = new BitmapData( 11, 11, true, 0x00000000 );
        // draw a point
        var spr:Sprite = new Sprite();
        spr.graphics.beginFill( 0x111111 );
        spr.graphics.drawEllipse( 0, 0, 11, 11 );
        spr.graphics.endFill();
        // render to bitmap data
        bmpData.draw( spr, null, null );
        m_bitmap = new Bitmap( bmpData );
        
        m_bitmap.x = -5.5;
        m_bitmap.y = -5.5;
        this.addChild( m_bitmap );
        parent.addChild( this );
    }

}
