/**
 * Copyright hacker_cobulht0 ( http://wonderfl.net/user/hacker_cobulht0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5sr6
 */

//PV3D 練習　噴水
package{ 
    import flash.display.Sprite;
    import flash.events.Event;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.special.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.*;

    public class PV3Dparticle extends BasicView {
        
        private var rootNode  : DisplayObject3D; 
        private var ptclF:ParticleField;    
        
        private var bitmap:BitmapData;
        private var blur:BlurFilter = new BlurFilter(5, 5, 1);
        private var point:Point = new Point();
        
        private var pNum:uint=100;
        private var arr1=[0x1FCECB,0x199EBD,0x1F75FE,0x77DDE7,0x1DACD6,0x1CA9C9];
        private var _List:Array=new Array();
        
        public function PV3Dparticle() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void {
            
            rootNode = new DisplayObject3D();
            scene.addChild( rootNode );
            
            bitmap = new BitmapData(460,460, false, 0);
            stage.addChild(new Bitmap(bitmap));
            
            //Ptcl//////////////////////////////////////////////////
            var material:ParticleMaterial = new ParticleMaterial(0xFFFFFF, 1, 1, 5);
            ptclF = new ParticleField(material, pNum, 2, 700, 700, 700);
            rootNode.addChild(ptclF);
            
            for(var q:int=0; q < pNum; q++){
                var rd=Math.floor(Math.random()*6);
                ptclF.particles[q].material = new ParticleMaterial(arr1[rd], 1, 1, 5);
                ptclF.particles[q].x=0;
                ptclF.particles[q].y=-200;
                ptclF.particles[q].z=0;
                
                _List.push({_obj:ptclF.particles[q],_velX:Math.random() * 20-10,_velY:Math.random() * 50,_velZ:Math.random() * 20-10});
            }
            ///////////////////////////////////////////
            
            //床//////////////////////////////////////////////////
            var wmt:WireframeMaterial = new WireframeMaterial(0x1FCECB,0.04);
            var floor:Plane = new Plane(wmt, 500, 500,5,5);
            floor.y=-200;
            floor.pitch(90);
            rootNode.addChild(floor)
            ///////////////////////////////////////////
            
           
            camera.y = 400;
            //camera.x = 0; 
            //camera.z = 50;
            camera.focus =10;
            //camera.zoom = 10;
            
            startRendering();                
            addEventListener(Event.ENTER_FRAME, loop);            
        }
        
        private function loop(e:Event):void {
            
            rootNode.rotationY += 0.5;
            
            var _grav=0.8;
            for (var q:int=0; q < _List.length; q++) {
                var pt = _List[q];
                
                pt._obj.x += pt._velX;
                pt._obj.y += pt._velY;
                pt._obj.z += pt._velZ;        
                pt._velY -= _grav;
                
                if (pt._obj.y <-200){saiSet(pt);}
                
            }            
            
            
            bitmap.lock();
            bitmap.applyFilter(bitmap, bitmap.rect, point, blur)
            bitmap.draw(this);
            bitmap.unlock()
        }
        private function saiSet(arg){
            arg._obj.x=0;
            arg._obj.y=-200;
            arg._obj.z=0;
            arg._velX=Math.random() * 20-10;
            arg._velY=Math.random() * 20+20;
            arg._velZ=Math.random() * 20-10;
        }
    }
}
