/**
 * Copyright Dorara ( http://wonderfl.net/user/Dorara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5spK
 */

//　集中線
//     ばばーーーん！！！！！
package {
	import com.bit101.components.PushButton;
	
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.utils.ByteArray;

	public class SyutyuSen extends Sprite
	{
		private var centerX:Number;
		private var centerY:Number;
		
		private var fileReference:FileReference;
		
		private var back:Sprite;
		private var field:Sprite;
		private var image:Sprite;
		
		private var loadButton:PushButton;
		
		public function SyutyuSen()
		{
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			this.stage.align = StageAlign.TOP_LEFT;
			
			centerX = this.stage.stageWidth/2;
			centerY = this.stage.stageHeight/2;
			
			var OutR:Number = 1000;
			var InR:Number = 180;
			var error:Number = 100;
			
			back = new Sprite();
			field = new Sprite();
			image = new Sprite();
			
			
			back.graphics.beginFill(0xFFFFFF);
			back.graphics.drawRect(0, 0, this.stage.stageWidth, this.stage.stageHeight);
			back.graphics.endFill();

			this.addChild(back);

			fileReference = new FileReference();
			fileReference.addEventListener(Event.SELECT, selectHandler);
			fileReference.addEventListener(Event.COMPLETE, completeHandler);

			for(var angle:int = 0; angle<360; angle++){
				var InR2:Number = (Math.random()*error) + InR;
			
				var InX:Number = InR2 * Math.cos(angle*Math.PI/180);
				var InY:Number = InR2 * Math.sin(angle*Math.PI/180);
				
				var OutX:Number = OutR * Math.cos(angle*Math.PI/180);
				var OutY:Number = OutR * Math.sin(angle*Math.PI/180);
				
				var thick:int = Math.random()*3;
				
				field.graphics.lineStyle(thick, 0x000000);
				field.graphics.moveTo(centerX+InX, centerY+InY);
				field.graphics.lineTo(centerX+OutX, centerY+OutY);				
			}
			
			
			this.addChild(field);
			loadButton = new PushButton(this, 0, 0, "Load", upload);
		}
		
		private function upload(event:MouseEvent):void
		{
			var fileFilter:FileFilter = new FileFilter("Images", "*.jpg;*.gif;*.png");
			fileReference.browse([fileFilter]);	
		}
		
		private function selectHandler(event:Event):void
		{
			fileReference.load();
		}
		
		private function completeHandler(event:Event):void
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeLoadHandler);
			loader.loadBytes(fileReference.data);
			image.addChild(loader);
			this.addChildAt(image, 1);
			this.removeChild(loadButton);
		}
		
		private function completeLoadHandler(event:Event):void
		{
			image.x = centerX - event.target.width/2;
			image.y = centerY - event.target.height/2;
		}
	}
}