/**
 * Copyright gourmetbu ( http://wonderfl.net/user/gourmetbu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5shp
 */

// forked from tak0294's パーティクル時計
package {
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.*;
    import flash.display.Sprite;
    public class ParticleClock extends Sprite
    {
        private var isMouseDown:Boolean = false;
        private var currentX:Number = 0;
        private var currentY:Number = 0;
        
        private var clockText:TextField;
        private var clockDate:Date;
        
        private var frame:uint = 0;
        
        private var clockParticle:Vector.<particle> = new Vector.<particle>();
                
        public function ParticleClock()
        {
            // write as3 code here..
            
            //テキストフィールド.
            clockDate = new Date();
            
            clockText = new TextField();
            addChild(clockText);
            
            //イベント登録.
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            this.stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            this.stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        }
        
        private function mouseMoveHandler(e:MouseEvent):void
        {
            //if(isMouseDown)
            {
                currentX = e.currentTarget.mouseX;
                currentY = e.currentTarget.mouseY;
            }
        }

        
        private function mouseDownHandler(e:MouseEvent):void
        {
            isMouseDown = true;
        }

        private function mouseUpHandler(e:MouseEvent):void
        {
            isMouseDown = false;
        }
        
        private function onEnterFrameHandler(e:Event):void
        {
            //this.rotationY++;
            
            if(isMouseDown)
            {
                var p:particle = new particle();
                p.x = currentX;
                p.y = currentY;
                p.alpha = 1;
                p.isProcess = true;
                addChild(p);
            }
            
            clockDate = new Date();
            clockText.text = clockDate.getHours().toString() + ":" + clockDate.getMinutes().toString() + ":" + clockDate.getSeconds().toString();
            
            frame++;
            if(frame % 80 == 0)
            {
                removeClock();
                drawClock();
            }
           
        }
        
        private function removeClock():void
        {
            //for(var ii:uint=0;ii<clockParticle.length;ii++)
            while(clockParticle.length > 0)
            {
                var p:particle = clockParticle.pop();
                p.isProcess = true;
            }
        }

        
        private function drawClock():void
        {
            var tmpBitmapData:BitmapData = new BitmapData(clockText.width, clockText.height, true, 0x00FFFFFF);
            var tmpBitmap:Bitmap = new Bitmap(tmpBitmapData);
            tmpBitmapData.draw(clockText);
            
            for(var ii:uint = 0; ii<clockText.width;ii++)
            {
                for(var jj:uint=0;jj<clockText.height;jj++)
                {
                    var color:uint = tmpBitmapData.getPixel32(ii, jj);
                    if(color > 0)
                    {
                        var p:particle = new particle();
                        p.x = ii*10;
                        p.y = jj*10;
                        addChild(p);
                        clockParticle.push(p);
                    }
                }
            }
        }
    }
}
import flash.display.Graphics;

import flash.display.Sprite;
import flash.events.*;

class particle extends Sprite
{
    private var life:uint = 3;
    private var dx:Number = 0;
    private var dy:Number = 0;
    public var isProcess:Boolean = false;
        
    public function particle():void
    {
        addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
        var g:Graphics = this.graphics;
        g.beginFill(0xBBBBBB);
        g.drawCircle(x, y, Math.random()*4+3);
        g.endFill();
        
        //飛ぶ方向をランダムにする.
        dx = Math.random()*5 - 2;
        dy = Math.random()*5 - 2;
        
        alpha = 0;
    }
    
    private function onEnterFrameHandler(e:Event):void
    {
        if(isProcess)
        {
            x += dx;
            y += dy;
            
            //dy += 0.8;
            
            life--;
            alpha -= 0.02;
            if(alpha <= 0)
            {
                removeEventListener(Event.EXIT_FRAME, onEnterFrameHandler);
            }
        }
        else
        {
            if(alpha < 1)
                alpha += 0.02;
        }
    }
}
