/**
 * Copyright coppieeee ( http://wonderfl.net/user/coppieeee )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5sdY
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	import net.hires.debug.Stats;
	
	/**
	 * @author coppieee
	 * シンプル and 最適化してパーティクルの描画。
	 */
	public class SimpleParticle extends Sprite 
	{
		private static const WIDTH:Number = 512;
		private static const HEIGHT:Number = 512;
		
		//パーティクルの個数。50000ぐらいまでなら30fps出る。
		private static const PARTICLE_CONT:Number = 50000;
		
		private var _canvas:BitmapData;
		private var _particles:Vector.<Particle>;
		
		[SWF(frameRate="25",width="512",height="512" )]
		public function SimpleParticle() 
		{
			//キャンバスの生成
			_canvas = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
			addChild(new Bitmap(_canvas));
			
			//パーティクルの生成
			_particles = new Vector.<Particle>(PARTICLE_CONT,true);
			for (var i:uint = 0; i < PARTICLE_CONT; i++)
			{
				var p:Particle = new Particle();
				p.x = Math.random() * (_canvas.width - 1);
				p.y = Math.random() * (_canvas.height - 1);
				
				var radius:Number = Math.PI * 2 * Math.random();
				var speed:Number = Math.random();
				
				p.vx = Math.cos(radius) * speed;
				p.vy = Math.sin(radius) * speed;
				p.color = (uint(speed * 0xFF) << 16) | (uint(speed * 0xFF) << 8) | 0xFF;
				
				_particles[i] = p;
			}
			//ENTER_FRAMEイベントに登録
			addEventListener(Event.ENTER_FRAME, update);
			
			//Statsの生成
			//http://code.google.com/p/mrdoob/wiki/stats
			addChild(new Stats());
		}
		private function update(e:Event):void
		{
			_canvas.lock();
			
			//キャンバスの色を薄く
			var cr:Rectangle = new Rectangle(0, 0, _canvas.width, _canvas.height);
			var ct:ColorTransform = new ColorTransform (0.9, 0.9, 0.9);
			_canvas.colorTransform(cr,ct);
			
			//パーティクルの移動, 描画
			var length:uint = _particles.length;
			for (var i:uint = 0; i < length;i++ )
			{
				var p:Particle = _particles[i];
				p.x += p.vx;
				p.y += p.vy;
				p.x > WIDTH -1? p.x = 0 : p.x < 0 ? p.x = WIDTH-1 :null;
				p.y > HEIGHT-1 ? p.y = 0 : p.y < 0 ? p.y = HEIGHT-1 :null;
				_canvas.setPixel(p.x, p.y, p.color);
			}
			
			_canvas.unlock();
		}
	}
}
class Particle 
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var color:uint;
	public function Particle(x:Number=0,y:Number=0,vx:Number=0,vy:Number=0,color:uint = 0xFFFFFF)
	{
		this.x = x;
		this.y = y;
		this.vx = vx;
		this.vy = vy;
		this.color = color;
	}
}