/**
 * Copyright hacker_0xk7tdi4 ( http://wonderfl.net/user/hacker_0xk7tdi4 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5sSO
 */

// forked from nondelion's Rainbow Ball
// forked from nondelion's forked from: Rainbow Circle
// forked from nondelion's Rainbow Circle
package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.*;
	import flash.utils.Dictionary;
	import frocessing.color.ColorHSV;
	import net.hires.debug.Stats;

    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
	
	public class RainbowBall extends Sprite
	{
		protected static const PARTICLE_NUM:uint = 120;
		
		private var bmd:BitmapData;
		private var canvas:BitmapData;
		private var particles:Dictionary;
		private var bf1:BlurFilter = new BlurFilter(16,16,3);
		private var bf2:BlurFilter = new BlurFilter(2,2,6);
		private var ct1:ColorTransform = new ColorTransform(1,1,1,1,-1,-1,-1,0);
		private var ct2:ColorTransform = new ColorTransform(1,1,1,1,-1,-1,-2,0);
		private var _hsv:ColorHSV;
		
		public function RainbowBall()
		{
            _hsv = new ColorHSV(0, 1, 1, 1);
            bmd = new BitmapData(465, 465, true, 0xff000000);
			canvas = new BitmapData(465, 465, true, 0xff000000);
			addChild( new Bitmap(canvas));

			this.addChild(new Stats());
			
			particles = new Dictionary();
			addEventListener( Event.ENTER_FRAME, update);
		}
		
		private function setParticles():void
		{
			var o:Point = new Point(mouseX,mouseY);
			var p:Particle;
			for(var i:int=0; i<PARTICLE_NUM; i++){
				p = new Particle();
				p.color = 0xffffff;
				p.x = o.x;
				p.y = o.y;
				var r:Number = 0;
				var angle:Number = (i%360+Math.random())*3;
				p.radian = angle2radian(angle);
				p.vx = angle2x(angle,r);
				p.vy = angle2y(angle,r);
				particles[p] = true;
			}
		}
		
		private function angle2x(a:Number, r:Number):Number {
			return r * Math.cos(angle2radian(a));
		}
		
		private function angle2y(a:Number, r:Number):Number {
			return r * Math.sin(angle2radian(a));
		}
		
		private function angle2radian(a:Number):Number {
			return a * Math.PI / 180;
		}
		
		private function update(e:Event):void
		{
		    setParticles();
			canvas.lock();
			
			bmd.applyFilter( bmd, bmd.rect, new Point(), bf1);
			//bmd.colorTransform( bmd.rect, ct1);
			canvas.draw( bmd, null, null, "add" );
			canvas.applyFilter( canvas, canvas.rect, new Point(), bf2);
			canvas.colorTransform( bmd.rect, ct2);
			
			for(var key:* in particles){
				var p:Particle = Particle(key);
				_hsv.h = (_hsv.h+1) % 360;
				bmd.setPixel32(p.x, p.y, _hsv.value + (0xff<<24));
				p.x += p.vx;
				p.y += p.vy;
				p.vx = (Math.random()*30)*Math.cos(p.radian);
				p.vy = (Math.random()*30)*Math.sin(p.radian);
				if( p.x > 465 || p.y > 465 || p.x < 0 || p.y < 0){
					delete particles[p];
				}
			}
			canvas.unlock();
		}
	}
}

class Particle
{
	public var color:uint;
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var radian:Number;
	
	public function Particle()
	{
		
	}
}