/**
 * Copyright nyamogera ( http://wonderfl.net/user/nyamogera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5s4Z
 */

// forked from mogera's デバッグ用
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        
        private var test:DebugTest;
        [SWF(width="465", height="465", backgroundColor="0x222222", frameRate="30")] 
        public function FlashTest() {
            // write as3 code here..
            test = new DebugTest("test");
            test.add( "key1", "test1" );
			
            addChild( test );
            addEventListener( Event.ENTER_FRAME, enterFrame );
            
            var debugTestTest:DebugTest = DebugTest.createShareDebug("aaa");
        }
        
 	private function enterFrame(e:Event):void 
	{
            var debugTestTest:DebugTest = DebugTest.createShareDebug("aaa");
            debugTestTest.add("nooooo",getTimer().toString());
            addChild( debugTestTest );
            test.add("aa", "move");
            test.add( "time", getTimer().toString());
	}
    }
 }

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.utils.Dictionary;

class DebugTest extends Sprite
{
    private var barField:TextField;
    private var openField:TextField;
    private var debugField:TextField;
    private var dictionary:Dictionary;
    private var title:String;
    
    private static var instances:Object;

    public static function createShareDebug(title:String) : DebugTest 
    {
        if( !instances ) instances = new Object();
        
        if( instances[title] != undefined && 
               instances[title] != null) return instances[title];
               
        return (instances[title] = new DebugTest(title));
    }

    public function DebugTest(title:String) 
    {
	dictionary = new Dictionary(true);
	
	barField = new TextField();
	openField = new TextField();
	debugField = new TextField();
			
	barField.text = this.title = title;
	openField.text = "▲";	//	上三角
		
	barField.background = true;
	barField.backgroundColor = 0x00000;
	barField.textColor = 0xffffff;
	barField.x = 20;
	barField.height = 20;
	barField.addEventListener( MouseEvent.MOUSE_DOWN, startMove);
	barField.addEventListener( MouseEvent.MOUSE_UP, endMove);
	barField.border = true;
	barField.selectable= false;
	
	openField.background = true;
	openField.backgroundColor = 0x00000;
	openField.textColor = 0xffffff;
	openField.height = 20;
	openField.width = 20;
	openField.selectable= false;
	openField.border = true;
        openField.mouseEnabled = true;
	openField.addEventListener( MouseEvent.CLICK, switchVisible);

	debugField.border = true;
			
	debugField.y = 20;
	debugField.background = true;
	debugField.backgroundColor = 0xffffff;	
		
	addChild( barField );
	addChild( openField );
	addChild( debugField );
			
	update();
    }
		
    //	すいっち
   private function switchVisible(e:MouseEvent):void 
   {
        debugField.visible = !debugField.visible;

        if ( debugField.visible ) 
        {
	    openField.text = "▲"
	}
        else
	{
	    openField.text = "▼"
       	}
	    
    }
		
    //	
    private function endMove(e:MouseEvent):void 
    {
        stopDrag();
    }

	
    //	
    private function startMove(e:MouseEvent):void 
    {
        startDrag();
    }
    //	更新
    private function update():void
    {
        var w:Number = Math.max( barField.textWidth + 20, debugField.textWidth  ) + 4 ;
        barField.width = w - 20;
        debugField.width = w;
    		
        debugField.height = debugField.textHeight + 4;
    }
    	
    public function add(key:String, str:String) : void
    {
        dictionary[key] = str;
        debugField.text = "";
    	
        for ( var s:String in dictionary )
	{
	    debugField.appendText( s + "：" + dictionary[s] + "\n" );
	}
			
        update();
    }
		
    public function removeKey(key:String) : void
    {
        
        dictionary[key] = null;
        delete dictionary[key];
    	
        update();
    }
    
    public function remove() : void 
    {
        if( instances ) 
        {
            instances[title] = null;
        }   
    }    
 }