/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5rtS
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=190
    public class Euler190 extends Sprite {
        private var _tf : TextField;
  
        public function Euler190() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            t(solve());
            var g : int = getTimer();
            t((g - s) + " ms");
        }

        // f = log P_m = \sum_i=1^m i*log(x_i) として、
        // fの最大値をLagrangeの未定乗数法で求める。
        // L=f+λ(\sum x_i - m)として、任意のjについて
        // ∂L/∂x_j=j/x_j+λ=0 から x_j=-j/λ.
        // これを\sum x_i - m = 0に代入して
        // λ=-(m+1)/2. よって x_j=2j/(m+1), 
        // max f=\sum i*log(2i/(m+1))
        //      =\sum i*log(i) + m(m+1)/2*log(2/(m+1)).
        // あとはexp(max f)をm=2,..,15について加算すればよい。
        private function solve() : Number
        {
            var sum : int = 0;
            for(var m : int = 2;m <= 15;m++){
                var sumlog : Number = 0;
                for(var i : int = 1;i <= m;i++){
                    sumlog += i * Math.log(i);
                }
                var f : Number = sumlog + m * (m + 1) / 2 * Math.log(2 / (m + 1));
                var ef : Number = Math.exp(f);
                sum += int(ef);
                t(m + "\t" + f + "\t" + ef);
            }
            return sum;
        }

	private function t(o : *) : void
	{
            _tf.appendText("" + o + "\n");
	}
    }
}