/**
 * Copyright tronster ( http://wonderfl.net/user/tronster )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5rCb
 */

/**
 * Fireflies
 * By Tronster http://tronster.com
 * 
 * Copyright Geek House Games, LLC
 * http://geekhousegames.com
 * 
 * Your are welcome to copy modify, use, etc... but at your own risk.
 * Attribution is appreciated.
 */
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.geom.Rectangle;
    
    [SWF(backgroundColor='#102030', frameRate='30')] 
    public class Main extends Sprite 
    {
        private const MAX        :int = 300;
        private var bugs        :Vector.<FireFly>;
        private var bitmapData    :BitmapData;
        private var shape        :Shape;
        private var clearRect    :Rectangle;
        
        public function Main():void 
        {            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);

            // Set stage dimensions where it is accessible
            World.width = stage.stageWidth;
            World.height = stage.stageHeight;
        
            // Allocate container and particles
            bugs = new Vector.<FireFly>(MAX);
            for (var i:int = 0; i < MAX; ++i )
                bugs[i] = new FireFly();
            
            clearRect = new Rectangle( 0, 0, World.width, World.height );
            shape = new Shape();
            bitmapData = new BitmapData( World.width, World.height, true, 0x0);

            var bitmap:Bitmap = new Bitmap( bitmapData );
            bitmap.filters = [new GlowFilter(0xffff99, 0.5, 8, 8, 2, BitmapFilterQuality.HIGH ) ];
            addChild( bitmap );
            
            addEventListener( Event.ENTER_FRAME, onFrame );
        }
        
        private function onFrame( e:Event ) :void {
             bitmapData.lock();
            bitmapData.fillRect( clearRect, 0x0 );
            shape.graphics.clear();
            shape.graphics.beginFill( 0xffff00, 1  );
            var ff:FireFly;
            for (var i:int = 0; i < MAX; ++i ) {
                ff = bugs[i];
                if (ff.life-- < 1)
                    ff.reset();
                ff.x += ff.direction.x;
                ff.y += ff.direction.y;
                ff.z += ff.direction.z;
                shape.graphics.drawCircle( ff.x, ff.y, (ff.z * 0.001) + Math.sin(ff.life * 0.1) );
            }
            shape.graphics.endFill();
            bitmapData.draw( shape );
            bitmapData.unlock();
        }    
    }
}


import flash.geom.Vector3D;
internal final class FireFly
{
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var direction:Vector3D;
    public var life:int;
   
    function FireFly() {
        direction = new Vector3D( rand(1), rand(1), rand(1) );
        reset();
        
    }
    
    public function reset():void {
        life = 300 + (Math.random() * 2000);
        x = Math.random() * World.width;
        y = Math.random() * World.height;
        z = rand( 1000 );
        direction.x = rand(1);
        direction.y = rand(1);
        direction.z = rand(1);
        //direction.normalize();        
    }
    
}

/// Return a random # from -n to n
internal function rand(n:Number):Number {
    return (n - (n * 2 * Math.random() ));
}

/// Handy way to easily get at stage size
internal final class World {
    static public var width:int = 0;
    static public var height:int = 0;
}