/**
 * Copyright Ivan_Kuckir ( http://wonderfl.net/user/Ivan_Kuckir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5qeo
 */

package 
{
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.events.Event;
    
    public class Demo extends Sprite 
    {
        var s, sh, bd;
        var vrt, ind, uvt;
        var n  = 20;  // number of segments
        var zoom = 0, nn = n+1;
        
        var context = new LoaderContext();
        
        public function Demo() 
        {
            /*
            That's how 3D was made before Flash Player 11.
            It is just a demonstration of Graphics.drawTriangles(...),
            for real 3D use a another librariy.
            */
            stage.frameRate = 60;
            context.checkPolicyFile = true;
            
            s = new Sprite();
            s.x = stage.stageWidth/2;  s.y = stage.stageHeight/2;
            stage.addChild(s);
            
            sh = new Sprite();  s.addChild(sh);
            
            var ldr = new Loader();
            ldr.load(new URLRequest("http://lib.ivank.net/demos/earth.jpg"), context);
            ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e)
            {
                bd = e.target.content.bitmapData;
                var ldr2 = new Loader();
                ldr2.load(new URLRequest("http://lib.ivank.net/demos/shade.png"), context);
                ldr2.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e)
                {
                    sh.graphics.beginBitmapFill(e.target.content.bitmapData);
                    sh.graphics.drawTriangles(vrt, ind, uvt);
                    sh.graphics.endFill(); 
                });
            });
            
            
            vrt = new Vector.<Number>(); ind = new Vector.<int>(); uvt = new Vector.<Number>();

            var lat, lon, x, y, z, p;
            for (var i=0; i<=n; i++)        // rows
                for (var j=0; j<=n; j++)    // cols
                {
                    lat = -Math.PI/2 + i*Math.PI/n;
                    lon =  Math.PI   + j*Math.PI/n;
                    x = Math.cos(lat) * Math.cos(lon);
                    y = Math.sin(lat);
                    z = Math.cos(lat) * Math.sin(lon);
                    p = 9/(8+z);            // perspective
                    vrt.push(p*x, p*y);
                    uvt.push(0.5*j/n, i/n);
                    if(i<n && j<n)          // 6 indices for 2 triangles
                       ind.push(nn*i+j, nn*i+j+1, nn*(i+1)+j, nn*i+j+1, nn*(i+1)+j, nn*(i+1)+j+1);
                } 
            stage.addEventListener(Event.ENTER_FRAME, onEF);
        }

        function onEF(e)
        {
            if(bd==null) return;
            s.scaleX = s.scaleY = zoom = (3*zoom + 50 + stage.mouseY)*0.25;
            var vel = 0.00005*(stage.mouseX - s.x);
            for(var i=0; i<uvt.length; i+=2) uvt[i] += vel;  // shifting X coordinate
        
            s.graphics.clear();
            s.graphics.beginBitmapFill(bd);
            s.graphics.drawTriangles(vrt, ind, uvt);
        }
    }
}