/**
 * Copyright breathxue ( http://wonderfl.net/user/breathxue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5qGf
 */

// forked from coppieeee's 豆腐をボコボコにしてやんよ
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	import net.hires.debug.Stats;
	
	[SWF(width=465, height=465,frameRate=30)]
	public class DoNotClick extends Sprite 
	{
		private static const WIDTH:Number = 465;
		private static const HEIGHT:Number = 465;
		private var _canvas:BitmapData;
		private var _particles:Vector.<Particle>;
		public function DoNotClick():void 
		{
			_canvas = new BitmapData(WIDTH, HEIGHT, false, 0x000000);
			addChild(new Bitmap(_canvas));
			
			_particles = new Vector.<Particle>();
			
			for (var i:int = 0; i < 300; i++ )
			{
				for (var j:int = 0; j < 300; j++)
				{
					_particles.push(new Particle(i+100, j+100));
				}
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(MouseEvent.CLICK, onClick);
			addChild(new Stats());
		}
		private function onEnterFrame(e:Event):void
		{
			_canvas.lock();
			
			var cr:Rectangle = new Rectangle(0, 0, _canvas.width, _canvas.height);
			var ct:ColorTransform = new ColorTransform (0.9, 0.9, 0.9);
			_canvas.colorTransform(cr, ct);
			
			for each(var p:Particle in _particles)
			{
				p.vx *= 0.99;
				p.vy *= 0.99;
				p.x += p.vx;
				if (p.falled)
				{
					p.vy += 0.05;
				}
				p.y += p.vy;
				_canvas.setPixel(p.x, p.y, p.color);
			}
			_canvas.unlock();
		}
		private function onClick(e:MouseEvent):void
		{
			var mouseX:Number = stage.mouseX;
			var mouseY:Number = stage.mouseY;
			for each(var p:Particle in _particles)
			{
				var dx:Number = mouseX - p.x;
				var dy:Number = mouseY - p.y;
				var d:Number = Math.sqrt(dx * dx + dy * dy);
				var radian:Number = Math.atan2(dy, dx);
				var speed:Number = 300 / (d * d);
				p.vx += -Math.cos(radian) * speed;
				p.vy += -Math.sin(radian) * speed;
				if (speed > 1)
				{
					p.color = 0xAAAAAA;
					p.falled = true;
				}
				else
				{
					var c:uint = Math.pow(1 - speed,4) / 1 * 0xFF;
					if (c < (p.color & 0xFF))
					{
						p.color = (c << 16) | (c << 8) | c;
					}
				}
			}
		}
		
	}
	
}
class Particle 
{
	public var x:Number;
	public var y:Number;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var color:Number = 0xFFFFFF;
	public var falled:Boolean = false;
	public function Particle(x:Number,y:Number)
	{
		this.x = x;
		this.y = y;
	}
}