/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5pB2
 */

// forked from antalg's Fluid test
package {
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            addChild(new Bitmap(_bmd));
            
            balls = new Balls(this);
            
            spawnRandomBalls(20);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private var balls:Balls;
        private var bf:BlurFilter = new BlurFilter(16,16,2);
        private var _bmd:BitmapData = new BitmapData(sI.WDT, sI.HGT, false, 0x000000);
        
        private function mouseDown(e:MouseEvent):void {
            if(e.ctrlKey == true)
                spawnBall();
            else
                balls.nudge();
        }
        
        private function spawnRandomBalls(n:int):void {
            for(var i:int = 0; i<20; i++) {
                var angle:Number = 2*Math.PI*Math.random();
                balls.addBall(sI.WDT*Math.random(), sI.HGT*Math.random(), sI.BASEV*Math.cos(angle), sI.BASEV*Math.sin(angle), 16);
            }
        }
        
        private function spawnBall():void {
            var angle:Number = 2*Math.PI*Math.random();
            balls.addBall(stage.mouseX, stage.mouseY, sI.BASEV*Math.cos(angle), sI.BASEV*Math.sin(angle), 16);
        }

        
        private function enterFrame(e:Event):void {
            balls.move();
            reDraw();
        }
        
        private function reDraw():void {
            _bmd.fillRect(_bmd.rect, 0x000000);
            
            for each (var b:Ball in balls.ballArray) {
                _bmd.draw(b.ballSprite, new Matrix(1,0,0,1,b.data.x,b.data.y));
            }
            
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(0,0), bf);          
            _bmd.threshold(_bmd, _bmd.rect, new Point(0,0), ">=", 0x111111, 0xFF0066FF, 0xFFFFFF, false);
        }
    }
}

import flash.display.MovieClip;
import flash.display.AVM1Movie;
import flash.display.Sprite;
import com.actionsnippet.qbox.*;

internal class sI {
    public static const WDT:int = 465;
    public static const HGT:int = 465;
    public static const BASEV:Number = 4;
}

internal class Ball {
    public function Ball(X:Number, Y:Number, VX:Number, VY:Number, RADIUS:Number, COLOR:uint):void {
        data = {x:X, y:Y, vx:VX, vy:VY};
        this.ballSprite = baseSprite(RADIUS, COLOR);
    }
    
    private function baseSprite(radius:Number, color:uint):Sprite {
        var spr:Sprite = new Sprite();
        spr.graphics.beginFill(color);
        spr.graphics.drawCircle(0,0,radius);
        spr.graphics.endFill();
        
        return spr;
    }
    
    public var data:Object;
    public var ballSprite:Sprite;
    public var physBall:QuickObject;
}

internal class Balls {
    public function Balls(parent:*):void {
        ballArray = new Array();
        
        worldSpr = new MovieClip();
        worldSpr.width = sI.WDT;
        worldSpr.height = sI.HGT;
        
        world = new QuickBox2D(worldSpr, {simpleRender:false});
        
        //world.createStageWalls();
        
        var n:Number = sI.WDT/30;
        world.addBox({x:n/2, y:n+0.5, width:n, density:0}); // Floor
        world.addBox({x:-0.5, y:30*n/2-n/2, height:30*n, density:0}); // Right wall
        world.addBox({x:n+0.5, y:30*n/2-n/2, height:30*n, density:0}); // Left wall
        
        world.start();
    }
    
    private var world:QuickBox2D;
    private var worldSpr:MovieClip;
    public var ballArray:Array;
    
    public function addBall(X:Number, Y:Number, VX:Number, VY:Number, RADIUS:Number = 10, COLOR:uint=0xFFFFFF):Sprite {
        var newBall:Ball = new Ball(X, Y, VX, VY, RADIUS, COLOR);
        newBall.physBall = world.addCircle({x:X/30, y:Y/30, radius:RADIUS/30, friction:0.01, restitution:0.5})
        
        this.ballArray.push(newBall);
        return newBall.ballSprite;
    }
    
    public function move():void {
        for each (var b:Ball in this.ballArray) {
            /*b.data.vy = (b.data.vy+0.98)*0.97;
            
            var x:Number = b.data.x + b.data.vx;
            var y:Number = b.data.y + b.data.vy;
            
            if(Math.random()<0.005) {
                b.data.vy-=4;
            }
            
            b.data.vx = x<0?-b.data.vx:(x>465?-b.data.vx:b.data.vx);
            b.data.vy = y<0?-b.data.vy:(y>465?-b.data.vy:b.data.vy);
            
            b.data.x += b.data.vx;
            b.data.y += b.data.vy;*/
            
            b.data.x = b.physBall.x*30;
            b.data.y = b.physBall.y*30;
        }
    }
    
    public function nudge():void {
        for each (var b:Ball in this.ballArray) {
            var angle:Number = 2*Math.PI*Math.random();
            
            b.physBall.y = -Math.random()*3;
        }
    }

}
