/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5p1U
 */

package
{
    import com.bit101.components.PushButton;
    import com.bit101.components.TextArea;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.TextEvent;
 
    public class Main extends Sprite
    {
        private var src:TextArea;
        private var dest:TextArea;
        private var frame:int = 0;
        
        public function Main()
        {
            src = new TextArea(this, 0, 90, "STSJSQSKSA");
            dest = new TextArea(this, 0, 260);
            
            src.x = dest.x = (stage.stageWidth - src.width) / 2;
            judgment();
            
            addEventListener(Event.ENTER_FRAME, judgment);
        }
 
        private function judgment(event:Event = null):void
        {
            if (frame++ % 10) return;
            var hand:String = src.text;
            var data/*String*/:Array = hand.match(/[SHCD][2-9TJQKA]/g);
            trace(hand + " : " + data.length);
            if (data.length != 5)
            {
                dest.text = "ERROR";
                return;
            }
            
            var isFlush:Boolean = true;
            var suit:String = data[0].charAt(0);
            var num:Object = { "2":2, "3":3, "4":4, "5":5, "6":6, "7":7, "8":8, "9":9, "T":10, "J":11, "Q":12, "K":13, "A":14 };
            var rank/*int*/:Array = [];
            for each (var h:String in data)
            {
                if (suit != h.charAt(0)) isFlush = false;
                rank.push(num[h.charAt(1)]);
            }
            rank.sort(Array.NUMERIC);
            var STRAIGHT_LIST:String = "2,3,4,5,6,7,8,9,10,11,12,13,14,2,3,4,5,14";
            var isStraight:Boolean = (STRAIGHT_LIST.indexOf(rank.join(",")) != -1) ? true : false;
            var isRoyal:Boolean = (rank[0] == 10) ? true : false;
 
            var sameRank/*int*/:Array = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
            for each (var r:int in rank) sameRank[r]++;
            sameRank.sort(Array.NUMERIC | Array.DESCENDING);
 
            if (isRoyal && isStraight && isFlush) dest.text = "Royal flush";
            else if (isStraight && isFlush) dest.text = "Straight flush";
            else if (sameRank[0] == 4) dest.text = "Four of a kind";
            else if (sameRank[0] == 3 && sameRank[1] == 2) dest.text = "Full house";
            else if (isFlush) dest.text = "Flush";
            else if (isStraight) dest.text = "Straight";
            else if (sameRank[0] == 3) dest.text = "Three of a kind";
            else if (sameRank[1] == 2) dest.text = "Two pair";
            else if (sameRank[0] == 2) dest.text = "One pair";
            else dest.text = "No Pair";
        }
    }
}
