/**
 * Copyright mapache ( http://wonderfl.net/user/mapache )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5ora
 */

// forked from mapache's flash on 2010-7-23
package {
     import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import net.hires.debug.Stats;
    [swf(widht='465' , height='465', frameRate='30')]
    public class blockBreaker extends Sprite{
        private static const WIDTH:Number= 465;
        private static const HEIGHT:Number= 465;
        private var _canvas:BitmapData;
        private var _blocks:Blocks;
        private var _fallBlocks:Vector.<Particle>;
        private var _balls:Vector.<Particle>;
        private var _bar:Bitmap;
        public function blockBreaker(){
            _canvas = new BitmapData(WIDTH , HEIGHT , false , 0x000000);
            addChild(new Bitmap(_canvas) );
            _blocks = new Blocks(WIDTH , 100);
            _fallBlocks = new Vector.<Particle>();
            
            var b:BitmapData = new BitmapData(50,10,false,0xFFFFFF);
            addChild(_bar = new Bitmap(b));
            _bar.y = WIDTH - _bar.width;
            var _ball:Particle = new Particle(WIDTH/2 , HEIGHT/2);
            _ball.vx = Math.random() * 10;
            _ball.vy = Math.random() * 9 -1;
            _ball.color = 0xFFFFFF;
            _balls = new Vector.<Particle>();
            _balls.push(_ball);
            addEventListener(Event.ENTER_FRAME , update);
        }
        private function update(e:Event):void{
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect , new ColorTransform(0.9, 0.5 , 0.9));
            for each(var _block:Particle in _blocks.values ){
                if(_block){
                    _canvas.setPixel(_block.x , _block.y , _block.color);
                }
            }   
            var removeBalls:Vector.<Particle> = new Vector.<Particle>(); 
            for each(var ball:Particle in _balls ){
                var bvx:Number = ball.vx;
                var bvy:Number = ball.vy;
                var bspeed:Number = Math.sqrt(bvx * bvx + bvy * bvy);
            }     
         }
    }   
}
    
    import frocessing.color.ColorHSV;
    class Blocks{
        public function get count():int{ return _count;}
        public function get width():Number{return _width;}
        public function get height():Number{return _height;}
        private var _count:int;
        private var _width:Number;
        private var _height:Number;
        public var values:Vector.<Particle>;
        function Blocks(w:Number , h:Number){
            _width = w;
            _height = h;
            _count  = _width * _height;
            values = new Vector.<Particle>(width * height , false);
            var c:ColorHSV = new ColorHSV();
            for(var i:int=0; i< _width; i++){
                c.h = 360 * i/_width;
                for(var j:int=0; j < _height; j++){
                    var p:Particle = new Particle(i , j);
                    p.color = c.value;
                    values[i + j * _width] = p;
                 } 
             }
        }
    }
    
    class Particle{
        //
        public var x:Number;
        public var y:Number;
        public var vx:Number =0;
        public var vy:Number =0;
        public var color:uint;
        public function Particle(x:Number=0 , y:Number=0){
            this.x = x;
            this.y = y;
        }
    }
