/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5oQ2
 */

package {
	import flash.display.*;
	import flash.events.*;
	public class FlashTest extends Sprite {
		private var data: BitmapData;
		public function FlashTest() {
			data = new BitmapData(400, 400, false, 0x000000);
			var bitmap: Bitmap = new Bitmap(data);
			addChild(bitmap);
			
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame( event: Event): void {
			// write as3 code here..
			data.lock();
			
			var centerX: Number = 200;
			var centerY: Number = 200;
			var extentX: Number = mouseX;
			var extentY: Number = 100;
			
			for (var i: int = 0; i < 400; i++) {
				for (var j: int = 0; j < 400; j++) {
					var px: Number = i - centerX;
					var py: Number = j - centerY;
					var tx: Number = px / extentX;
					var ty: Number = py / extentY;
					var tx2: Number = px / extentY;
					var length: Number = Math.sqrt(tx * tx + ty * ty);
					var length2: Number = Math.sqrt(tx2 * tx2 + ty * ty);
					var ex: Number = tx / length;
					var ey: Number = ty / length;
					 
					var fx: Number = ex * extentX;
					var fy: Number = ey * extentY;
					var dx: Number = px - fx;
					var dy: Number = py - fy;
					var dist: Number = Math.sqrt(dx * dx + dy * dy);
					
					if ( length < 1.0 )
					{
						dist *= -1;
					}
					var ratio: Number = 0;
					var adjustment: Number = 0;
					if ( length2 < 2.0 )
					{
						ratio = 1.0 - length2 / 2;
						adjustment = (1.0 - length) * extentX;
						dist = dist * (1.0 - ratio) - adjustment * ratio;
					}
					
					data.setPixel(i, j, (0xff00 - dist * 5000) & 0xff00);
				}
			}
			
			data.unlock();
		}
	}
}