/**
 * Copyright genny ( http://wonderfl.net/user/genny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5nxx
 */

/**
*	親子関係を再生成
*/
package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	public class Main extends Sprite
	{
		
		//	property
		private var _container1:Sprite;
		private var _container2:Sprite;
		private var _ball:Sprite;
		
		
		//	constructer
		function Main()
		{
			init();
		}
		
		
		//	initialize
		private function init() :void
		{
			_container1 = new Sprite();
			_container2 = new Sprite();
			_ball = new Sprite();
			
			//	コンテナ1を作成
			_container1.graphics.lineStyle( 1, 0xFF0000, 0.5 );
			_container1.graphics.drawRect( 0, 0, 100, 50 );
			_container1.graphics.endFill();
			addChild(_container1);
			_container1.name = "c1";
			
			
			//	コンテナ2を作成
			_container2.graphics.lineStyle( 1, 0x006633, 0.5 );
			_container2.graphics.drawRect( 0, 0, 100, 50 );
			_container2.graphics.endFill();
			addChild(_container2);
			_container2.x = 250;
			_container2.y = 250;
			_container2.name = "c2";
			
			
			//	ボールを生成
			_ball.graphics.beginFill( 0xFFCC00 );
			_ball.graphics.drawCircle( 0, 0, 20 );
			_ball.graphics.endFill();
			_container1.addChild( _ball );
			_ball.x += _ball.width / 2;
			_ball.y += _ball.height / 2;
			_ball.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDownHandler );
		}
		
		
		private function onMouseDownHandler( event:MouseEvent ) :void
		{
			var sp:Sprite = event.target as Sprite;
			var str:String = sp.parent.name;
			
			if( str == "c1" )	_container2.addChild( sp );
			else				_container1.addChild( sp );

		}
		
	}
	
}
