/**
 * Copyright YoupSolo ( http://wonderfl.net/user/YoupSolo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5n8H
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    /**
     * ...
     * @author YopSolo
     */    

    public class PerlinMove extends Sprite
    {

        private var SIZE:int;
        private var SIZE2:int;
        private var _arr:Array;
        private var _bmp:BitmapData;
        private var _px1:Number;        

        public function PerlinMove()
        {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;            
            
            SIZE = stage.stageWidth;
            SIZE2 = SIZE >> 1;
            _arr = [];            
            _bmp = new BitmapData(SIZE / 10, SIZE / 10, false, 0x0);            
            _px1 = 0;            

            addEventListener(Event.ENTER_FRAME, _oef);
            stage.addEventListener(MouseEvent.CLICK, _addNewPoint);
        }

        private function _oef(e:Event):void 
        {
            graphics.clear();
            if (_arr.length < 65 && Math.random() < .1)
                _addNewPoint();

            _bmp.perlinNoise(40, 40, 3, 6456, true, true, 2 | 1, false, [new Point(_px1 += 0.3, 0), new Point( -_px1 / 2, 0), new Point(0, 0)]);

            for each (var c:Point in _arr)
            {
                graphics.moveTo(c.x, c.y);
                var rgb24:uint = _bmp.getPixel(c.x * .1, c.y * .1);
                if (rgb24 > 0)
                {
                    c.x += (128 - (rgb24 >> 16)) / 5;
                    c.y += (128 - ((rgb24 ^ (rgb24 >> 16 << 16)) >> 8)) / 5;
                }
                c.x += (SIZE2 - c.x) / 50;
                c.y += (SIZE2 - c.y) / 50;

                for each (var b:Point in _arr)
                    if (b != c && Point.distance(c, b) < 30)
                    {
                        var ang:Number = Math.atan2(c.y - b.y, c.x - b.x);
                        c.x += ((b.x + Math.cos(ang) * 30) - c.x) / 7;
                        c.y += ((b.y + Math.sin(ang) * 30) - c.y) / 7;
                    }
                graphics.lineStyle(10);
                graphics.lineTo(c.x, c.y);
            }
        }

        private function _addNewPoint(e:Event = null):void
        {
            _arr.push(new Point(Math.random() * SIZE, Math.random() * SIZE))
        }
    }    
}