/**
 * Copyright aqaqaqaqaiko ( http://wonderfl.net/user/aqaqaqaqaiko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5n3X
 */

// forked from ProjectNya's スライドショー [フルスクリーン]
////////////////////////////////////////////////////////////////////////////////
// スライドショー [フルスクリーン]
//
// [AS3.0] スライドショーに挑戦！ (15)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1388
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
    import flash.display.StageDisplayState;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;

    [SWF(backgroundColor="#FFFFFF", width="760", height="350", frameRate="30")]

    public class Main extends Sprite {
        private var slideshow:SlideShow;
        private var controller:Sprite;
        private var prevBtn:RectBtn;
        private var nextBtn:RectBtn;
        private var base:Sprite;
        private var txtloader:TextLoader;
        private static var basePath:String = "http://www.project-nya.jp/images/flash/";
        private static var dataPath:String = "slideshow325.xml";
        private static var max:uint;
        private var loaders:Array;
        private var loaded:uint = 0;
        private var contents:Array;
        private var photos:Array;
        private var thumbs:Array;
        private var selectedId:int = 0;
        private var timer:Timer;
        private static var interval:uint = 2000;
        private var panel:Sprite;
        private var fullscreenBtn:Btn;
        private var normalBtn:Btn;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            base = new Sprite();
            addChild(base);
            base.x = 232;
            base.y = 212;
            base.graphics.beginFill(0xEEEEEE);
            base.graphics.drawRect(-160, -120, 320, 240);
            base.graphics.endFill();
            slideshow = new SlideShow();
            addChild(slideshow);
            slideshow.x = 232 - 160;
            slideshow.y = 212 - 120;
            slideshow.alpha = 0;
            slideshow.visible = false;
            controller = new Sprite();
            addChild(controller);
            controller.x = 232;
            controller.y = 340;
            controller.alpha = 0;
            controller.visible = false;
            prevBtn = new RectBtn(RectBtn.PREV);
            controller.addChild(prevBtn);
            prevBtn.x = - 180;
            prevBtn.y = 22;
            nextBtn = new RectBtn(RectBtn.NEXT);
            controller.addChild(nextBtn);
            nextBtn.x = 180;
            nextBtn.y = 22;
            //
            txtloader = new TextLoader();
            txtloader.addEventListener(TextLoader.COMPLETE, parse, false, 0, true);
            txtloader.load(basePath + dataPath);
            //
            panel = new Sprite();
            addChild(panel);
            panel.x = 232;
            panel.y = 445;
            fullscreenBtn = new Btn();
            panel.addChild(fullscreenBtn);
            fullscreenBtn.x = 0;
            fullscreenBtn.init({label: "full screen", width: 100});
            fullscreenBtn.addEventListener(MouseEvent.CLICK, screen, false, 0, true);
            normalBtn = new Btn();
            panel.addChild(normalBtn);
            normalBtn.x = 0;
            normalBtn.init({label: "normal", width: 100});
            normalBtn.addEventListener(MouseEvent.CLICK, screen, false, 0, true);
            normalBtn.visible = false;
            stage.addEventListener(Event.RESIZE, resize, false, 0, true);
        }
        private function parse(evt:Event):void {
            evt.target.removeEventListener(TextLoader.COMPLETE, parse);
            var xml:XML = XML(evt.target.data);
            trace("parse", xml);
            max = xml.item.length();
            loaders = new Array();
            contents = new Array();
            photos = new Array();
            for (var n:uint = 0; n < max; n++) {
                var thumbPath:String = xml.item[n].thumb;
                var photoPath:String = xml.item[n].photo;
                var _loader:ImageLoader = new ImageLoader();
                _loader.id = n;
                _loader.addEventListener(ImageLoader.COMPLETE, _complete, false, 0, true);
                _loader.load(basePath + thumbPath, true);
                loaders.push(_loader);
                var loader:ImageLoader = new ImageLoader();
                loader.id = n;
                loader.addEventListener(ImageLoader.COMPLETE, complete, false, 0, true);
                loader.load(basePath + photoPath, true);
                loaders.push(loader);
            }
        }
        private function _complete(evt:Event):void {
            var _loader:ImageLoader = ImageLoader(evt.target);
            _loader.removeEventListener(ImageLoader.COMPLETE, _complete);
            contents[_loader.id] = _loader.content;
            initialize();
        }
        private function complete(evt:Event):void {
            var loader:ImageLoader = ImageLoader(evt.target);
            loader.removeEventListener(ImageLoader.COMPLETE, complete);
            photos[loader.id] = loader.content.bitmapData;
            initialize();
        }
        private function initialize():void {
            loaded ++;
            if (loaded > max*2 - 1) {
                setup();
            }
        }
        private function setup():void {
            thumbs = new Array();
            for (var n:uint = 0; n < max; n++) {
                var thumb:ActionMenu = new ActionMenu();
                controller.addChild(thumb);
                thumb.x = - 160 + 65*n;
                thumb.y = 0;
                thumb.id = n;
                thumb.base.addChild(contents[n]);
                thumb.addEventListener(MouseEvent.CLICK, click, false, 0, true);
                thumbs.push(thumb);
            }
            slideshow.init(photos);
            slideshow.addEventListener(Event.COMPLETE, update, false, 0, true);
            prevBtn.addEventListener(MouseEvent.CLICK, prev, false, 0, true);
            nextBtn.addEventListener(MouseEvent.CLICK, next, false, 0, true);
            manage();
            fade();
        }
        private function fade():void {
            var itween:ITween = BetweenAS3.serial(
                BetweenAS3.to(base, {alpha: 0, visible: 0}, 0.4, Linear.easeNone), 
                BetweenAS3.parallel(
                    BetweenAS3.to(slideshow, {alpha: 1, visible: 1}, 0.6, Linear.easeNone), 
                    BetweenAS3.to(controller, {alpha: 1, visible: 1}, 0.6, Linear.easeNone)
                )
            );
            itween.addEventListener(TweenEvent.COMPLETE, faded, false, 0, true);
            itween.play();
        }
        private function faded(evt:TweenEvent):void {
            evt.target.removeEventListener(TweenEvent.COMPLETE, faded);
            removeChild(base);
            startTimer();
        }
        private function prev(evt:MouseEvent):void {
            transit(slideshow.selectedId - 1);
        }
        private function next(evt:MouseEvent):void {
            transit(slideshow.selectedId + 1);
        }
        private function click(evt:MouseEvent):void {
            var id:uint = evt.target.id;
            var offset:int = id - slideshow.selectedId;
            var distance:int = 0;
            if (Math.abs(offset) < max/2) {
                distance = offset;
            } else {
                if (offset > 0) {
                    distance = offset - max;
                } else {
                    distance = offset + max;
                }
            }
            transit(slideshow.selectedId + distance);
        }
        private function transit(id:int):void {
            selectedId = id;
            manage();
            slideshow.transit(selectedId);
            stopTimer();
        }
        private function manage():void {
            var sid:int = (selectedId + max)%max;
            for (var n:uint = 0; n < max; n++) {
                var thumb:ActionMenu = thumbs[n];
                if (n == sid) {
                    thumb.selected = true;
                } else {
                    thumb.selected = false;
                }
            }
        }
        private function update(evt:Event):void {
            startTimer();
        }
        private function startTimer():void {
            timer = new Timer(interval, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, tick, false, 0, true);
            timer.start();
        }
        private function stopTimer():void {
            if (timer) {
                timer.stop();
                timer.removeEventListener(TimerEvent.TIMER_COMPLETE, tick);
                timer = null;
            }
        }
        private function tick(evt:TimerEvent):void {
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, tick);
            transit(slideshow.selectedId + 1);
        }
        private function resize(evt:Event = null):void {
            var sw:uint = stage.stageWidth;
            var sh:uint = stage.stageHeight;
            panel.x = sw/2;
            panel.y = sh - 20;
            slideshow.x = sw/2 - 160;
            slideshow.y = sh/2 - 140;
            controller.x = sw/2;
            controller.y = sh/2 + 108;
            if (stage.displayState == StageDisplayState.FULL_SCREEN) {
                fullscreenBtn.visible = false;
                normalBtn.visible = true;
            } else {
                fullscreenBtn.visible = true;
                normalBtn.visible = false;
            }
        }
        private function screen(evt:Event):void {
            if (stage.displayState == StageDisplayState.NORMAL) {
                stage.displayState = StageDisplayState.FULL_SCREEN;
            } else {
                stage.displayState = StageDisplayState.NORMAL;
            }
        }
        
    }

}


//////////////////////////////////////////////////
// SlideShowクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.filters.BlurFilter;

class SlideShow extends Sprite {
    private var container:Sprite;
    private static var max:uint;
    private var photos:Array;
    private static var xoffset:uint = 360;
    public var selectedId:int = 0;
    private var releaseId:int = 0;
    private var direction:Boolean = false;
    private var basePos:int = 0;
    private var targetPos:Number = 0;
    private static var deceleration:Number = 0.25;
    private static var unit:uint = 3;
    private static var limit:uint;
    private static var offset:uint;

    public function SlideShow() {
        basePos = 0;
        container = new Sprite();
        addChild(container);
    }

    public function init(list:Array):void {
        photos = list;
        max = photos.length;
        for (var n:uint = 0; n < max + unit*2; n++) {
            var bitmapData:BitmapData = photos[(n - unit + max)%max];
            var photo:Bitmap = new Bitmap(bitmapData.clone());
            photo.smoothing = true;
            container.addChild(photo);
            photo.x = xoffset*(n - unit);
        }
        limit = xoffset*(max - 1);
        offset = xoffset*max;
    }
    public function transit(id:int):void {
        direction = (id - selectedId > 0);
        selectedId = id;
        releaseId = id;
        targetPos = basePos - xoffset*selectedId;
        addEventListener(Event.ENTER_FRAME, slide, false, 0, true);
    }
    private function slide(evt:Event):void {
        container.x += (targetPos - container.x)*deceleration;
        manage();
        if (Math.abs(targetPos - container.x) < 0.5) {
            container.x = targetPos;
            removeEventListener(Event.ENTER_FRAME, slide);
            dispatchEvent(new Event(Event.COMPLETE));
        }
        motionblur();
    }
    private function manage():void {
        if (direction && container.x < - limit) {
            selectedId = releaseId - max;
            container.x += offset;
            targetPos = basePos - xoffset*selectedId;
        }
        if (!direction && container.x > 0) {
            selectedId = max + releaseId;
            container.x -= offset;
            targetPos = basePos - xoffset*selectedId;
        }
    }
    private function motionblur():void {
        var blur:Number = Math.abs(targetPos - container.x)/xoffset*100;
        for (var n:uint = 0; n < max + unit*2; n++) {
            var photo:Bitmap = Bitmap(container.getChildAt(n));
            photo.filters = [new BlurFilter(blur, 0, 3)];
        }
    }

}


//////////////////////////////////////////////////
// TextLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;

class TextLoader extends EventDispatcher {
    private var loader:URLLoader;
    private var _data:*;
    public static const TEXT:String = URLLoaderDataFormat.TEXT;
    public static const BINARY:String = URLLoaderDataFormat.BINARY;
    public static const COMPLETE:String = Event.COMPLETE;

    public function TextLoader() {
        loader = new URLLoader();
    }

    public function load(file:String, format:String = TextLoader.TEXT):void {
        loader.dataFormat = format;
        loader.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        loader.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        loader.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    private function ioerror(evt:IOErrorEvent):void {
        trace(evt.text);
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        trace(evt.status);
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        trace(evt.text);
    }
    private function complete(evt:Event):void {
        loader.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        loader.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        loader.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        loader.removeEventListener(Event.COMPLETE, complete);
        _data = evt.target.data;
        dispatchEvent(new Event(TextLoader.COMPLETE));
    }
    public function get data():* {
        return _data;
    }

}


//////////////////////////////////////////////////
// ImageLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;

class ImageLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function ImageLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(ImageLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(ImageLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(ImageLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if (smoothing) {
            content.smoothing = true;
        }
        dispatchEvent(new Event(ImageLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        dispatchEvent(new Event(ImageLoader.COMPLETE));
    }

}


//////////////////////////////////////////////////
// RectBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.MouseEvent;

class RectBtn extends Sprite {
    public var id:uint;
    private var base:Sprite;
    private var over:Sprite;
    private var icon:Sprite;
    private var _enabled:Boolean = true;
    private var type:String = "";
    public static const PREV:String = "prev";
    public static const NEXT:String = "next";

    public function RectBtn(t:String) {
        type = t;
        init();
    }

    private function init():void {
        draw();
        _up();
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        _over();
    }
    private function rollOut(evt:MouseEvent = null):void {
        _up();
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            _up();
        } else {
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            _over();
        }
    }
    private function _up():void {
        base.visible = true;
        over.visible = false;
    }
    private function _over():void {
        base.visible = false;
        over.visible = true;
    }
    private function draw():void {
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(0x333333);
        base.graphics.drawRect(-16, -16, 32, 32);
        base.graphics.endFill();
        over = new Sprite();
        addChild(over);
        over.graphics.beginFill(0x666666);
        over.graphics.drawRect(-16, -16, 32, 32);
        over.graphics.endFill();
        icon = new Sprite();
        addChild(icon);
        icon.graphics.beginFill(0xFFFFFF);
        switch (type) {
            case PREV :
                icon.graphics.moveTo(1, -5);
                icon.graphics.lineTo(-3, 0);
                icon.graphics.lineTo(1, 5);
                icon.graphics.lineTo(1, -5);
                break;
            case NEXT :
                icon.graphics.moveTo(-1, -5);
                icon.graphics.lineTo(3, 0);
                icon.graphics.lineTo(-1, 5);
                icon.graphics.lineTo(-1, -5);
                break;
        }
        icon.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// ActionMenuクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

class ActionMenu extends Sprite {
    public var id:uint;
    public var base:Sprite;
    public var over:Sprite;
    private var mode:int = 0;
    private var speed:Number = 0.1;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function ActionMenu() {
        init();
    }

    private function init():void {
        draw();
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        mode = 1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function rollOut(evt:MouseEvent = null):void {
        mode = -1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function action(evt:Event):void {
        over.alpha += speed*mode;
        if (over.alpha < 0) {
            over.alpha = 0;
            removeEventListener(Event.ENTER_FRAME, action);
        }
        if (over.alpha > 1) {
            over.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, action);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        if (!_selected) {
            _enabled = param;
        } else {
            _enabled = false;
        }
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        } else {
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        }
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            rollOver();
        } else {
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            rollOut();
        }
    }
    private function draw():void {
        base = new Sprite();
        addChild(base);
        over = new Sprite();
        addChild(over);
        over.graphics.beginFill(0xFFFF00, 0.8);
        over.graphics.drawRect(0, 0, 60, 45);
        over.graphics.drawRect(3, 3, 54, 39);
        over.graphics.endFill();
        over.graphics.beginFill(0xFFFFFF, 0.4);
        over.graphics.drawRect(3, 3, 54, 39);
        over.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}

