/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5mZB
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.external.ExternalInterface;
    import flash.text.TextField;
    
    /*
    Here's a hack that tries to find out the sizes of two screens (if there are two);
    Due to Javascript restrictions this will only work if the swf is started in the
    left window.
    
    This might be useful to use the new 10.2 fullscreeen mode to open up the window
    in the second screen.
    
    It does not seem to work on wonderfl since ExternalInterface calls
    are disabled.
    
    Mario Klingemann, http://www.quasimondo.com
    */
    
    public class ScreenCheck extends Sprite {
        
        private static var FUNCTION_ADD_SCREENINFO:String = 
            "document.insertScript = function ()" +
            "{ " +
            "if (document.getScreenInfo==null)" + 
            "{" + 
            "getScreenInfo = function ()" +
            "{" + 
            "return [screen.width,screen.height,(document.all)?window.screenLeft:window.screenX,(document.all)?window.screenTop:window.screenY, window.innerWidth ? window.innerWidth : (document.documentElement ? document.documentElement.clientWidth : (document.body ? document.body.clientWidth : 0)),window.innerHeight ? window.innerHeight : (document.documentElement ? document.documentElement.clientHeight : (document.body ? document.body.clientHeight : 0))];" +
            "}" +
            "}" +
            "}";
        ;
        
        
        private static var FUNCTION_ADD_MOVE_WINDOW:String = 
            "document.insertScript = function ()" +
            "{ " +
            "if (document.moveWindow==null)" + 
            "{" + 
            "moveWindow = function ( x, y)" +
            "{" + 
            "if (document.all) window.screenLeft = x, window.screenTop = y;" +
            "else window.screenX = x, window.screenY = y;" +
            "}" +
            "}" +
            "}";
        ;
        
        private static var FUNCTION_ADD_SIZE_WINDOW:String = 
            "document.insertScript = function ()" +
            "{ " +
            "if (document.resizeWindow==null)" + 
            "{" + 
            "resizeWindow = function ( w, h)" +
            "{" + 
            "window.resizeTo(w,h);"+
            "}" +
            "}" +
            "}";
        ;
        
        private var tf:TextField;
        
        
        public function ScreenCheck() 
        {
            tf = new TextField();
            tf.autoSize = "left";
            addChild(tf);
            if ( ExternalInterface.available )
            {
                try
                {
                    ExternalInterface.call(FUNCTION_ADD_SCREENINFO);
                    ExternalInterface.call(FUNCTION_ADD_MOVE_WINDOW);
                    ExternalInterface.call(FUNCTION_ADD_SIZE_WINDOW);
                    stage.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown );
                 } catch ( error:Error )
                 {
                     tf.text = "External Interface Calls not allowed in this Sandbox";
                 }

            } else 
            {
                tf.text = "External Interface is disabled";
            }

        }
        
        private function onMouseDown( event:MouseEvent ):void
        {
             var windowData:Array =  ExternalInterface.call("getScreenInfo");
            tf.appendText( "Left Screen Size: "+stage.fullScreenWidth+" x "+ stage.fullScreenHeight + "\n")
            ExternalInterface.call("resizeWindow",windowData[0]*3,windowData[1]);
            tf.appendText( "Right Screen Size: "+stage.fullScreenWidth+" x "+ stage.fullScreenHeight + "\n")
            ExternalInterface.call("resizeWindow",windowData[4],windowData[5]);    
        }
    }
}