/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5l18
 */

// forked from applicott's 三角関数uzumaki forked from: [BetweenAS3]uzumaki
// forked from applicott's [BetweenAS3]uzumaki
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width=465, height=465, frameRate=60)]
    
    public class uzumaki extends Sprite
    {
        private const NUM:uint     = 5200;
        private const SEC:Number   = 19;
        private const I_HUE:Number = 30;
        private const D_HUE:Number = 360 / NUM;
        private const LAG:Number   = 0.9;
        
        private const W:int = stage.stageWidth;
        private const H:int = stage.stageHeight;
        
        private var bmd:BitmapData    = new BitmapData(W, H, false, 0x000000);
        private var ct:ColorTransform = new ColorTransform(LAG, LAG, LAG);
        
        public function uzumaki()
        {
            stage.quality = StageQuality.LOW;
            
            const CX:Number  = W / 2;
            const CY:Number  = H / 2;
            const D2R:Number = Math.PI / 180;
            var   hue:Number = I_HUE;
            var   rad:Number = 0;
            var   p:Particle = new Particle(hue2rgb(hue), CX, CY);
            
            for (var i:uint = 0; i < NUM; i++) {
                hue += D_HUE;
                rad  = i * D2R;
                
                var t:ITween = BetweenAS3.serial(
                    BetweenAS3.to(p, {
                        x: Math.cos(30 * rad) * (30 + i / 40) + CX,
                        y: Math.sin(30 * rad) * (30 + i / 40) + CY
                    }, SEC, Bounce.easeInOut),
                    
                    BetweenAS3.to(p, {
                        x: Math.cos(20 * rad * stage.mouseX) * (30 + (i / 10) * 2 + stage.mouseY) + CX,
                        y: Math.sin(rad) * (30 + (i / 10) * 2) + CY
                    }, SEC, Cubic.easeInOut),
                    
                    BetweenAS3.to(p, {
                        x: Math.cos(20 * rad * stage.mouseX) * (30 + (i / 10) * 2 + stage.mouseY) - W,
                        y: Math.sin(2.7 * rad) * (30 + (i / 10) * 2) + CY
                    }, SEC, Cubic.easeInOut),
                    
                    BetweenAS3.to(p, {
                        x: Math.cos(10 * rad) * (i / 30) + CX,
                        y: Math.sin(10 * rad) * (i / 30) + CY
                    }, SEC / 3, Elastic.easeOut),
                    
                    BetweenAS3.to(p, {
                        x: Math.cos(rad) * (i / 12) + CX,
                        y: Math.tan(rad) * (i / 8) + CY
                    }, SEC, Bounce.easeInOut),
                    
                    BetweenAS3.to(p, {
                        x: Math.cos(rad) * (i / 12) + CX,
                        y: Math.sin(rad) * (i / 12) + CY
                    }, SEC, Bounce.easeInOut),
                    
                    BetweenAS3.to(p, {
                        x: Math.cos(i * D2R) * (i / 16) + CX,
                        y: Math.sin(i * D2R) * (i / 16) + CY
                    }, SEC / 3, Cubic.easeIn)
                );
                t.stopOnComplete = false;
                t.play();
                
                p = p.next = new Particle(
                    hue2rgb(hue),
                    Math.cos(i * D2R) * (i / 16) + CX,
                    Math.sin(i * D2R) * (i / 16) + CY
                );
            }
            
            addChild(new Bitmap(bmd));
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            bmd.lock();
            
            bmd.colorTransform(bmd.rect, ct);
            
            var p:Particle = Particle.head;
            do {
                if (p.x < 0 || p.x >= W || p.y < 0 || p.y >= H) continue;
                bmd.setPixel(p.x, p.y, p.color);
            } while (p = p.next);
            
            bmd.unlock();
        }
        
        public static function hue2rgb(h:Number):uint
        {
            var rgb:uint = 0x000000;
            
            h = h >= 360 ? h % 360 : (h < 0 ? h % 360 + 360 : h);
            
            var i:int    = int(h / 60);
            var f:Number = h / 60 - i;
            var g:Number = 1 - f;
            
            switch (i) {
                case 0: rgb =       0xFF0000 | f * 0xFF << 8 |             0; break;
                case 1: rgb = g * 0xFF << 16 |      0x00FF00 |             0; break;
                case 2: rgb =              0 |      0x00FF00 | f * 0xFF << 0; break;
                case 3: rgb =              0 | g * 0xFF << 8 |      0x0000FF; break;
                case 4: rgb = f * 0xFF << 16 |             0 |      0x0000FF; break;
                case 5: rgb =       0xFF0000 |             0 | g * 0xFF << 0; break;
            }
            
            return rgb;
        }
    }
}

class Particle
{
    public static var head:Particle;
    
    public var next:Particle;
    public var color:uint;
    public var x:Number;
    public var y:Number;
    
    public function Particle(color:uint = 0x000000, x:Number = 0, y:Number = 0)
    {
        head ||= this;
        
        this.color = color;
        this.x     = x;
        this.y     = y;
    }
}
