/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5jtx
 */

// forked from Kay's forked from: 透視投影テスト
// forked from Kay's 透視投影テスト
/*
 * 単純なボックスを並べた透視投影テスト
 * 各Boxに回転を加える
 * --------------------------------------------
 * Boxを３軸とCircleに変更
 */

package {
    
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    [SWF(width=465,height=465,frameRate=30)]
    public class Main extends Sprite {
        
        private const SW:Number = stage.stageWidth;
        private const SH:Number = stage.stageHeight;
        public var proj:PerspectiveProjection = new PerspectiveProjection();
        
        public function Main():void {
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0xeeeeee);
            bg.graphics.drawRect(0,0,SW,SH);
            bg.graphics.endFill();
            addChild(bg);
            
            proj.fieldOfView = 30;

            var container:Sprite = new Sprite();
            addChild(container);
            container.x = SW/2;
            container.y = SH/2;

            var boxNum:uint = 3;
            var dist:Number = 150;
            var shift:Number = dist*(boxNum-1)/2;
            for (var v:int = 0; v < boxNum; v++) {
                var nY:Number = dist*v-shift;
                for (var h:int = 0; h < boxNum; h++) {
                    var nX:Number = dist*h-shift;
                    var box:Box = new Box();
                    container.addChild(box);
                    box.mtx.prepend(proj.toMatrix3D());
                    box.mtx.prependTranslation(nX, nY, proj.focalLength);
                    box.xRender();
                    box.addEventListener(Event.ENTER_FRAME, xRotate);
                }
            }
        }
        public function xRotate(e:Event):void {
            // Box空間ではなくBox座標を回転させる
            e.target.rMtx.appendRotation(2,Vector3D.Y_AXIS);
            e.target.xRender();
        }
    }
}

import flash.display.*;
import flash.geom.*;

class Box extends Sprite {
        private const len:Number=50;
        private var vertices3D:Vector.<Number> = new Vector.<Number>();
        private var vertices2D:Vector.<Number> = new Vector.<Number>();
        //private var indices:Vector.<int> = new Vector.<int>();
        private var uvt:Vector.<Number> = new Vector.<Number>();
        public var mtx:Matrix3D = new Matrix3D();
        public var rMtx:Matrix3D = new Matrix3D();

        public function Box():void {
            // 円周座標を登録
            var radius:Number = len;
            var vRing:Vector.<Number> = new Vector.<Number>();
            for (var i:int = 0; i < 36; i++) {
                var radian:Number = Math.PI/180 * i*10;
                vRing.push(radius*Math.cos(radian),radius*Math.sin(radian));
            }
            // Z回転軸
            for (i = 0; i < 36; i++) {
                vertices3D.push(vRing[i*2+0],vRing[i*2+1],0);
            }
            // Y回転軸
            for (i = 0; i < 36; i++) {
                vertices3D.push(vRing[i*2+0],0,vRing[i*2+1]);
            }
            // X回転軸
            for (i = 0; i < 36; i++) {
                vertices3D.push(0,vRing[i*2+0],vRing[i*2+1]);
            }
        }

        public function xRender():void {
            var bgVerts:Vector.<Number> = vertices3D.slice(0,108);
            Utils3D.projectVectors(mtx,bgVerts,vertices2D,uvt);
            
            graphics.clear();
            /*
            // 背景色
            graphics.beginFill(0xffffff,0.2);
            graphics.moveTo(vertices2D[35*2+0],vertices2D[35*2+1]);
            for (var i:int = 0; i < 36; i++) {
                graphics.lineTo(vertices2D[i*2+0],vertices2D[i*2+1]);
            }
            graphics.endFill();
            */
            
            // 回転させた座標に透視投影を反映して2D化する
            var tempVerts:Vector.<Number>=new Vector.<Number>  ;
            rMtx.transformVectors(vertices3D, tempVerts);
            Utils3D.projectVectors(mtx,tempVerts,vertices2D,uvt);
            // Z軸
            graphics.lineStyle(0,0xff0000,0.5);
            graphics.moveTo(vertices2D[45*2+0],vertices2D[45*2+1]);
            graphics.beginFill(0xff0000,0.1);
            graphics.lineTo(vertices2D[63*2+0],vertices2D[63*2+1]);
            graphics.moveTo(vertices2D[35*2+0],vertices2D[35*2+1]);
            for (var i:int = 0; i < 36; i++) {
                graphics.lineTo(vertices2D[i*2+0],vertices2D[i*2+1]);
            }
            graphics.endFill();
            // Y軸
            graphics.lineStyle(0,0x0000ff,0.5);
            graphics.moveTo(vertices2D[90*2+0],vertices2D[90*2+1]);
            graphics.beginFill(0x0000ff,0.1);
            graphics.lineTo(vertices2D[72*2+0],vertices2D[72*2+1]);
            graphics.moveTo(vertices2D[71*2+0],vertices2D[71*2+1]);
            for (i = 36; i < 72; i++) {
                graphics.lineTo(vertices2D[i*2+0],vertices2D[i*2+1]);
            }
            graphics.endFill();
            // X軸
            graphics.lineStyle(0,0x00ff00,0.5);
            graphics.moveTo(vertices2D[0],vertices2D[1]);
            graphics.beginFill(0x00ff00,0.1);
            graphics.lineTo(vertices2D[18*2+0],vertices2D[18*2+1]);
            graphics.moveTo(vertices2D[107*2+0],vertices2D[107*2+1]);
            for (i = 72; i < 108; i++) {
                graphics.lineTo(vertices2D[i*2+0],vertices2D[i*2+1]);
            }
            graphics.endFill();
        }
    
}