/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5jqf
 */

package {
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
           graphics.lineStyle(1,0);
           var g:Graphics; g = graphics;  
            g.beginFill(0xF0F0F0,1);
             g.moveTo(0, cw*0.5);
             g.lineTo(cw, 0);
             g.lineTo(cw*2, cw*0.5);
             g.lineTo(cw*2, cw*0.5+ht);
             g.lineTo(cw, cw+ht);
             g.lineTo(0, cw*0.5+ht);
             g.lineTo(0, cw*0.5);
            g.endFill(); 
            g.beginFill(0, 0.25);
             g.moveTo(0, cw*0.5);
             g.lineTo(cw, 0);
             g.lineTo(cw*2, cw*0.5);
             g.lineTo(cw, cw);           
            g.endFill();          
            g.beginFill(0,0.5);
             g.moveTo(cw*2, cw*0.5);
             g.lineTo(cw*2, cw*0.5+ht);
             g.lineTo(cw, cw+ht);
             g.lineTo(cw, cw);            
            g.endFill();
            
            skin = new BitmapData(cw*2,cw+ht, true,0);
            skin.draw(this);           
            graphics.clear();
            graphics.beginBitmapFill(skin,null,true,true);
             graphics.drawRect(0,0,465,465);
            graphics.endFill();            
            graphics.clear();




            deb = new TextField();
            deb.width = 320; deb.height=240;
            deb.mouseEnabled=false;
            deb.textColor=0xFFffFFff;
            addChild(deb);
                        
            mw=12;mh=12;
            mnum = 8;
            vecGrid=new Vector.<int>(mw*mh*mnum, false);
            camy = 256;
                        
            var i:int;
            for (i =0; i < 256; i++)
            { setWall(Math.random()*256,0,Math.random()*256,1); }                        

            var ct:ColorTransform;
            var a:BitmapData;
            
            ct = new ColorTransform();
            ct.alphaMultiplier = 0.9;
            vecTile = new Vector.<BitmapData>(mnum, false);
            for (i = 0; i < mnum; i++)
            {
               a = new BitmapData(skin.width,skin.height, true,0);
               a.draw(skin); vecTile[i] =a;
               ct.blueMultiplier = (i/mnum);
               ct.greenMultiplier = (i/mnum);
               ct.redMultiplier = (i/mnum);
               a.colorTransform(a.rect, ct);                 
            }//nexti


                        
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMdown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMup);            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);            
        }//ctor
        
        public var mdown:int = 0; 
        public function onMdown(e:MouseEvent):void { mdown = 1; }
        public function onMup(e:MouseEvent):void { mdown = 0; }
                
        public var deb:TextField;
        
        
        public var skin:BitmapData;
        public var vecTile:Vector.<BitmapData>;
        
        public var cw:Number = 16;
        public var ch:Number = 16;
        public var ht:Number = 16;
        public var mw:int = 8;
        public var mh:int = 8;
        public var mnum:int = 1;
        public var vecGrid:Vector.<int>;
 
        public var camx:Number = 0;
        public var camy:Number = 0;
        public var camz:Number = 0;
        
        public var wmx:Number = 0;
        public var wmy:Number = 0;
        public var wmz:Number = 0;
        public var wtx:int = 0;
        public var wty:int = 0; 
        public var wtz:int = 0;
        
        public var drawy:Number = 0;
       
        public var rendw:Number = 465 * 0.5;
        public var rendh:Number = 465 * 0.5; 
        
        public var canvas:BitmapData = new BitmapData(465,465,false,0);
        
        public function onEnter(e:Event):void
        {
           var mx:Number;  var my:Number;
            mx = stage.mouseX;     my = stage.mouseY;         
            mx -= rendw; my -= camy-drawy;
            wmz = (2*my - mx)*0.5;  wmx = mx + wmz;
            wmx += camx;      wmz += camz;   
            wmy = 0+drawy;
            wtx = Math.floor(wmx/cw);
            wty = Math.floor(wmy/ht);
            wtz = Math.floor(wmz/ch);
            //drawy = Math.random()*256;
            //drawy += ht; if (drawy >= ht*mnum) {drawy=0;}
       
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            graphics.beginBitmapFill(canvas,null,false,false);
             graphics.drawRect(0,0,465,465);
            graphics.endFill();
       
            graphics.lineStyle(2, 0xFF0000);
            //drawBox2(0,0,0, cw,ht,ch);
            //drawBox2(wmx,wmy,wmz, cw,ht,ch);
            //drawBox2(0,0,0, cw*mw,ht*mnum,ch*mh);
            
            drawBox2(wtx*cw,wty*ht,wtz*ch, cw,ht,ch);

            drawBox2(0,drawy,0, mw*cw,ht,mh*ch);
        
            for (i = 0; i < mnum; i++)
            { 
             graphics.drawRect(i*32,0, 32, 32);
             if (mdown > 0) if (stage.mouseY < 32)
             if (stage.mouseX > i*32 && stage.mouseX < (i*32+32))
             { drawy = i * ht;  }
            }

            
            canvas.unlock();
            canvas.lock();
            canvas.fillRect(canvas.rect,0x80);
     
           // drawSprite(canvas, skin, wmx,wmy,wmz);

            var w:int;            
            var i:int; var k:int; var yt:int; var t:int;
            var wt:int;
            var ptile:BitmapData;
            ptile=vecTile[0];
            for (w = 0; w < mnum; w++)
            {
              ptile = vecTile[w];
              wt = (mw*mh)*w;
            for (i = 0; i < mh; i++)
            { yt = i * mw;
             for (k = 0; k < mw; k++)
             {
               t = vecGrid[wt+yt+k];
               if (t <= 0) { continue; }
                //drawSprite(canvas, skin, k*cw,w*ht,i*ch);
                drawSprite(canvas, ptile, k*cw,w*ht,i*ch);
               
             }//nextk
            }//nexti 
            }//nextw
            

            deb.text = ""+mdown;            
            if (mdown > 0)   {  setWall(wmx,wmy,wmz, 1);   }
            
        }//onenter
        
        public function setWall(ax:Number, ay:Number, az:Number, w:int):void
        {
            var tx:int, ty:int, tz:int; var t:int;
            tx = Math.floor(ax/cw);  ty = Math.floor(ay/ht);  tz = Math.floor(az/ch);
             deb.text = " " + tx+"\n"+ty + "\n"+tz;
            if (tx < 0) { return; } if (tx >= mw) { return; }
            if (ty < 0) { return; } if (ty >= mnum) { return; }
            if (tz < 0) { return; } if (tz >= mh) { return; }
            t = (mw*mh)*ty+(mw*tz)+tx; 
            vecGrid[t] = w;
            //deb.text = "tile " + t;
        }//setwall
        
        
        
        public var tempPoint:Point = new Point();
        public function drawSprite(to:BitmapData, spr:BitmapData, ax:Number,ay:Number,az:Number):void
        {
            var sx:Number; var sy:Number;     
            ax -= camx; ay -= camy; az -= camz; 
            sx = ax - az + rendw;
            sy = (ax * 0.5) + (az * 0.5) - ay; 
            tempPoint.x = sx-spr.width*0.5; tempPoint.y = sy-spr.height*0.5;
            to.copyPixels(spr, spr.rect, tempPoint);
        }//drawsprite
        
        
        
       
       
        public function drawLine(ax:Number, ay:Number, az:Number,
        bx:Number, by:Number, bz:Number):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;
           bx -= camx; by -= camy; bz -= camz;
    
            sx = ax - az + rendw;
            sy = (ax * 0.5) + (az * 0.5) - ay;
            graphics.moveTo(sx,sy);

            sx = bx - bz + rendw;
            sy = (bx * 0.5) + (bz * 0.5) - by;
            graphics.lineTo(sx, sy);
            
        }//drawline 
        
       public function drawBox2(ax:Number, ay:Number, az:Number,
       aw:Number, ah:Number, ad:Number):void
       {
           drawBox(ax,ay,az,ax+aw,ay+ah,az+ad);
       }//drawbox2
        
       public function drawBox(ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
        {
          drawLine(ax, ay, az,   bx, ay, az);
          drawLine(ax, by, az,   bx, by, az);
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, by, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, by, az);
          drawLine(bx, ay, az,   bx, by, az);
          drawLine(ax, ay, bz,   ax, by, bz);
          drawLine(bx, ay, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, ay, bz);
          drawLine(bx, ay, az,   bx, ay, bz);
          drawLine(ax, by, az,   ax, by, bz);
          drawLine(bx, by, az,   bx, by, bz);
        }//drawbox  
        
    }//classend
}