/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5jc8
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	/**
	 * @author 9re
	 */
	public class ColorPoint extends Sprite
	{
		private var _sw:int;
		private var _hw:int;
		private var _sh:int;
		private var _hh:int;
		private var _bd:BitmapData;
		private var _i:int;
		private var _j:int;
		private var _c:Number;
		private var _cc:Number;
		private var _s:Number;
		private var _ss:Number;
		
		public function ColorPoint() 
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			_sw = Math.max(465, stage.stageWidth);
			_sh = Math.max(465, stage.stageHeight);
			
			_bd = new BitmapData(_sw, _sh, true, 0xff000000);
			addChild(new Bitmap(_bd));
			
			_hw = _sw / 2;
			_hh = _sh / 2;
			
			_c = _cc = Math.cos(0.02);
			_s = _ss = Math.sin(0.02);
			
			update(null);
			
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void 
		{
			++_i;
			_j += 3;
			
			_i %= 17;
			_j %= 257;
			
			_c = _c * _cc - _s * _ss;
			_s = _c * _ss + _s * _cc;
			
			
			draw();
		}
		
		private function draw():void
		{
			var i:int, j:int, h:int, s:Number, b:Number;
			var _x:int, _y:int, tx:int;
			_bd.lock();
			for (i = 0; i < _sw; ++i) {
				for (j = 0; j < _sh; ++j) {
					tx = _x = i - _hw;
					_y = j - _hh;
					_x = tx * _c - _y * _s;
					_y = tx * _s + _y * _c;
					_x += _hw;
					_y += _hh;
					
					h = (_y & _x) * _i;
					s = (((_y ^ _x) * _j) & 0xff) / 255;
					_x = _sw - _x;
					_y = _sh - _y;
					
					b = ((_y ^ _x * _i) & 0xff) / 255;
					_bd.setPixel(i, j, HSBColor.convertHSBtoRGB(h, s, b));
				}
			}
			_bd.unlock();
		}
		
	}

}











class HSBColor
{
    /**
     * Constructs an HSVColor with optional parameters
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function HSBColor(hue:Number = NaN, saturation:Number = NaN, 
        brightness:Number = NaN)
    {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
    }
    
    private var _hue:Number;
    /**
     * The hue value for the HSV color. This represents an angle, in 
     * degrees, around the HSV cone. The supplied value will be modulated
     * by 360 so that the stored value of hue will be in the range [0,360).
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get hue():Number
    {
        return _hue;
    }
    public function set hue(value:Number):void
    {
        _hue = value % 360;
    }
    
    private var _saturation:Number;
    /**
     * The saturation parameter for this HSV color. This is a value between
     * 0 (black) and 1 (full saturation), which represents the distance
     * from the center in the HSV cone.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get saturation():Number
    {
        return _saturation;
    }
    public function set saturation(value:Number):void
    {
        _saturation = value;
    }
    
    private var _brightness:Number;
    /**
     * The brightness parameter for this HSB color. This is a value between
     * 0 (black) and 1 (full brightness), which represents the distance
     * from the apex of the HSB cone.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get brightness():Number
    {
        return _brightness;
    }
    public function set brightness(value:Number):void
    {
        _brightness = value;
    }
    
    /**
     * Converts an HSB color specified by the parameters to a
     * uint RGB color.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public static function convertHSBtoRGB(hue:Number, saturation:Number, 
        brightness:Number):uint
    {
        // Conversion taken from Foley, van Dam, et al
        var r:Number, g:Number, b:Number;
        if (saturation == 0)
        {
            r = g = b = brightness;
        }
        else
        {
            var h:Number = (hue % 360) / 60;
            var i:int = int(h);
            var f:Number = h - i;
            var p:Number = brightness * (1 - saturation);
            var q:Number = brightness * (1 - (saturation * f));
            var t:Number = brightness * (1 - (saturation * (1 - f)));
            switch (i) {
                case 0:
                    r = brightness;
                    g = t;
                    b = p;
                    break; 
                case 1:
                    r = q;                    
                    g = brightness;
                    b = p;
                    break; 
                case 2:
                    r = p;
                    g = brightness;
                    b = t; 
                    break;
                case 3:
                    r = p;
                    g = q;
                    b = brightness;
                    break; 
                case 4:
                    r = t;
                    g = p;
                    b = brightness; 
                    break;
                case 5: 
                    r = brightness;
                    g = p;
                    b = q;
                    break;
            }
        }
        r *= 255;
        g *= 255;
        b *= 255;
        return (r << 16 | g << 8 | b);
    }
    
    /**
     * Converts a color from RGB format into an HSBColor
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    static public function convertRGBtoHSB(rgb:uint):HSBColor
    {
        // Conversion taken from Foley, van Dam, et al
        var hue:Number, saturation:Number, brightness:Number;
        var r:Number = ((rgb >> 16) & 0xff) / 255;
        var g:Number = ((rgb >> 8) & 0xff) / 255;
        var b:Number = (rgb & 0xff) / 255;
        var max:Number = Math.max(r, Math.max(g, b));
        var min:Number = Math.min(r, Math.min(g, b));
        var delta:Number = max - min;
        brightness = max;
        if (max != 0)
            saturation = delta / max;
        else
            saturation = 0;
        if (saturation == 0)
            hue = NaN;
        else
        {
            if (r == max)
                hue = (g - b) / delta;
            else if (g == max)
                hue = 2 + (b - r) / delta
            else if (b == max)
                hue = 4 + (r - g) / delta;
            hue = hue * 60;
            if (hue < 0)
                hue += 360;
        }
        return new HSBColor(hue, saturation, brightness);
    }
}