/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5jSF
 */

package {
    import com.bit101.components.*;
    
    import org.si.sion.*;
    import org.si.sound.*;
    import org.si.sound.patterns.*;
    import org.si.sound.synthesizers.*;
    
    import flash.display.*;
    import flash.events.*;
    import flash.text.TextField;
    
    public class Main extends Sprite
    {
    		private var driver:SiONDriver;
    		private var drumMachine:DrumMachine;
    	
        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }
            
        private function init():void
        {
        		createConsole();
        		
        		driver = new SiONDriver();
        		driver.bpm = 128;
        		driver.autoStop = true;
        		driver.play(null, false);
        		
        		test();
        }
                
        private function test():void
        {
        		drumMachine = new DrumMachine();
        	
        		var seq0:PatternSequencer = new PatternSequencer(this, 0, 0, "bass");
        		seq0.value = "0---0---0---1111";
        		seq0.addEventListener(Event.CHANGE, onSeqChange);
        		seq0.addEventListener(Event.SELECT, onSeqSelect);
        		seq0.id = 0;
        		
        		var seq1:PatternSequencer = new PatternSequencer(this, 0, 24, "snare");
        		seq1.value = "----------------";
        		seq1.addEventListener(Event.CHANGE, onSeqChange);
        		seq1.addEventListener(Event.SELECT, onSeqSelect);
        		seq1.id = 1;
        		
        		var seq2:PatternSequencer = new PatternSequencer(this, 0, 48, "hihat");
        		seq2.value = "0-1-0-1-0-1-0-1-";
        		seq2.addEventListener(Event.CHANGE, onSeqChange);
        		seq2.addEventListener(Event.SELECT, onSeqSelect);
        		seq2.id = 2;
        		
        		//DrumMachine must play first
        		drumMachine.play();
        		
        		drumMachine.bassPattern = createPattern(seq0.value);
        		drumMachine.snarePattern = createPattern(seq1.value);
        		log(seq1.value);
        		drumMachine.hihatPattern = createPattern(seq2.value);
        		drumMachine.bass.mute = !seq0.selected; 
        		drumMachine.snare.mute = !seq1.selected; 
        		drumMachine.hihat.mute = !seq2.selected;
        		
        		//not after pattern changed
        		//drumMachine.play();
        }
        
        private function onSeqChange(e:Event):void
        {
        		var seq:PatternSequencer = e.currentTarget as PatternSequencer;
        		switch(seq.id) {
        			case 0:
        				drumMachine.bassPattern = createPattern(seq.value); 
        				break;
        			case 1:
        				drumMachine.snarePattern = createPattern(seq.value); 
        				break;
        			case 2:
        				drumMachine.hihatPattern = createPattern(seq.value); 
        				break;
        		}
        }
        
        private function onSeqSelect(e:Event):void
        {
        		var seq:PatternSequencer = e.currentTarget as PatternSequencer;
        		switch(seq.id) {
        			case 0:
        				drumMachine.bass.mute = !seq.selected; 
        				break;
        			case 1:
        				drumMachine.snare.mute = !seq.selected; 
        				break;
        			case 2:
        				drumMachine.hihat.mute = !seq.selected; 
        				break;
        		}
        }
        
        
        private function createPattern(pml:String):Vector.<Note>
        {
        		var pp:PMLParser = new PMLParser({"0":new Note(-1,-1,Number.NaN,0), "1":new Note(-1,-1,Number.NaN,1)});
        		var pattern:Vector.<Note> = Vector.<Note>(pp.parse(pml));
        		return pattern;
        }
        
        private var output:Text;
        private function createConsole():void
        {
        		var console:Window = new Window(this, 32, 273, "Console");
        		console.setSize(400, 160);
        		console.hasMinimizeButton = true;
        		output = new Text(console.content, 10, 10);
        		output.setSize(380, 120);
        }
        private function log(s:String):void
        {
        		if(output) {
        			output.text += s + "\n";
        			output.textField.scrollV = output.textField.maxScrollV;
        		}
        }
    }
}

import com.bit101.components.*;
import flash.display.DisplayObjectContainer;
import flash.events.Event;

class PatternSequencer extends Panel
{
	public var id:int;
	private var _patternStr:String = "";
	private var _selected:Boolean = true;
	private 	var _checkBox:CheckBox;
	
	public function PatternSequencer(parent:DisplayObjectContainer = null, xpos:Number = 0, ypos:Number =  0, label:String="") {
		super(parent, xpos, ypos);
		this.setSize(300, 24);
		this.shadow = false;
		
    		for(var i:int=0; i < 16; ++i) {
        		var button:PushButton = new PushButton(this.content, i*15 + 50, 4, "-", onButtonClick);
        		button.setSize(16, 16);
        	}
        	        	
        _checkBox = new CheckBox(this.content, 4, 7, label, onCheckBoxClick);
        _checkBox.selected = _selected;
    }
        
    private function onButtonClick(e:Event):void
    {
        	var button:PushButton = e.currentTarget as PushButton;
        	button.label = (button.label=="-")? "0" : ((button.label=="0")? "1" : "-");
        		
        	var p:String = "";
        	for(var i:int=0; i < 16; ++i) {
        		button = this.content.getChildAt(i) as PushButton;
        		p += button.label;
        	}
        	_patternStr = p;
        	
        	this.dispatchEvent(new Event(Event.CHANGE));
    }
    
    private function onCheckBoxClick(e:Event):void
    {
    		_selected = _checkBox.selected;
    		
    		this.dispatchEvent(new Event(Event.SELECT));
    }
    
    public function get value():String
    {
    		return _patternStr;
    }
    
    public function set value(s:String):void
    {
    		_patternStr = s;
    		for(var i:int=0; i < 16; ++i) {
        		var button:PushButton = this.content.getChildAt(i) as PushButton;
        		button.label = s.charAt(i);
        	}
    }
    	
    	public function get selected():Boolean
    	{
    		return _selected;
    	}
    	
    	public function set selected(v:Boolean):void
    	{
    		_checkBox.selected = _selected = v;
    	}
}