/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5j2w
 */

package {
	import flash.events.Event;
    import flash.display.Sprite;
    import flash.accessibility.Accessibility;
    import flash.display.DisplayObject;
    import flash.geom.Rectangle;
    public class FlashTest extends Sprite {
       
       private var ball:Ball;
       private var line:Sprite;
       private var gravity:Number=0.4;
       private var bounce:Number=-0.5;
       
        public function FlashTest() {
           
       ball=new Ball();
       addChild(ball);
       ball.x=100;
       ball.y=100;
       
       line=new Sprite();
       with(line.graphics){
       	lineStyle(1);
       	lineTo(200,0);
       }
       addChild(line);
       line.x=50;
       line.y=300;
       line.rotation=0;
       
       addEventListener(Event.ENTER_FRAME,onEnter);            
        }
        
        private function onEnter(e:Event):void{
  
        line.rotation=(stage.stageWidth/2-mouseX)*.1;
        
        
        ball.vy+=gravity;
        ball.x+=ball.vx;
        ball.y+=ball.vy;
        
         if(ball.y>stage.stageHeight){
        	ball.y=ball.x=100;
        	ball.vx=ball.vy=0;
        
        }
        
        
        
       var bound:Rectangle=line.getBounds(this);
       if(ball.x>bound.left && ball.x<bound.right){
        	
        
        var angle:Number=line.rotation*Math.PI/180;
        var cos:Number=Math.cos(angle);
        var sin:Number=Math.sin(angle);
        
        var x1:Number=ball.x-line.x;
        var y1:Number=ball.y-line.y;
        
        
        var y2:Number=cos*y1-sin*x1;
        
        
        
        if(y2>-ball.height/2){
        var x2:Number=cos*x1+sin*y1;
        
        var vx1:Number=cos*ball.vx+sin*ball.vy;
        var vy1:Number=cos*ball.vy-sin*ball.vx;
        
        
        
        	y2=-ball.height/2;
        	vy1*=bounce;
      
        
        x1=cos*x2-sin*y2;
        y1=cos*y2+sin*x2;
        ball.vx=cos*vx1-sin*vy1;
        ball.vy=cos*vy1+sin*vx1;
        ball.x=line.x+x1;
        ball.y=line.y+y1;
        
       
        
        }
        }
           }   
        
    }
}
import flash.display.Sprite;

class Ball extends Sprite{
	
	public var radias:uint;
	public var color:uint;
	public var vx:Number=0;
	public var vy:Number=0;
	
	
	function Ball(radias:uint=20,color:uint=0x00000){
		this.color=color;
		this.radias=radias;
		
		graphics.beginFill(color);
		graphics.drawCircle(0,0,radias);
		graphics.endFill();
		
		}
	}