/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/5isC
 */

/**
 *  @kjkmr と @_sakotsu と話してた事の覚え書き。
 *
 *  EventDispatcher のコンストラクタで target を指定することで、
 *  dispatchEvent した時のイベントのターゲットを任意に設定出来るってお話。
 */
package
{
    import flash.display.*;
    import flash.events.*;
    import com.bit101.components.*;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]
    public class Main extends Sprite
    {
        private var _text:Text;
        private var _hoge:Hoge;

        public function Main()
        {
            _text = new Text(this, 5, 5);
            _text.editable = false;
            _text.setSize(655, 455);

            _hoge = new Hoge();
            _hoge.addEventListener(Event.COMPLETE, _onComplete);
            _hoge.dispatchEvent(new Event(Event.COMPLETE));
        }

        private function _onComplete(evt:Event):void
        {
            _text.text = String(evt.target);
        }
    }
}


import flash.events.*;

internal class Hoge implements IEventDispatcher
{
    private var _signal:EventDispatcher;

    /**
     *  Constructor.
     */
    public function Hoge()
    {
    }

    /**
     *  @inheritDoc
     */
    public function addEventListener(type:String, listener:Function, useCapture:Boolean=false, priority:int=0, useWeakReference:Boolean=false):void
    {
        _signal ||= new EventDispatcher(this);
        _signal.addEventListener(type, listener, useCapture, priority, useWeakReference);
    }

    /**
     *  @inheritDoc
     */
    public function dispatchEvent(event:Event):Boolean
    {
        _signal ||= new EventDispatcher(this);
        return _signal.dispatchEvent(event);
    }

    /**
     *  @inheritDoc
     */
    public function hasEventListener(type:String):Boolean
    {
        return _signal ? _signal.hasEventListener(type) : false;
    }

    /**
     *  @inheritDoc
     */
    public function removeEventListener(type:String, listener:Function, useCapture:Boolean=false):void
    {
        if (_signal) {
            _signal.removeEventListener(type, listener, useCapture);
        }
    }

    /**
     *  @inheritDoc
     */
    public function willTrigger(type:String):Boolean
    {
        return _signal ? _signal.willTrigger(type) : false;
    }
}
